/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.UncloseableDelegatingFileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.extension.pagecache.PageCacheSupportExtension;
import org.neo4j.test.limited.LimitedFilesystemAbstraction;

@Neo4jLayoutExtension
class RunOutOfDiskSpaceIT {
    @RegisterExtension
    static PageCacheSupportExtension pageCacheExtension = new PageCacheSupportExtension();
    @Inject
    FileSystemAbstraction fileSystem;
    @Inject
    DatabaseLayout databaseLayout;
    private LimitedFilesystemAbstraction limitedFs;
    private GraphDatabaseAPI database;
    private DatabaseManagementService managementService;

    RunOutOfDiskSpaceIT() {
    }

    @BeforeEach
    void setUp() {
        this.limitedFs = new LimitedFilesystemAbstraction((FileSystemAbstraction)new UncloseableDelegatingFileSystemAbstraction(this.fileSystem));
        this.managementService = new TestDatabaseManagementServiceBuilder(this.databaseLayout).setFileSystem((FileSystemAbstraction)this.limitedFs).build();
        this.database = (GraphDatabaseAPI)this.managementService.database("neo4j");
    }

    @Test
    void shouldPropagateIOExceptions() throws Exception {
        try (Transaction tx = this.database.beginTx();){
            tx.createNode();
            tx.commit();
        }
        long logVersion = ((LogVersionRepository)this.database.getDependencyResolver().resolveDependency(LogVersionRepository.class)).getCurrentLogVersion();
        this.limitedFs.runOutOfDiskSpace(true);
        TransactionFailureException exception = (TransactionFailureException)Assertions.assertThrows(TransactionFailureException.class, () -> {
            try (Transaction tx = this.database.beginTx();){
                tx.createNode();
                tx.commit();
            }
        });
        Assertions.assertTrue((ExceptionUtils.indexOfThrowable((Throwable)exception, IOException.class) != -1 ? 1 : 0) != 0);
        this.limitedFs.runOutOfDiskSpace(false);
        this.managementService.shutdown();
        PageCache pageCache = pageCacheExtension.getPageCache((FileSystemAbstraction)this.limitedFs);
        File neoStore = this.databaseLayout.metadataStore();
        Assertions.assertEquals((long)logVersion, (long)MetaDataStore.getRecord((PageCache)pageCache, (File)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LOG_VERSION, (PageCursorTracer)PageCursorTracer.NULL));
    }

    @Test
    void shouldStopDatabaseWhenOutOfDiskSpace() throws Exception {
        try (Transaction tx = this.database.beginTx();){
            tx.createNode();
            tx.commit();
        }
        long logVersion = ((LogVersionRepository)this.database.getDependencyResolver().resolveDependency(LogVersionRepository.class)).getCurrentLogVersion();
        this.limitedFs.runOutOfDiskSpace(true);
        Assertions.assertThrows(TransactionFailureException.class, () -> {
            try (Transaction tx = this.database.beginTx();){
                tx.createNode();
                tx.commit();
            }
        });
        Assertions.assertThrows(TransactionFailureException.class, () -> {
            try (Transaction ignored = this.database.beginTx();){
                Assertions.fail((String)"Expected tx begin to throw TransactionFailureException when tx manager breaks.");
            }
        });
        this.limitedFs.runOutOfDiskSpace(false);
        this.managementService.shutdown();
        PageCache pageCache = pageCacheExtension.getPageCache((FileSystemAbstraction)this.limitedFs);
        File neoStore = this.databaseLayout.metadataStore();
        Assertions.assertEquals((long)logVersion, (long)MetaDataStore.getRecord((PageCache)pageCache, (File)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LOG_VERSION, (PageCursorTracer)PageCursorTracer.NULL));
    }
}

