/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.IntPredicate;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.Kernel;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.SchemaTestUtil;
import org.neo4j.kernel.impl.api.DatabaseSchemaState;
import org.neo4j.kernel.impl.api.index.FailedIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.kernel.impl.api.index.IndexProxyFactory;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.api.index.TestIndexProviderDescriptor;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.transaction.state.DefaultIndexProviderMap;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogAssert;
import org.neo4j.logging.LogAssertions;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.EntityTokenUpdate;
import org.neo4j.storageengine.api.EntityUpdates;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.test.DoubleLatch;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class IndexPopulationJobTest {
    private GraphDatabaseAPI db;
    private static final Label FIRST = Label.label((String)"FIRST");
    private static final Label SECOND = Label.label((String)"SECOND");
    private static final String name = "name";
    private static final String age = "age";
    private static final RelationshipType likes = RelationshipType.withName((String)"likes");
    private static final RelationshipType knows = RelationshipType.withName((String)"knows");
    private final TokenNameLookup tokenNameLookup = SchemaTestUtil.SIMPLE_NAME_LOOKUP;
    private Kernel kernel;
    private TokenNameLookup tokens;
    private IndexStoreView indexStoreView;
    private DatabaseSchemaState stateHolder;
    private int labelId;
    private IndexStatisticsStore indexStatisticsStore;
    private DatabaseManagementService managementService;
    private JobScheduler jobScheduler;

    IndexPopulationJobTest() {
    }

    @BeforeEach
    void before() throws Exception {
        this.managementService = new TestDatabaseManagementServiceBuilder().impermanent().build();
        this.db = (GraphDatabaseAPI)this.managementService.database("neo4j");
        this.kernel = (Kernel)this.db.getDependencyResolver().resolveDependency(Kernel.class);
        this.tokens = (TokenNameLookup)this.db.getDependencyResolver().resolveDependency(TokenNameLookup.class);
        this.stateHolder = new DatabaseSchemaState((LogProvider)NullLogProvider.getInstance());
        this.indexStoreView = this.indexStoreView();
        this.indexStatisticsStore = (IndexStatisticsStore)this.db.getDependencyResolver().resolveDependency(IndexStatisticsStore.class);
        this.jobScheduler = (JobScheduler)this.db.getDependencyResolver().resolveDependency(JobScheduler.class);
        try (KernelTransaction tx = this.kernel.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);){
            this.labelId = tx.tokenWrite().labelGetOrCreateForName(FIRST.name());
            tx.tokenWrite().labelGetOrCreateForName(SECOND.name());
            tx.commit();
        }
    }

    @AfterEach
    void after() {
        this.managementService.shutdown();
    }

    @Test
    void shouldPopulateIndexWithOneNode() throws Exception {
        String value = "Taylor";
        long nodeId = this.createNode(MapUtil.map((Object[])new Object[]{name, value}), FIRST);
        IndexPopulator actualPopulator = this.indexPopulator(false);
        TrackingIndexPopulator populator = new TrackingIndexPopulator(actualPopulator);
        LabelSchemaDescriptor descriptor = SchemaDescriptor.forLabel((int)0, (int[])new int[]{0});
        IndexPopulationJob job = this.newIndexPopulationJob((IndexPopulator)populator, new FlippableIndexProxy(), EntityType.NODE, IndexPrototype.forSchema((SchemaDescriptor)descriptor));
        job.run();
        IndexEntryUpdate update = IndexEntryUpdate.add((long)nodeId, (SchemaDescriptorSupplier)descriptor, (Value[])new Value[]{Values.of((Object)value)});
        Assertions.assertTrue((boolean)populator.created);
        Assertions.assertEquals(Collections.singletonList(update), populator.includedSamples);
        Assertions.assertEquals((int)2, (int)populator.adds.size());
        Assertions.assertTrue((boolean)populator.resultSampled);
        Assertions.assertTrue((boolean)populator.closeCall);
    }

    @Test
    void tracePageCacheAccessIndexWithOneNodePopulation() throws KernelException {
        String value = "value";
        long nodeId = this.createNode(MapUtil.map((Object[])new Object[]{name, value}), FIRST);
        IndexPopulator actualPopulator = this.indexPopulator(false);
        TrackingIndexPopulator populator = new TrackingIndexPopulator(actualPopulator);
        LabelSchemaDescriptor descriptor = SchemaDescriptor.forLabel((int)0, (int[])new int[]{0});
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer();
        IndexPopulationJob job = this.newIndexPopulationJob((IndexPopulator)populator, new FlippableIndexProxy(), EntityType.NODE, IndexPrototype.forSchema((SchemaDescriptor)descriptor), (PageCacheTracer)pageCacheTracer);
        job.run();
        IndexEntryUpdate update = IndexEntryUpdate.add((long)nodeId, (SchemaDescriptorSupplier)descriptor, (Value[])new Value[]{Values.of((Object)value)});
        Assertions.assertTrue((boolean)populator.created);
        Assertions.assertEquals(Collections.singletonList(update), populator.includedSamples);
        Assertions.assertEquals((int)2, (int)populator.adds.size());
        Assertions.assertTrue((boolean)populator.resultSampled);
        Assertions.assertTrue((boolean)populator.closeCall);
        LogAssertions.assertThat((long)pageCacheTracer.pins()).isEqualTo(19L);
        LogAssertions.assertThat((long)pageCacheTracer.unpins()).isEqualTo(19L);
        LogAssertions.assertThat((long)pageCacheTracer.hits()).isEqualTo(18L);
        LogAssertions.assertThat((long)pageCacheTracer.faults()).isEqualTo(1L);
    }

    @Test
    void shouldPopulateIndexWithOneRelationship() {
        String value = "Taylor";
        long nodeId = this.createNode(MapUtil.map((Object[])new Object[]{name, value}), FIRST);
        long relationship = this.createRelationship(MapUtil.map((Object[])new Object[]{name, age}), likes, nodeId, nodeId);
        IndexPrototype descriptor = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forRelType((int)0, (int[])new int[]{0}));
        IndexPopulator actualPopulator = this.indexPopulator(descriptor);
        TrackingIndexPopulator populator = new TrackingIndexPopulator(actualPopulator);
        IndexPopulationJob job = this.newIndexPopulationJob((IndexPopulator)populator, new FlippableIndexProxy(), EntityType.RELATIONSHIP, descriptor);
        job.run();
        IndexEntryUpdate update = IndexEntryUpdate.add((long)relationship, (SchemaDescriptorSupplier)descriptor, (Value[])new Value[]{Values.of((Object)age)});
        Assertions.assertTrue((boolean)populator.created);
        Assertions.assertEquals(Collections.singletonList(update), populator.includedSamples);
        Assertions.assertEquals((int)2, (int)populator.adds.size());
        Assertions.assertTrue((boolean)populator.resultSampled);
        Assertions.assertTrue((boolean)populator.closeCall);
    }

    @Test
    void tracePageCacheAccessIndexWithOneRelationship() {
        String value = "value";
        long nodeId = this.createNode(MapUtil.map((Object[])new Object[]{name, value}), FIRST);
        long relationship = this.createRelationship(MapUtil.map((Object[])new Object[]{name, age}), likes, nodeId, nodeId);
        IndexPrototype descriptor = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forRelType((int)0, (int[])new int[]{0}));
        IndexPopulator actualPopulator = this.indexPopulator(descriptor);
        TrackingIndexPopulator populator = new TrackingIndexPopulator(actualPopulator);
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer();
        IndexPopulationJob job = this.newIndexPopulationJob((IndexPopulator)populator, new FlippableIndexProxy(), EntityType.RELATIONSHIP, descriptor, (PageCacheTracer)pageCacheTracer);
        job.run();
        IndexEntryUpdate update = IndexEntryUpdate.add((long)relationship, (SchemaDescriptorSupplier)descriptor, (Value[])new Value[]{Values.of((Object)age)});
        Assertions.assertTrue((boolean)populator.created);
        Assertions.assertEquals(Collections.singletonList(update), populator.includedSamples);
        Assertions.assertEquals((int)2, (int)populator.adds.size());
        Assertions.assertTrue((boolean)populator.resultSampled);
        Assertions.assertTrue((boolean)populator.closeCall);
        LogAssertions.assertThat((long)pageCacheTracer.pins()).isEqualTo(17L);
        LogAssertions.assertThat((long)pageCacheTracer.unpins()).isEqualTo(17L);
        LogAssertions.assertThat((long)pageCacheTracer.hits()).isEqualTo(16L);
        LogAssertions.assertThat((long)pageCacheTracer.faults()).isEqualTo(1L);
    }

    @Test
    void shouldFlushSchemaStateAfterPopulation() throws Exception {
        String value = "Taylor";
        this.createNode(MapUtil.map((Object[])new Object[]{name, value}), FIRST);
        this.stateHolder.put((Object)"key", (Object)"original_value");
        IndexPopulator populator = this.indexPopulator(false);
        IndexPopulationJob job = this.newIndexPopulationJob(populator, new FlippableIndexProxy(), EntityType.NODE, this.indexPrototype(FIRST, name, false));
        job.run();
        String result = (String)this.stateHolder.get((Object)"key");
        Assertions.assertNull((Object)result);
    }

    @Test
    void shouldPopulateIndexWithASmallDataset() throws Exception {
        String value = "Mattias";
        long node1 = this.createNode(MapUtil.map((Object[])new Object[]{name, value}), FIRST);
        this.createNode(MapUtil.map((Object[])new Object[]{name, value}), SECOND);
        this.createNode(MapUtil.map((Object[])new Object[]{age, 31}), FIRST);
        long node4 = this.createNode(MapUtil.map((Object[])new Object[]{age, 35, name, value}), FIRST);
        IndexPopulator actualPopulator = this.indexPopulator(false);
        TrackingIndexPopulator populator = new TrackingIndexPopulator(actualPopulator);
        LabelSchemaDescriptor descriptor = SchemaDescriptor.forLabel((int)0, (int[])new int[]{0});
        IndexPopulationJob job = this.newIndexPopulationJob((IndexPopulator)populator, new FlippableIndexProxy(), EntityType.NODE, IndexPrototype.forSchema((SchemaDescriptor)descriptor));
        job.run();
        IndexEntryUpdate update1 = IndexEntryUpdate.add((long)node1, (SchemaDescriptorSupplier)descriptor, (Value[])new Value[]{Values.of((Object)value)});
        IndexEntryUpdate update2 = IndexEntryUpdate.add((long)node4, (SchemaDescriptorSupplier)descriptor, (Value[])new Value[]{Values.of((Object)value)});
        Assertions.assertTrue((boolean)populator.created);
        Assertions.assertEquals(Arrays.asList(update1, update2), populator.includedSamples);
        Assertions.assertEquals((int)2, (int)populator.adds.size());
        Assertions.assertTrue((boolean)populator.resultSampled);
        Assertions.assertTrue((boolean)populator.closeCall);
    }

    @Test
    void shouldPopulateRelatonshipIndexWithASmallDataset() {
        String value = "Philip J.Fry";
        long node1 = this.createNode(MapUtil.map((Object[])new Object[]{name, value}), FIRST);
        long node2 = this.createNode(MapUtil.map((Object[])new Object[]{name, value}), SECOND);
        long node3 = this.createNode(MapUtil.map((Object[])new Object[]{age, 31}), FIRST);
        long node4 = this.createNode(MapUtil.map((Object[])new Object[]{age, 35, name, value}), FIRST);
        long rel1 = this.createRelationship(MapUtil.map((Object[])new Object[]{name, value}), likes, node1, node3);
        this.createRelationship(MapUtil.map((Object[])new Object[]{name, value}), knows, node3, node1);
        this.createRelationship(MapUtil.map((Object[])new Object[]{age, 31}), likes, node2, node1);
        long rel4 = this.createRelationship(MapUtil.map((Object[])new Object[]{age, 35, name, value}), likes, node4, node4);
        IndexPrototype descriptor = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forRelType((int)0, (int[])new int[]{0}));
        IndexPopulator actualPopulator = this.indexPopulator(descriptor);
        TrackingIndexPopulator populator = new TrackingIndexPopulator(actualPopulator);
        IndexPopulationJob job = this.newIndexPopulationJob((IndexPopulator)populator, new FlippableIndexProxy(), EntityType.RELATIONSHIP, descriptor);
        job.run();
        IndexEntryUpdate update1 = IndexEntryUpdate.add((long)rel1, (SchemaDescriptorSupplier)descriptor, (Value[])new Value[]{Values.of((Object)value)});
        IndexEntryUpdate update2 = IndexEntryUpdate.add((long)rel4, (SchemaDescriptorSupplier)descriptor, (Value[])new Value[]{Values.of((Object)value)});
        Assertions.assertTrue((boolean)populator.created);
        Assertions.assertEquals(Arrays.asList(update1, update2), populator.includedSamples);
        Assertions.assertEquals((int)2, (int)populator.adds.size());
        Assertions.assertTrue((boolean)populator.resultSampled);
        Assertions.assertTrue((boolean)populator.closeCall);
    }

    @Test
    void shouldIndexConcurrentUpdatesWhilePopulating() throws Exception {
        String value1 = "Mattias";
        String value2 = "Jacob";
        String value3 = "Stefan";
        String changedValue = "changed";
        long node1 = this.createNode(MapUtil.map((Object[])new Object[]{name, value1}), FIRST);
        long node2 = this.createNode(MapUtil.map((Object[])new Object[]{name, value2}), FIRST);
        long node3 = this.createNode(MapUtil.map((Object[])new Object[]{name, value3}), FIRST);
        long changeNode = node1;
        int propertyKeyId = this.getPropertyKeyForName(name);
        NodeChangingWriter populator = new NodeChangingWriter(changeNode, propertyKeyId, value1, changedValue, this.labelId);
        IndexPopulationJob job = this.newIndexPopulationJob((IndexPopulator)populator, new FlippableIndexProxy(), EntityType.NODE, this.indexPrototype(FIRST, name, false));
        populator.setJob(job);
        job.run();
        Set expected = Iterators.asSet((Object[])new Pair[]{Pair.of((Object)node1, (Object)value1), Pair.of((Object)node2, (Object)value2), Pair.of((Object)node3, (Object)value3), Pair.of((Object)node1, (Object)changedValue)});
        Assertions.assertEquals((Object)expected, populator.added);
    }

    @Test
    void shouldRemoveViaConcurrentIndexUpdatesWhilePopulating() throws Exception {
        String value1 = "Mattias";
        String value2 = "Jacob";
        String value3 = "Stefan";
        long node1 = this.createNode(MapUtil.map((Object[])new Object[]{name, value1}), FIRST);
        long node2 = this.createNode(MapUtil.map((Object[])new Object[]{name, value2}), FIRST);
        long node3 = this.createNode(MapUtil.map((Object[])new Object[]{name, value3}), FIRST);
        int propertyKeyId = this.getPropertyKeyForName(name);
        NodeDeletingWriter populator = new NodeDeletingWriter(node2, propertyKeyId, value2, this.labelId);
        IndexPopulationJob job = this.newIndexPopulationJob((IndexPopulator)populator, new FlippableIndexProxy(), EntityType.NODE, this.indexPrototype(FIRST, name, false));
        populator.setJob(job);
        job.run();
        Map expectedAdded = MapUtil.genericMap((Object[])new Object[]{node1, value1, node2, value2, node3, value3});
        Assertions.assertEquals((Object)expectedAdded, populator.added);
        Map expectedRemoved = MapUtil.genericMap((Object[])new Object[]{node2, value2});
        Assertions.assertEquals((Object)expectedRemoved, populator.removed);
    }

    @Test
    void shouldTransitionToFailedStateIfPopulationJobCrashes() throws Exception {
        IndexPopulator failingPopulator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
        ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("BORK BORK")}).when((Object)failingPopulator)).add((Collection)ArgumentMatchers.any(Collection.class), (PageCursorTracer)ArgumentMatchers.any(PageCursorTracer.class));
        FlippableIndexProxy index = new FlippableIndexProxy();
        this.createNode(MapUtil.map((Object[])new Object[]{name, "Taylor"}), FIRST);
        IndexPopulationJob job = this.newIndexPopulationJob(failingPopulator, index, EntityType.NODE, this.indexPrototype(FIRST, name, false));
        job.run();
        LogAssertions.assertThat((Comparable)index.getState()).isEqualTo((Object)InternalIndexState.FAILED);
    }

    @Test
    void shouldBeAbleToStopPopulationJob() throws Exception {
        this.createNode(MapUtil.map((Object[])new Object[]{name, "Mattias"}), FIRST);
        IndexPopulator populator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
        FlippableIndexProxy index = (FlippableIndexProxy)Mockito.mock(FlippableIndexProxy.class);
        IndexStoreView storeView = (IndexStoreView)Mockito.mock(IndexStoreView.class);
        ControlledStoreScan storeScan = new ControlledStoreScan();
        Mockito.when((Object)storeView.visitNodes((int[])ArgumentMatchers.any(int[].class), (IntPredicate)ArgumentMatchers.any(IntPredicate.class), (Visitor)ArgumentMatchers.any(), (Visitor)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (PageCursorTracer)ArgumentMatchers.any(), (MemoryTracker)ArgumentMatchers.any())).thenReturn((Object)storeScan);
        Mockito.when((Object)storeView.newPropertyAccessor((PageCursorTracer)ArgumentMatchers.any(PageCursorTracer.class), (MemoryTracker)ArgumentMatchers.any())).thenReturn((Object)((NodePropertyAccessor)Mockito.mock(NodePropertyAccessor.class)));
        IndexPopulationJob job = this.newIndexPopulationJob(populator, index, storeView, (LogProvider)NullLogProvider.getInstance(), EntityType.NODE, this.indexPrototype(FIRST, name, false));
        JobHandle jobHandle = (JobHandle)Mockito.mock(JobHandle.class);
        job.setHandle(jobHandle);
        try (OtherThreadExecutor populationJobRunner = new OtherThreadExecutor("Population job test runner", null);){
            Future runFuture = populationJobRunner.executeDontWait(state -> {
                job.run();
                return null;
            });
            storeScan.latch.waitForAllToStart();
            job.stop();
            job.awaitCompletion(0L, TimeUnit.SECONDS);
            storeScan.latch.waitForAllToFinish();
            runFuture.get();
        }
        ((IndexPopulator)Mockito.verify((Object)populator)).close(false, PageCursorTracer.NULL);
        ((FlippableIndexProxy)Mockito.verify((Object)index, (VerificationMode)Mockito.never())).flip((Callable)ArgumentMatchers.any(), (FailedIndexProxyFactory)ArgumentMatchers.any());
        ((JobHandle)Mockito.verify((Object)jobHandle)).cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldLogJobProgress() throws Exception {
        this.createNode(MapUtil.map((Object[])new Object[]{name, "irrelephant"}), FIRST);
        AssertableLogProvider logProvider = new AssertableLogProvider();
        FlippableIndexProxy index = (FlippableIndexProxy)Mockito.mock(FlippableIndexProxy.class);
        Mockito.when((Object)index.getState()).thenReturn((Object)InternalIndexState.ONLINE);
        IndexPopulator populator = this.indexPopulator(false);
        try {
            IndexPopulationJob job = this.newIndexPopulationJob(populator, index, this.indexStoreView, (LogProvider)logProvider, EntityType.NODE, this.indexPrototype(FIRST, name, false));
            job.run();
            LogAssert matcher = LogAssertions.assertThat((AssertableLogProvider)logProvider).forClass(IndexPopulationJob.class).forLevel(AssertableLogProvider.Level.INFO);
            matcher.containsMessageWithArguments("Index population started: [%s]", new Object[]{":FIRST(name)"}).containsMessages(new String[]{"TIME/PHASE Final: SCAN["});
        }
        finally {
            populator.close(true, PageCursorTracer.NULL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void logConstraintJobProgress() throws Exception {
        this.createNode(MapUtil.map((Object[])new Object[]{name, "irrelephant"}), FIRST);
        AssertableLogProvider logProvider = new AssertableLogProvider();
        FlippableIndexProxy index = (FlippableIndexProxy)Mockito.mock(FlippableIndexProxy.class);
        Mockito.when((Object)index.getState()).thenReturn((Object)InternalIndexState.POPULATING);
        IndexPopulator populator = this.indexPopulator(false);
        try {
            IndexPopulationJob job = this.newIndexPopulationJob(populator, index, this.indexStoreView, (LogProvider)logProvider, EntityType.NODE, this.indexPrototype(FIRST, name, true));
            job.run();
            LogAssert matcher = LogAssertions.assertThat((AssertableLogProvider)logProvider).forClass(IndexPopulationJob.class).forLevel(AssertableLogProvider.Level.INFO);
            matcher.containsMessageWithArguments("Index population started: [%s]", new Object[]{":FIRST(name)"}).containsMessages(new String[]{"TIME/PHASE Final: SCAN["});
        }
        finally {
            populator.close(true, PageCursorTracer.NULL);
        }
    }

    @Test
    void shouldLogJobFailure() throws Exception {
        this.createNode(MapUtil.map((Object[])new Object[]{name, "irrelephant"}), FIRST);
        AssertableLogProvider logProvider = new AssertableLogProvider();
        FlippableIndexProxy index = (FlippableIndexProxy)Mockito.mock(FlippableIndexProxy.class);
        IndexPopulator populator = (IndexPopulator)Mockito.spy((Object)this.indexPopulator(false));
        IndexPopulationJob job = this.newIndexPopulationJob(populator, index, this.indexStoreView, (LogProvider)logProvider, EntityType.NODE, this.indexPrototype(FIRST, name, false));
        IllegalStateException failure = new IllegalStateException("not successful");
        ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{failure}).when((Object)populator)).create();
        job.run();
        LogAssertions.assertThat((AssertableLogProvider)logProvider).forClass(IndexPopulationJob.class).forLevel(AssertableLogProvider.Level.ERROR).containsMessageWithException("Failed to populate index: [:FIRST(name)]", (Throwable)failure);
    }

    @Test
    void shouldFlipToFailedUsingFailedIndexProxyFactory() throws Exception {
        FailedIndexProxyFactory failureDelegateFactory = (FailedIndexProxyFactory)Mockito.mock(FailedIndexProxyFactory.class);
        IndexPopulator populator = (IndexPopulator)Mockito.spy((Object)this.indexPopulator(false));
        IndexPopulationJob job = this.newIndexPopulationJob(failureDelegateFactory, populator, new FlippableIndexProxy(), this.indexStoreView, (LogProvider)NullLogProvider.getInstance(), EntityType.NODE, this.indexPrototype(FIRST, name, false), PageCacheTracer.NULL);
        IllegalStateException failure = new IllegalStateException("not successful");
        ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{failure}).when((Object)populator)).close(true, PageCursorTracer.NULL);
        job.run();
        ((FailedIndexProxyFactory)Mockito.verify((Object)failureDelegateFactory)).create((Throwable)ArgumentMatchers.any(Throwable.class));
    }

    @Test
    void shouldCloseAndFailOnFailure() throws Exception {
        this.createNode(MapUtil.map((Object[])new Object[]{name, "irrelephant"}), FIRST);
        NullLogProvider logProvider = NullLogProvider.getInstance();
        FlippableIndexProxy index = (FlippableIndexProxy)Mockito.mock(FlippableIndexProxy.class);
        IndexPopulator populator = (IndexPopulator)Mockito.spy((Object)this.indexPopulator(false));
        IndexPopulationJob job = this.newIndexPopulationJob(populator, index, this.indexStoreView, (LogProvider)logProvider, EntityType.NODE, this.indexPrototype(FIRST, name, false));
        String failureMessage = "not successful";
        IllegalStateException failure = new IllegalStateException(failureMessage);
        ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{failure}).when((Object)populator)).create();
        job.run();
        ((IndexPopulator)Mockito.verify((Object)populator)).markAsFailed(ArgumentMatchers.contains((String)failureMessage));
    }

    @Test
    void shouldCloseMultiPopulatorOnSuccessfulPopulation() {
        NullLogProvider logProvider = NullLogProvider.getInstance();
        TrackingMultipleIndexPopulator populator = new TrackingMultipleIndexPopulator(IndexStoreView.EMPTY, (LogProvider)logProvider, EntityType.NODE, (SchemaState)new DatabaseSchemaState((LogProvider)logProvider), (IndexStatisticsStore)Mockito.mock(IndexStatisticsStore.class), this.jobScheduler, this.tokens);
        IndexPopulationJob populationJob = new IndexPopulationJob((MultipleIndexPopulator)populator, IndexingService.NO_MONITOR, false, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        populationJob.run();
        Assertions.assertTrue((boolean)populator.closed);
    }

    @Test
    void shouldCloseMultiPopulatorOnFailedPopulation() {
        NullLogProvider logProvider = NullLogProvider.getInstance();
        IndexStoreView.Adaptor failingStoreView = new IndexStoreView.Adaptor(){

            public <FAILURE extends Exception> StoreScan<FAILURE> visitNodes(int[] labelIds, IntPredicate propertyKeyIdFilter, Visitor<EntityUpdates, FAILURE> propertyUpdateVisitor, Visitor<EntityTokenUpdate, FAILURE> labelUpdateVisitor, boolean forceStoreScan, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
                return new StoreScan<FAILURE>(){

                    public void run() {
                        throw new RuntimeException("Just failing");
                    }

                    public void stop() {
                    }

                    public void acceptUpdate(MultipleIndexPopulator.MultipleIndexUpdater updater, IndexEntryUpdate<?> update, long currentlyIndexedNodeId) {
                    }

                    public PopulationProgress getProgress() {
                        return null;
                    }
                };
            }
        };
        TrackingMultipleIndexPopulator populator = new TrackingMultipleIndexPopulator((IndexStoreView)failingStoreView, (LogProvider)logProvider, EntityType.NODE, (SchemaState)new DatabaseSchemaState((LogProvider)logProvider), (IndexStatisticsStore)Mockito.mock(IndexStatisticsStore.class), this.jobScheduler, this.tokens);
        IndexPopulationJob populationJob = new IndexPopulationJob((MultipleIndexPopulator)populator, IndexingService.NO_MONITOR, false, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        populationJob.run();
        Assertions.assertTrue((boolean)populator.closed);
    }

    private IndexPopulator indexPopulator(boolean constraint) throws KernelException {
        IndexPrototype prototype = this.indexPrototype(FIRST, name, constraint);
        return this.indexPopulator(prototype);
    }

    private IndexPopulator indexPopulator(IndexPrototype prototype) {
        IndexSamplingConfig samplingConfig = new IndexSamplingConfig(Config.defaults());
        IndexProvider indexProvider = ((DefaultIndexProviderMap)this.db.getDependencyResolver().resolveDependency(DefaultIndexProviderMap.class)).getDefaultProvider();
        IndexDescriptor indexDescriptor = prototype.withName("index_21").materialise(21L);
        indexDescriptor = indexProvider.completeConfiguration(indexDescriptor);
        return indexProvider.getPopulator(indexDescriptor, samplingConfig, ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.tokenNameLookup);
    }

    private IndexPopulationJob newIndexPopulationJob(IndexPopulator populator, FlippableIndexProxy flipper, EntityType type, IndexPrototype prototype) {
        return this.newIndexPopulationJob(populator, flipper, this.indexStoreView, (LogProvider)NullLogProvider.getInstance(), type, prototype, PageCacheTracer.NULL);
    }

    private IndexPopulationJob newIndexPopulationJob(IndexPopulator populator, FlippableIndexProxy flipper, EntityType type, IndexPrototype prototype, PageCacheTracer cacheTracer) {
        return this.newIndexPopulationJob(populator, flipper, this.indexStoreView, (LogProvider)NullLogProvider.getInstance(), type, prototype, cacheTracer);
    }

    private IndexPopulationJob newIndexPopulationJob(IndexPopulator populator, FlippableIndexProxy flipper, IndexStoreView storeView, LogProvider logProvider, EntityType type, IndexPrototype prototype, PageCacheTracer pageCacheTracer) {
        return this.newIndexPopulationJob((FailedIndexProxyFactory)Mockito.mock(FailedIndexProxyFactory.class), populator, flipper, storeView, logProvider, type, prototype, pageCacheTracer);
    }

    private IndexPopulationJob newIndexPopulationJob(IndexPopulator populator, FlippableIndexProxy flipper, IndexStoreView storeView, LogProvider logProvider, EntityType type, IndexPrototype prototype) {
        return this.newIndexPopulationJob((FailedIndexProxyFactory)Mockito.mock(FailedIndexProxyFactory.class), populator, flipper, storeView, logProvider, type, prototype, PageCacheTracer.NULL);
    }

    private IndexPopulationJob newIndexPopulationJob(FailedIndexProxyFactory failureDelegateFactory, IndexPopulator populator, FlippableIndexProxy flipper, IndexStoreView storeView, LogProvider logProvider, EntityType type, IndexPrototype prototype, PageCacheTracer pageCacheTracer) {
        long indexId = 0L;
        flipper.setFlipTarget((IndexProxyFactory)Mockito.mock(IndexProxyFactory.class));
        MultipleIndexPopulator multiPopulator = new MultipleIndexPopulator(storeView, logProvider, type, (SchemaState)this.stateHolder, this.indexStatisticsStore, this.jobScheduler, this.tokens, pageCacheTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        IndexPopulationJob job = new IndexPopulationJob(multiPopulator, IndexingService.NO_MONITOR, false, pageCacheTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        IndexDescriptor descriptor = prototype.withName("index_" + indexId).materialise(indexId);
        job.addPopulator(populator, descriptor, String.format(":%s(%s)", FIRST.name(), name), flipper, failureDelegateFactory);
        return job;
    }

    private IndexPrototype indexPrototype(Label label, String propertyKey, boolean constraint) throws KernelException {
        try (KernelTransaction tx = this.kernel.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);){
            int labelId = tx.tokenWrite().labelGetOrCreateForName(label.name());
            int propertyKeyId = tx.tokenWrite().propertyKeyGetOrCreateForName(propertyKey);
            LabelSchemaDescriptor schema = SchemaDescriptor.forLabel((int)labelId, (int[])new int[]{propertyKeyId});
            IndexPrototype descriptor = constraint ? IndexPrototype.uniqueForSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR) : IndexPrototype.forSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
            tx.commit();
            IndexPrototype indexPrototype = descriptor;
            return indexPrototype;
        }
    }

    private long createNode(Map<String, Object> properties, Label ... labels) {
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode(labels);
            for (Map.Entry<String, Object> property : properties.entrySet()) {
                node.setProperty(property.getKey(), property.getValue());
            }
            tx.commit();
            long l = node.getId();
            return l;
        }
    }

    private long createRelationship(Map<String, Object> properties, RelationshipType relType, long fromNode, long toNode) {
        try (Transaction tx = this.db.beginTx();){
            Node node1 = tx.getNodeById(fromNode);
            Node node2 = tx.getNodeById(toNode);
            Relationship relationship = node1.createRelationshipTo(node2, relType);
            for (Map.Entry<String, Object> property : properties.entrySet()) {
                relationship.setProperty(property.getKey(), property.getValue());
            }
            tx.commit();
            long l = relationship.getId();
            return l;
        }
    }

    private int getPropertyKeyForName(String name) throws TransactionFailureException {
        try (KernelTransaction tx = this.kernel.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);){
            int result = tx.tokenRead().propertyKey(name);
            tx.commit();
            int n = result;
            return n;
        }
    }

    private IndexStoreView indexStoreView() {
        return (IndexStoreView)this.db.getDependencyResolver().resolveDependency(IndexStoreView.class);
    }

    private static class TrackingIndexPopulator
    extends IndexPopulator.Delegating {
        private volatile boolean created;
        private final List<Collection<? extends IndexEntryUpdate<?>>> adds = new ArrayList();
        private volatile Boolean closeCall;
        private final List<IndexEntryUpdate<?>> includedSamples = new ArrayList();
        private volatile boolean resultSampled;

        TrackingIndexPopulator(IndexPopulator delegate) {
            super(delegate);
        }

        public void create() {
            this.created = true;
            super.create();
        }

        public void add(Collection<? extends IndexEntryUpdate<?>> updates, PageCursorTracer cursorTracer) throws IndexEntryConflictException {
            this.adds.add(updates);
            super.add(updates, cursorTracer);
        }

        public void close(boolean populationCompletedSuccessfully, PageCursorTracer cursorTracer) {
            this.closeCall = populationCompletedSuccessfully;
            super.close(populationCompletedSuccessfully, cursorTracer);
        }

        public void includeSample(IndexEntryUpdate<?> update) {
            this.includedSamples.add(update);
            super.includeSample(update);
        }

        public IndexSample sample(PageCursorTracer cursorTracer) {
            this.resultSampled = true;
            return super.sample(cursorTracer);
        }
    }

    private static class TrackingMultipleIndexPopulator
    extends MultipleIndexPopulator {
        private volatile boolean closed;

        TrackingMultipleIndexPopulator(IndexStoreView storeView, LogProvider logProvider, EntityType type, SchemaState schemaState, IndexStatisticsStore indexStatisticsStore, JobScheduler jobScheduler, TokenNameLookup tokens) {
            super(storeView, logProvider, type, schemaState, indexStatisticsStore, jobScheduler, tokens, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }

        public void close() {
            this.closed = true;
            super.close();
        }
    }

    private static class NodeDeletingWriter
    extends IndexPopulator.Adapter {
        private final Map<Long, Object> added = new HashMap<Long, Object>();
        private final Map<Long, Object> removed = new HashMap<Long, Object>();
        private final long nodeToDelete;
        private IndexPopulationJob job;
        private final Value valueToDelete;
        private final LabelSchemaDescriptor index;

        NodeDeletingWriter(long nodeToDelete, int propertyKeyId, Object valueToDelete, int label) {
            this.nodeToDelete = nodeToDelete;
            this.valueToDelete = Values.of((Object)valueToDelete);
            this.index = SchemaDescriptor.forLabel((int)label, (int[])new int[]{propertyKeyId});
        }

        void setJob(IndexPopulationJob job) {
            this.job = job;
        }

        public void add(Collection<? extends IndexEntryUpdate<?>> updates, PageCursorTracer cursorTracer) {
            for (IndexEntryUpdate<?> update : updates) {
                this.add(update);
            }
        }

        void add(IndexEntryUpdate<?> update) {
            if (update.getEntityId() == 2L) {
                this.job.update(IndexEntryUpdate.remove((long)this.nodeToDelete, (SchemaDescriptorSupplier)this.index, (Value[])new Value[]{this.valueToDelete}));
            }
            this.added.put(update.getEntityId(), update.values()[0].asObjectCopy());
        }

        public IndexUpdater newPopulatingUpdater(NodePropertyAccessor nodePropertyAccessor, PageCursorTracer cursorTracer) {
            return new IndexUpdater(){

                public void process(IndexEntryUpdate<?> update) {
                    switch (update.updateMode()) {
                        case ADDED: 
                        case CHANGED: {
                            added.put(update.getEntityId(), update.values()[0].asObjectCopy());
                            break;
                        }
                        case REMOVED: {
                            removed.put(update.getEntityId(), update.values()[0].asObjectCopy());
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException(update.updateMode().name());
                        }
                    }
                }

                public void close() {
                }
            };
        }
    }

    private static class NodeChangingWriter
    extends IndexPopulator.Adapter {
        private final Set<Pair<Long, Object>> added = new HashSet<Pair<Long, Object>>();
        private IndexPopulationJob job;
        private final long nodeToChange;
        private final Value newValue;
        private final Value previousValue;
        private final LabelSchemaDescriptor index;

        NodeChangingWriter(long nodeToChange, int propertyKeyId, Object previousValue, Object newValue, int label) {
            this.nodeToChange = nodeToChange;
            this.previousValue = Values.of((Object)previousValue);
            this.newValue = Values.of((Object)newValue);
            this.index = SchemaDescriptor.forLabel((int)label, (int[])new int[]{propertyKeyId});
        }

        public void add(Collection<? extends IndexEntryUpdate<?>> updates, PageCursorTracer cursorTracer) {
            for (IndexEntryUpdate<?> update : updates) {
                this.add(update);
            }
        }

        void add(IndexEntryUpdate<?> update) {
            if (update.getEntityId() == 2L) {
                this.job.update(IndexEntryUpdate.change((long)this.nodeToChange, (SchemaDescriptorSupplier)this.index, (Value)this.previousValue, (Value)this.newValue));
            }
            this.added.add((Pair<Long, Object>)Pair.of((Object)update.getEntityId(), (Object)update.values()[0].asObjectCopy()));
        }

        public IndexUpdater newPopulatingUpdater(NodePropertyAccessor nodePropertyAccessor, PageCursorTracer cursorTracer) {
            return new IndexUpdater(){

                public void process(IndexEntryUpdate<?> update) {
                    switch (update.updateMode()) {
                        case ADDED: 
                        case CHANGED: {
                            added.add((Pair<Long, Object>)Pair.of((Object)update.getEntityId(), (Object)update.values()[0].asObjectCopy()));
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException(update.updateMode().name());
                        }
                    }
                }

                public void close() {
                }
            };
        }

        void setJob(IndexPopulationJob job) {
            this.job = job;
        }
    }

    private static class ControlledStoreScan
    implements StoreScan<RuntimeException> {
        private final DoubleLatch latch = new DoubleLatch();

        private ControlledStoreScan() {
        }

        public void run() {
            this.latch.startAndWaitForAllToStartAndFinish();
        }

        public void stop() {
            this.latch.finish();
        }

        public void acceptUpdate(MultipleIndexPopulator.MultipleIndexUpdater updater, IndexEntryUpdate<?> update, long currentlyIndexedNodeId) {
        }

        public PopulationProgress getProgress() {
            return PopulationProgress.single((long)42L, (long)100L);
        }
    }
}

