/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.schema.UniquePropertyValueValidationException;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.values.storable.Values;

class UniquenessConstraintValidationIT
extends KernelIntegrationTest {
    UniquenessConstraintValidationIT() {
    }

    @Test
    void shouldEnforceOnSetProperty() throws Exception {
        this.constrainedNode("Label1", "key1", "value1");
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        long node = UniquenessConstraintValidationIT.createLabeledNode(transaction, "Label1");
        try {
            int propertyKeyId = transaction.tokenWrite().propertyKeyGetOrCreateForName("key1");
            transaction.dataWrite().nodeSetProperty(node, propertyKeyId, Values.of((Object)"value1"));
            org.junit.jupiter.api.Assertions.fail((String)"should have thrown exception");
        }
        catch (UniquePropertyValueValidationException e) {
            Assertions.assertThat((String)e.getUserMessage((TokenNameLookup)transaction.tokenRead())).contains(new CharSequence[]{"`key1` = 'value1'"});
        }
        this.commit();
    }

    @Test
    void roundingErrorsFromLongToDoubleShouldNotPreventTxFromCommitting() throws Exception {
        long propertyValue = 285414114323346805L;
        long firstNode = this.constrainedNode("label1", "key1", propertyValue);
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        long node = UniquenessConstraintValidationIT.createLabeledNode(transaction, "label1");
        org.junit.jupiter.api.Assertions.assertNotEquals((long)firstNode, (long)node);
        int propertyKeyId = transaction.tokenWrite().propertyKeyGetOrCreateForName("key1");
        transaction.dataWrite().nodeSetProperty(node, propertyKeyId, Values.of((Object)(++propertyValue)));
        this.commit();
    }

    @Test
    void shouldEnforceUniquenessConstraintOnAddLabelForNumberPropertyOnNodeNotFromTransaction() throws Exception {
        this.constrainedNode("Label1", "key1", 1);
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        long node = UniquenessConstraintValidationIT.createNode(transaction, "key1", 1);
        this.commit();
        transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        try {
            int label = transaction.tokenWrite().labelGetOrCreateForName("Label1");
            transaction.dataWrite().nodeAddLabel(node, label);
            org.junit.jupiter.api.Assertions.fail((String)"should have thrown exception");
        }
        catch (UniquePropertyValueValidationException e) {
            Assertions.assertThat((String)e.getUserMessage((TokenNameLookup)transaction.tokenRead())).contains(new CharSequence[]{"`key1` = 1"});
        }
        this.commit();
    }

    @Test
    void shouldEnforceUniquenessConstraintOnAddLabelForStringProperty() throws Exception {
        this.constrainedNode("Label1", "key1", "value1");
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        long node = UniquenessConstraintValidationIT.createNode(transaction, "key1", "value1");
        try {
            int label = transaction.tokenWrite().labelGetOrCreateForName("Label1");
            transaction.dataWrite().nodeAddLabel(node, label);
            org.junit.jupiter.api.Assertions.fail((String)"should have thrown exception");
        }
        catch (UniquePropertyValueValidationException e) {
            Assertions.assertThat((String)e.getUserMessage((TokenNameLookup)transaction.tokenRead())).contains(new CharSequence[]{"`key1` = 'value1'"});
        }
        this.commit();
    }

    @Test
    void shouldAllowRemoveAndAddConflictingDataInOneTransaction_DeleteNode() throws Exception {
        long node = this.constrainedNode("Label1", "key1", "value1");
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        transaction.dataWrite().nodeDelete(node);
        UniquenessConstraintValidationIT.createLabeledNode(transaction, "Label1", "key1", "value1");
        this.commit();
    }

    @Test
    void shouldAllowRemoveAndAddConflictingDataInOneTransaction_RemoveLabel() throws Exception {
        long node = this.constrainedNode("Label1", "key1", "value1");
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        int label = transaction.tokenWrite().labelGetOrCreateForName("Label1");
        transaction.dataWrite().nodeRemoveLabel(node, label);
        UniquenessConstraintValidationIT.createLabeledNode(transaction, "Label1", "key1", "value1");
        this.commit();
    }

    @Test
    void shouldAllowRemoveAndAddConflictingDataInOneTransaction_RemoveProperty() throws Exception {
        long node = this.constrainedNode("Label1", "key1", "value1");
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        int key = transaction.tokenRead().propertyKey("key1");
        transaction.dataWrite().nodeRemoveProperty(node, key);
        UniquenessConstraintValidationIT.createLabeledNode(transaction, "Label1", "key1", "value1");
        this.commit();
    }

    @Test
    void shouldAllowRemoveAndAddConflictingDataInOneTransaction_ChangeProperty() throws Exception {
        long node = this.constrainedNode("Label1", "key1", "value1");
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        int propertyKeyId = transaction.tokenWrite().propertyKeyGetOrCreateForName("key1");
        transaction.dataWrite().nodeSetProperty(node, propertyKeyId, Values.of((Object)"value2"));
        UniquenessConstraintValidationIT.createLabeledNode(transaction, "Label1", "key1", "value1");
        this.commit();
    }

    @Test
    void shouldPreventConflictingDataInSameTransaction() throws Exception {
        this.constrainedNode("Label1", "key1", "value1");
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        UniquenessConstraintValidationIT.createLabeledNode(transaction, "Label1", "key1", "value2");
        try {
            UniquenessConstraintValidationIT.createLabeledNode(transaction, "Label1", "key1", "value2");
            org.junit.jupiter.api.Assertions.fail((String)"expected exception");
        }
        catch (UniquePropertyValueValidationException e) {
            Assertions.assertThat((String)e.getUserMessage((TokenNameLookup)transaction.tokenRead())).contains(new CharSequence[]{"`key1` = 'value2'"});
        }
        this.commit();
    }

    @Test
    void shouldAllowNoopPropertyUpdate() throws KernelException {
        long node = this.constrainedNode("Label1", "key1", "value1");
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        int key = transaction.tokenWrite().propertyKeyGetOrCreateForName("key1");
        transaction.dataWrite().nodeSetProperty(node, key, Values.of((Object)"value1"));
        this.commit();
    }

    @Test
    void shouldAllowNoopLabelUpdate() throws KernelException {
        long node = this.constrainedNode("Label1", "key1", "value1");
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        int label = transaction.tokenWrite().labelGetOrCreateForName("Label1");
        transaction.dataWrite().nodeAddLabel(node, label);
        this.commit();
    }

    @Test
    void shouldAllowCreationOfNonConflictingData() throws Exception {
        this.constrainedNode("Label1", "key1", "value1");
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        UniquenessConstraintValidationIT.createNode(transaction, "key1", "value1");
        UniquenessConstraintValidationIT.createLabeledNode(transaction, "Label2", "key1", "value1");
        UniquenessConstraintValidationIT.createLabeledNode(transaction, "Label1", "key1", "value2");
        UniquenessConstraintValidationIT.createLabeledNode(transaction, "Label1", "key2", "value1");
        this.commit();
        transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)UniquenessConstraintValidationIT.countNodes(transaction), (String)"number of nodes");
        this.rollback();
    }

    @Test
    void unrelatedNodesWithSamePropertyShouldNotInterfereWithUniquenessCheck() throws Exception {
        ConstraintDescriptor constraint = this.createConstraint("Person", "id");
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        long ourNode = UniquenessConstraintValidationIT.createLabeledNode(transaction, "Person", "id", 1);
        UniquenessConstraintValidationIT.createLabeledNode(transaction, "Item", "id", 2);
        this.commit();
        transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        TokenRead tokenRead = transaction.tokenRead();
        int propId = tokenRead.propertyKey("id");
        IndexDescriptor idx = transaction.schemaRead().indexGetForName(constraint.getName());
        UniquenessConstraintValidationIT.createLabeledNode(transaction, "Item", "id", 2);
        try (NodeValueIndexCursor cursor = transaction.cursors().allocateNodeValueIndexCursor(transaction.pageCursorTracer());){
            Assertions.assertThat((long)transaction.dataRead().lockingNodeUniqueIndexSeek(idx, cursor, new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)propId, (Object)Values.of((Object)1))})).isEqualTo(ourNode);
        }
        this.commit();
    }

    @Test
    void addingUniqueNodeWithUnrelatedValueShouldNotAffectLookup() throws Exception {
        ConstraintDescriptor constraint = this.createConstraint("Person", "id");
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        long ourNode = UniquenessConstraintValidationIT.createLabeledNode(transaction, "Person", "id", 1);
        this.commit();
        transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        TokenRead tokenRead = transaction.tokenRead();
        int propId = tokenRead.propertyKey("id");
        IndexDescriptor idx = transaction.schemaRead().indexGetForName(constraint.getName());
        UniquenessConstraintValidationIT.createLabeledNode(transaction, "Person", "id", 2);
        try (NodeValueIndexCursor cursor = transaction.cursors().allocateNodeValueIndexCursor(transaction.pageCursorTracer());){
            Assertions.assertThat((long)transaction.dataRead().lockingNodeUniqueIndexSeek(idx, cursor, new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)propId, (Object)Values.of((Object)1))})).isEqualTo(ourNode);
        }
        this.commit();
    }

    private static long createLabeledNode(KernelTransaction transaction, String label) throws KernelException {
        long node = transaction.dataWrite().nodeCreate();
        int labelId = transaction.tokenWrite().labelGetOrCreateForName(label);
        transaction.dataWrite().nodeAddLabel(node, labelId);
        return node;
    }

    private static long createNode(KernelTransaction transaction, String key, Object value) throws KernelException {
        long node = transaction.dataWrite().nodeCreate();
        int propertyKeyId = transaction.tokenWrite().propertyKeyGetOrCreateForName(key);
        transaction.dataWrite().nodeSetProperty(node, propertyKeyId, Values.of((Object)value));
        return node;
    }

    private static long createLabeledNode(KernelTransaction transaction, String label, String key, Object value) throws KernelException {
        long node = UniquenessConstraintValidationIT.createLabeledNode(transaction, label);
        int propertyKeyId = transaction.tokenWrite().propertyKeyGetOrCreateForName(key);
        transaction.dataWrite().nodeSetProperty(node, propertyKeyId, Values.of((Object)value));
        return node;
    }

    private long constrainedNode(String labelName, String propertyKey, Object propertyValue) throws KernelException {
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        int label = transaction.tokenWrite().labelGetOrCreateForName(labelName);
        long node = transaction.dataWrite().nodeCreate();
        transaction.dataWrite().nodeAddLabel(node, label);
        int key = transaction.tokenWrite().propertyKeyGetOrCreateForName(propertyKey);
        transaction.dataWrite().nodeSetProperty(node, key, Values.of((Object)propertyValue));
        this.commit();
        this.createConstraint(labelName, propertyKey);
        return node;
    }

    private ConstraintDescriptor createConstraint(String label, String propertyKey) throws KernelException {
        TokenWrite tokenWrite = this.tokenWriteInNewTransaction();
        int labelId = tokenWrite.labelGetOrCreateForName(label);
        int propertyKeyId = tokenWrite.propertyKeyGetOrCreateForName(propertyKey);
        this.commit();
        SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
        ConstraintDescriptor constraint = schemaWrite.uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)labelId, (int[])new int[]{propertyKeyId})));
        this.commit();
        return constraint;
    }
}

