/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.junit.jupiter.api.Assertions;
import org.neo4j.internal.kernel.api.NodeIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipIndexCursor;

class IndexReadAsserts {
    IndexReadAsserts() {
    }

    static void assertNodes(NodeIndexCursor node, MutableLongSet uniqueIds, long ... expected) {
        uniqueIds.clear();
        for (long count : expected) {
            Assertions.assertTrue((boolean)node.next(), (String)("at least " + expected.length + " nodes"));
            Assertions.assertTrue((boolean)uniqueIds.add(node.nodeReference()));
        }
        Assertions.assertFalse((boolean)node.next(), (String)("no more than " + expected.length + " nodes"));
        Assertions.assertEquals((int)expected.length, (int)uniqueIds.size(), (String)"all nodes are unique");
        for (long expectedNode : expected) {
            Assertions.assertTrue((boolean)uniqueIds.contains(expectedNode), (String)("expected node " + expectedNode));
        }
    }

    static void assertNodeCount(NodeIndexCursor node, int expectedCount, MutableLongSet uniqueIds) {
        uniqueIds.clear();
        for (int i = 0; i < expectedCount; ++i) {
            Assertions.assertTrue((boolean)node.next(), (String)("at least " + expectedCount + " nodes"));
            Assertions.assertTrue((boolean)uniqueIds.add(node.nodeReference()));
        }
        Assertions.assertFalse((boolean)node.next(), (String)("no more than " + expectedCount + " nodes"));
    }

    static void assertRelationships(RelationshipIndexCursor edge, MutableLongSet uniqueIds, long ... expected) {
        uniqueIds.clear();
        for (long count : expected) {
            Assertions.assertTrue((boolean)edge.next(), (String)("at least " + expected.length + " relationships"));
            Assertions.assertTrue((boolean)uniqueIds.add(edge.relationshipReference()));
        }
        Assertions.assertFalse((boolean)edge.next(), (String)("no more than " + expected.length + " relationships"));
        Assertions.assertEquals((int)expected.length, (int)uniqueIds.size(), (String)"all relationships are unique");
        for (long expectedRelationship : expected) {
            Assertions.assertTrue((boolean)uniqueIds.contains(expectedRelationship), (String)("expected relationship " + expectedRelationship));
        }
    }

    static void assertRelationshipCount(RelationshipIndexCursor edge, int edges, MutableLongSet uniqueIds) {
        for (int i = 0; i < edges; ++i) {
            Assertions.assertTrue((boolean)edge.next(), (String)("at least " + edges + " relationships"));
            Assertions.assertTrue((boolean)uniqueIds.add(edge.relationshipReference()));
        }
        Assertions.assertFalse((boolean)edge.next(), (String)("no more than " + edges + " relationships"));
    }
}

