/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.common.EntityType;
import org.neo4j.exceptions.KernelException;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.schema.FulltextSchemaDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.index.schema.FulltextIndexProviderFactory;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestSupport;
import org.neo4j.kernel.impl.newapi.TestKernelReadTracer;
import org.neo4j.storageengine.api.RelationshipSelection;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

abstract class KernelReadTracerTxStateTestBase<G extends KernelAPIWriteTestSupport>
extends KernelAPIWriteTestBase<G> {
    KernelReadTracerTxStateTestBase() {
    }

    @Test
    void shouldTraceAllNodesScan() throws Exception {
        TestKernelReadTracer tracer = new TestKernelReadTracer();
        try (KernelTransaction tx = this.beginTransaction();
             NodeCursor cursor = tx.cursors().allocateNodeCursor(tx.pageCursorTracer());){
            tx.dataWrite().nodeCreate();
            tx.dataWrite().nodeCreate();
            cursor.setTracer((KernelReadTracer)tracer);
            tx.dataRead().allNodesScan(cursor);
            tracer.assertEvents(TestKernelReadTracer.ON_ALL_NODES_SCAN);
            Assertions.assertTrue((boolean)cursor.next());
            tracer.assertEvents(TestKernelReadTracer.OnNode(cursor.nodeReference()));
            Assertions.assertTrue((boolean)cursor.next());
            tracer.assertEvents(TestKernelReadTracer.OnNode(cursor.nodeReference()));
            Assertions.assertFalse((boolean)cursor.next());
            tracer.assertEvents(new TestKernelReadTracer.TraceEvent[0]);
        }
    }

    @Test
    void shouldTraceLabelScan() throws KernelException {
        TestKernelReadTracer tracer = new TestKernelReadTracer();
        try (KernelTransaction tx = this.beginTransaction();
             NodeLabelIndexCursor cursor = tx.cursors().allocateNodeLabelIndexCursor(PageCursorTracer.NULL);){
            int barId = tx.tokenWrite().labelGetOrCreateForName("Bar");
            long n = tx.dataWrite().nodeCreate();
            tx.dataWrite().nodeAddLabel(n, barId);
            cursor.setTracer((KernelReadTracer)tracer);
            tx.dataRead().nodeLabelScan(barId, cursor, IndexOrder.NONE);
            tracer.assertEvents(TestKernelReadTracer.OnLabelScan(barId));
            Assertions.assertTrue((boolean)cursor.next());
            tracer.assertEvents(TestKernelReadTracer.OnNode(cursor.nodeReference()));
            Assertions.assertFalse((boolean)cursor.next());
            tracer.assertEvents(new TestKernelReadTracer.TraceEvent[0]);
        }
    }

    @Test
    void shouldTraceIndexSeek() throws KernelException {
        TestKernelReadTracer tracer = new TestKernelReadTracer();
        String indexName = this.createIndex("User", "name");
        try (KernelTransaction tx = this.beginTransaction();
             NodeValueIndexCursor cursor = tx.cursors().allocateNodeValueIndexCursor(PageCursorTracer.NULL);){
            int name = tx.token().propertyKey("name");
            int user = tx.token().nodeLabel("User");
            long n = tx.dataWrite().nodeCreate();
            tx.dataWrite().nodeAddLabel(n, user);
            tx.dataWrite().nodeSetProperty(n, name, (Value)Values.stringValue((String)"Bosse"));
            IndexDescriptor index = tx.schemaRead().indexGetForName(indexName);
            IndexReadSession session = tx.dataRead().indexReadSession(index);
            this.assertIndexSeekTracing(tracer, tx, cursor, session, IndexOrder.NONE, false, user);
            this.assertIndexSeekTracing(tracer, tx, cursor, session, IndexOrder.NONE, true, user);
            this.assertIndexSeekTracing(tracer, tx, cursor, session, IndexOrder.ASCENDING, false, user);
            this.assertIndexSeekTracing(tracer, tx, cursor, session, IndexOrder.ASCENDING, true, user);
        }
    }

    private void assertIndexSeekTracing(TestKernelReadTracer tracer, KernelTransaction tx, NodeValueIndexCursor cursor, IndexReadSession session, IndexOrder order, boolean needsValues, int user) throws KernelException {
        cursor.setTracer((KernelReadTracer)tracer);
        tx.dataRead().nodeIndexSeek(session, cursor, IndexQueryConstraints.constrained((IndexOrder)order, (boolean)needsValues), new IndexQuery[]{IndexQuery.stringPrefix((int)user, (TextValue)Values.stringValue((String)"B"))});
        tracer.assertEvents(TestKernelReadTracer.OnIndexSeek());
        Assertions.assertTrue((boolean)cursor.next());
        tracer.assertEvents(TestKernelReadTracer.OnNode(cursor.nodeReference()));
        Assertions.assertFalse((boolean)cursor.next());
        tracer.assertEvents(new TestKernelReadTracer.TraceEvent[0]);
    }

    @Test
    void shouldTraceSingleRelationship() throws Exception {
        TestKernelReadTracer tracer = new TestKernelReadTracer();
        try (KernelTransaction tx = this.beginTransaction();
             RelationshipScanCursor cursor = tx.cursors().allocateRelationshipScanCursor(tx.pageCursorTracer());){
            long n1 = tx.dataWrite().nodeCreate();
            long n2 = tx.dataWrite().nodeCreate();
            long r = tx.dataWrite().relationshipCreate(n1, tx.token().relationshipTypeGetOrCreateForName("R"), n2);
            cursor.setTracer((KernelReadTracer)tracer);
            tx.dataRead().singleRelationship(r, cursor);
            Assertions.assertTrue((boolean)cursor.next());
            tracer.assertEvents(TestKernelReadTracer.OnRelationship(r));
            long deleted = tx.dataWrite().relationshipCreate(n1, tx.token().relationshipTypeGetOrCreateForName("R"), n2);
            tx.dataWrite().relationshipDelete(deleted);
            tx.dataRead().singleRelationship(deleted, cursor);
            Assertions.assertFalse((boolean)cursor.next());
            tracer.assertEvents(new TestKernelReadTracer.TraceEvent[0]);
        }
    }

    @Test
    void shouldTraceRelationshipTraversal() throws Exception {
        TestKernelReadTracer tracer = new TestKernelReadTracer();
        try (KernelTransaction tx = this.beginTransaction();
             NodeCursor nodeCursor = tx.cursors().allocateNodeCursor(tx.pageCursorTracer());
             RelationshipTraversalCursor cursor = tx.cursors().allocateRelationshipTraversalCursor(tx.pageCursorTracer());){
            long n1 = tx.dataWrite().nodeCreate();
            long n2 = tx.dataWrite().nodeCreate();
            long r = tx.dataWrite().relationshipCreate(n1, tx.token().relationshipTypeGetOrCreateForName("R"), n2);
            cursor.setTracer((KernelReadTracer)tracer);
            tx.dataRead().singleNode(n1, nodeCursor);
            Assertions.assertTrue((boolean)nodeCursor.next());
            nodeCursor.relationships(cursor, RelationshipSelection.ALL_RELATIONSHIPS);
            Assertions.assertTrue((boolean)cursor.next());
            tracer.assertEvents(TestKernelReadTracer.OnRelationship(r));
            Assertions.assertFalse((boolean)cursor.next());
            tracer.assertEvents(new TestKernelReadTracer.TraceEvent[0]);
        }
    }

    @Test
    void shouldTracePropertyAccess() throws Exception {
        TestKernelReadTracer tracer = new TestKernelReadTracer();
        try (KernelTransaction tx = this.beginTransaction();
             NodeCursor nodeCursor = tx.cursors().allocateNodeCursor(tx.pageCursorTracer());
             PropertyCursor propertyCursor = tx.cursors().allocatePropertyCursor(tx.pageCursorTracer(), tx.memoryTracker());){
            long n = tx.dataWrite().nodeCreate();
            int name = tx.token().propertyKey("name");
            tx.dataWrite().nodeSetProperty(n, name, (Value)Values.stringValue((String)"Bosse"));
            propertyCursor.setTracer((KernelReadTracer)tracer);
            tx.dataRead().singleNode(n, nodeCursor);
            Assertions.assertTrue((boolean)nodeCursor.next());
            nodeCursor.properties(propertyCursor);
            Assertions.assertTrue((boolean)propertyCursor.next());
            tracer.assertEvents(TestKernelReadTracer.OnProperty(name));
            Assertions.assertFalse((boolean)propertyCursor.next());
            tracer.assertEvents(new TestKernelReadTracer.TraceEvent[0]);
        }
    }

    @Test
    void shouldTraceRelationshipIndexCursor() throws KernelException, TimeoutException {
        IndexDescriptor index;
        int name;
        int connection;
        String indexName = "myIndex";
        try (KernelTransaction tx = this.beginTransaction();){
            connection = tx.tokenWrite().relationshipTypeGetOrCreateForName("Connection");
            name = tx.tokenWrite().propertyKeyGetOrCreateForName("name");
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            FulltextSchemaDescriptor schema = SchemaDescriptor.fulltext((EntityType)EntityType.RELATIONSHIP, (int[])this.array(connection), (int[])this.array(name));
            IndexPrototype prototype = IndexPrototype.forSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)FulltextIndexProviderFactory.DESCRIPTOR).withName(indexName).withIndexType(IndexType.FULLTEXT);
            index = tx.schemaWrite().indexCreate(prototype);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.beginTransaction();
        try {
            Predicates.awaitEx(() -> tx.schemaRead().indexGetState(index) == InternalIndexState.ONLINE, (long)1L, (TimeUnit)TimeUnit.MINUTES);
            long n1 = tx.dataWrite().nodeCreate();
            long n2 = tx.dataWrite().nodeCreate();
            long r = tx.dataWrite().relationshipCreate(n1, connection, n2);
            tx.dataWrite().relationshipSetProperty(r, name, (Value)Values.stringValue((String)"transformational"));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        TestKernelReadTracer tracer = new TestKernelReadTracer();
        try (KernelTransaction tx = this.beginTransaction();
             RelationshipIndexCursor cursor = tx.cursors().allocateRelationshipIndexCursor(PageCursorTracer.NULL);){
            cursor.setTracer((KernelReadTracer)tracer);
            tx.dataRead().relationshipIndexSeek(index, cursor, IndexQueryConstraints.unconstrained(), new IndexQuery[]{IndexQuery.fulltextSearch((String)"transformational")});
            Assertions.assertTrue((boolean)cursor.next());
            tracer.assertEvents(TestKernelReadTracer.OnRelationship(cursor.relationshipReference()));
            Assertions.assertFalse((boolean)cursor.next());
            tracer.assertEvents(new TestKernelReadTracer.TraceEvent[0]);
        }
    }

    private int[] array(int ... elements) {
        return elements;
    }

    private String createIndex(String label, String propertyKey) {
        String indexName;
        try (Transaction tx = graphDb.beginTx();){
            indexName = tx.schema().indexFor(Label.label((String)label)).on(propertyKey).create().getName();
            tx.commit();
        }
        tx = graphDb.beginTx();
        try {
            tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        return indexName;
    }
}

