/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension(configurationCallback="configure")
class RelationshipGroupStoreIT {
    private static final int RELATIONSHIP_COUNT = 20;
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    private RecordStorageEngine storageEngine;

    RelationshipGroupStoreIT() {
    }

    @ExtensionCallback
    static void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseSettings.dense_node_threshold, (Object)1);
    }

    @Test
    void shouldCreateAllTheseRelationshipTypes() {
        int i;
        Node node;
        this.shiftHighId();
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode();
            for (i = 0; i < 20; ++i) {
                node.createRelationshipTo(tx.createNode(), RelationshipGroupStoreIT.type(i));
            }
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            node = tx.getNodeById(node.getId());
            for (i = 0; i < 20; ++i) {
                Assertions.assertEquals((long)1L, (long)Iterables.count((Iterable)node.getRelationships(new RelationshipType[]{RelationshipGroupStoreIT.type(i)})), (String)"Should be possible to get relationships of type with id in unsigned short range.");
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private void shiftHighId() {
        NeoStores neoStores = this.storageEngine.testAccessNeoStores();
        neoStores.getRelationshipTypeTokenStore().setHighId(32757L);
    }

    private static RelationshipType type(int i) {
        return RelationshipType.withName((String)("TYPE_" + i));
    }
}

