/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.counts;

import java.io.File;
import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.common.ProgressReporter;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.api.DatabaseManagementServiceBuilder;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.batchimport.cache.NumberArrayFactories;
import org.neo4j.internal.counts.CountsBuilder;
import org.neo4j.internal.counts.GBPTreeCountsStore;
import org.neo4j.internal.id.DefaultIdGeneratorFactory;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.UncloseableDelegatingFileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.CountsComputer;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.extension.pagecache.PageCacheExtension;

@PageCacheExtension
@Neo4jLayoutExtension
class CountsComputerTest {
    private static final NullLogProvider LOG_PROVIDER = NullLogProvider.getInstance();
    private static final Config CONFIG = Config.defaults();
    @Inject
    private FileSystemAbstraction fileSystem;
    @Inject
    private PageCache pageCache;
    @Inject
    private DatabaseLayout databaseLayout;
    private DatabaseManagementServiceBuilder dbBuilder;

    CountsComputerTest() {
    }

    @BeforeEach
    void setup() {
        this.dbBuilder = new TestDatabaseManagementServiceBuilder(this.databaseLayout).setFileSystem((FileSystemAbstraction)new UncloseableDelegatingFileSystemAbstraction(this.fileSystem)).impermanent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void tracePageCacheAccessOnInitialization() throws IOException {
        DatabaseManagementService managementService = this.dbBuilder.build();
        try {
            GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
            GBPTreeCountsStore countsStore = (GBPTreeCountsStore)db.getDependencyResolver().resolveDependency(GBPTreeCountsStore.class);
            DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer();
            PageCursorTracer cursorTracer = pageCacheTracer.createPageCursorTracer("tracePageCacheAccessOnInitialization");
            countsStore.start(cursorTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            Assertions.assertThat((long)cursorTracer.pins()).isEqualTo(1L);
            Assertions.assertThat((long)cursorTracer.unpins()).isEqualTo(1L);
            Assertions.assertThat((long)cursorTracer.hits()).isEqualTo(1L);
        }
        finally {
            managementService.shutdown();
        }
    }

    @Test
    void skipPopulationWhenNodeAndRelationshipStoresAreEmpty() {
        DatabaseManagementService managementService = this.dbBuilder.build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
        long lastCommittedTransactionId = CountsComputerTest.getLastTxId(db);
        managementService.shutdown();
        InvocationTrackingProgressReporter progressReporter = new InvocationTrackingProgressReporter();
        this.rebuildCounts(lastCommittedTransactionId, progressReporter);
        this.checkEmptyCountStore();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)progressReporter.isCompleteInvoked());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)progressReporter.isStartInvoked());
    }

    @Test
    void shouldCreateAnEmptyCountsStoreFromAnEmptyDatabase() {
        DatabaseManagementService managementService = this.dbBuilder.build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
        long lastCommittedTransactionId = CountsComputerTest.getLastTxId(db);
        managementService.shutdown();
        this.rebuildCounts(lastCommittedTransactionId);
        this.checkEmptyCountStore();
    }

    @Test
    void shouldCreateACountsStoreWhenThereAreNodesInTheDB() throws IOException {
        DatabaseManagementService managementService = this.dbBuilder.build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
        try (Transaction tx = db.beginTx();){
            tx.createNode(new Label[]{Label.label((String)"A")});
            tx.createNode(new Label[]{Label.label((String)"C")});
            tx.createNode(new Label[]{Label.label((String)"D")});
            tx.createNode();
            tx.commit();
        }
        long lastCommittedTransactionId = CountsComputerTest.getLastTxId(db);
        managementService.shutdown();
        this.rebuildCounts(lastCommittedTransactionId);
        try (GBPTreeCountsStore store = this.createCountsStore();){
            org.junit.jupiter.api.Assertions.assertEquals((long)5L, (long)store.txId());
            org.junit.jupiter.api.Assertions.assertEquals((long)4L, (long)store.nodeCount(-1, PageCursorTracer.NULL));
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)store.nodeCount(0, PageCursorTracer.NULL));
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)store.nodeCount(1, PageCursorTracer.NULL));
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)store.nodeCount(2, PageCursorTracer.NULL));
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)store.nodeCount(3, PageCursorTracer.NULL));
        }
    }

    @Test
    void shouldCreateACountsStoreWhenThereAreUnusedNodeRecordsInTheDB() throws IOException {
        DatabaseManagementService managementService = this.dbBuilder.build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
        try (Transaction tx = db.beginTx();){
            tx.createNode(new Label[]{Label.label((String)"A")});
            tx.createNode(new Label[]{Label.label((String)"C")});
            Node node = tx.createNode(new Label[]{Label.label((String)"D")});
            tx.createNode();
            node.delete();
            tx.commit();
        }
        long lastCommittedTransactionId = CountsComputerTest.getLastTxId(db);
        managementService.shutdown();
        this.rebuildCounts(lastCommittedTransactionId);
        try (GBPTreeCountsStore store = this.createCountsStore();){
            org.junit.jupiter.api.Assertions.assertEquals((long)lastCommittedTransactionId, (long)store.txId());
            org.junit.jupiter.api.Assertions.assertEquals((long)3L, (long)store.nodeCount(-1, PageCursorTracer.NULL));
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)store.nodeCount(0, PageCursorTracer.NULL));
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)store.nodeCount(1, PageCursorTracer.NULL));
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)store.nodeCount(2, PageCursorTracer.NULL));
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)store.nodeCount(3, PageCursorTracer.NULL));
        }
    }

    @Test
    void shouldCreateACountsStoreWhenThereAreUnusedRelationshipRecordsInTheDB() throws IOException {
        DatabaseManagementService managementService = this.dbBuilder.build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
        try (Transaction tx = db.beginTx();){
            Node nodeA = tx.createNode(new Label[]{Label.label((String)"A")});
            Node nodeC = tx.createNode(new Label[]{Label.label((String)"C")});
            Relationship rel = nodeA.createRelationshipTo(nodeC, RelationshipType.withName((String)"TYPE1"));
            nodeC.createRelationshipTo(nodeA, RelationshipType.withName((String)"TYPE2"));
            rel.delete();
            tx.commit();
        }
        long lastCommittedTransactionId = CountsComputerTest.getLastTxId(db);
        managementService.shutdown();
        this.rebuildCounts(lastCommittedTransactionId);
        try (GBPTreeCountsStore store = this.createCountsStore();){
            org.junit.jupiter.api.Assertions.assertEquals((long)lastCommittedTransactionId, (long)store.txId());
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)store.nodeCount(-1, PageCursorTracer.NULL));
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)store.nodeCount(0, PageCursorTracer.NULL));
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)store.nodeCount(1, PageCursorTracer.NULL));
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)store.nodeCount(2, PageCursorTracer.NULL));
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)store.nodeCount(3, PageCursorTracer.NULL));
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)store.relationshipCount(-1, 0, -1, PageCursorTracer.NULL));
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)store.relationshipCount(-1, 1, -1, PageCursorTracer.NULL));
        }
    }

    @Test
    void shouldCreateACountsStoreWhenThereAreNodesAndRelationshipsInTheDB() throws IOException {
        DatabaseManagementService managementService = this.dbBuilder.build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
        try (Transaction tx = db.beginTx();){
            Node nodeA = tx.createNode(new Label[]{Label.label((String)"A")});
            Node nodeC = tx.createNode(new Label[]{Label.label((String)"C")});
            Node nodeD = tx.createNode(new Label[]{Label.label((String)"D")});
            Node node = tx.createNode();
            nodeA.createRelationshipTo(nodeD, RelationshipType.withName((String)"TYPE"));
            node.createRelationshipTo(nodeC, RelationshipType.withName((String)"TYPE2"));
            tx.commit();
        }
        long lastCommittedTransactionId = CountsComputerTest.getLastTxId(db);
        managementService.shutdown();
        this.rebuildCounts(lastCommittedTransactionId);
        try (GBPTreeCountsStore store = this.createCountsStore();){
            org.junit.jupiter.api.Assertions.assertEquals((long)lastCommittedTransactionId, (long)store.txId());
            org.junit.jupiter.api.Assertions.assertEquals((long)4L, (long)store.nodeCount(-1, PageCursorTracer.NULL));
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)store.nodeCount(0, PageCursorTracer.NULL));
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)store.nodeCount(1, PageCursorTracer.NULL));
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)store.nodeCount(2, PageCursorTracer.NULL));
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)store.nodeCount(3, PageCursorTracer.NULL));
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)store.relationshipCount(-1, -1, -1, PageCursorTracer.NULL));
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)store.relationshipCount(-1, 0, -1, PageCursorTracer.NULL));
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)store.relationshipCount(-1, 1, -1, PageCursorTracer.NULL));
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)store.relationshipCount(-1, 2, -1, PageCursorTracer.NULL));
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)store.relationshipCount(-1, 1, 1, PageCursorTracer.NULL));
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)store.relationshipCount(-1, 0, 1, PageCursorTracer.NULL));
        }
    }

    @Test
    void shouldCreateACountStoreWhenDBContainsDenseNodes() throws IOException {
        DatabaseManagementService managementService = this.dbBuilder.setConfig(GraphDatabaseSettings.dense_node_threshold, (Object)2).build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
        try (Transaction tx = db.beginTx();){
            Node nodeA = tx.createNode(new Label[]{Label.label((String)"A")});
            Node nodeC = tx.createNode(new Label[]{Label.label((String)"C")});
            Node nodeD = tx.createNode(new Label[]{Label.label((String)"D")});
            nodeA.createRelationshipTo(nodeA, RelationshipType.withName((String)"TYPE1"));
            nodeA.createRelationshipTo(nodeC, RelationshipType.withName((String)"TYPE2"));
            nodeA.createRelationshipTo(nodeD, RelationshipType.withName((String)"TYPE3"));
            nodeD.createRelationshipTo(nodeC, RelationshipType.withName((String)"TYPE4"));
            tx.commit();
        }
        long lastCommittedTransactionId = CountsComputerTest.getLastTxId(db);
        managementService.shutdown();
        this.rebuildCounts(lastCommittedTransactionId);
        try (GBPTreeCountsStore store = this.createCountsStore();){
            org.junit.jupiter.api.Assertions.assertEquals((long)lastCommittedTransactionId, (long)store.txId());
            org.junit.jupiter.api.Assertions.assertEquals((long)3L, (long)store.nodeCount(-1, PageCursorTracer.NULL));
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)store.nodeCount(0, PageCursorTracer.NULL));
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)store.nodeCount(1, PageCursorTracer.NULL));
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)store.nodeCount(2, PageCursorTracer.NULL));
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)store.nodeCount(3, PageCursorTracer.NULL));
            org.junit.jupiter.api.Assertions.assertEquals((long)4L, (long)store.relationshipCount(-1, -1, -1, PageCursorTracer.NULL));
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)store.relationshipCount(-1, 0, -1, PageCursorTracer.NULL));
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)store.relationshipCount(-1, 1, -1, PageCursorTracer.NULL));
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)store.relationshipCount(-1, 2, -1, PageCursorTracer.NULL));
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)store.relationshipCount(-1, 3, -1, PageCursorTracer.NULL));
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)store.relationshipCount(-1, 4, -1, PageCursorTracer.NULL));
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)store.relationshipCount(-1, 1, 1, PageCursorTracer.NULL));
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)store.relationshipCount(-1, -1, 1, PageCursorTracer.NULL));
            org.junit.jupiter.api.Assertions.assertEquals((long)3L, (long)store.relationshipCount(0, -1, -1, PageCursorTracer.NULL));
        }
    }

    private File countsStoreFile() {
        return this.databaseLayout.countStore();
    }

    private static long getLastTxId(GraphDatabaseAPI db) {
        return ((TransactionIdStore)db.getDependencyResolver().resolveDependency(TransactionIdStore.class)).getLastCommittedTransactionId();
    }

    private void checkEmptyCountStore() {
        try (GBPTreeCountsStore store = this.createCountsStore();){
            store.start(PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)store.txId());
            for (int s = 0; s < 10; ++s) {
                org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)store.nodeCount(s, PageCursorTracer.NULL));
                for (int e = 0; e < 10; ++e) {
                    for (int t = 0; t < 10; ++t) {
                        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)store.relationshipCount(s, t, e, PageCursorTracer.NULL));
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void cleanupCountsForRebuilding() {
        this.fileSystem.deleteFile(this.countsStoreFile());
    }

    private GBPTreeCountsStore createCountsStore() throws IOException {
        return this.createCountsStore(CountsBuilder.EMPTY);
    }

    private GBPTreeCountsStore createCountsStore(CountsBuilder builder) throws IOException {
        return new GBPTreeCountsStore(this.pageCache, this.databaseLayout.countStore(), this.fileSystem, RecoveryCleanupWorkCollector.immediate(), builder, false, PageCacheTracer.NULL, GBPTreeCountsStore.NO_MONITOR);
    }

    private void rebuildCounts(long lastCommittedTransactionId) {
        this.rebuildCounts(lastCommittedTransactionId, ProgressReporter.SILENT);
    }

    private void rebuildCounts(long lastCommittedTransactionId, ProgressReporter progressReporter) {
        this.cleanupCountsForRebuilding();
        DefaultIdGeneratorFactory idGenFactory = new DefaultIdGeneratorFactory(this.fileSystem, RecoveryCleanupWorkCollector.immediate());
        StoreFactory storeFactory = new StoreFactory(this.databaseLayout, CONFIG, (IdGeneratorFactory)idGenFactory, this.pageCache, this.fileSystem, (LogProvider)LOG_PROVIDER, PageCacheTracer.NULL);
        try (NeoStores neoStores = storeFactory.openAllNeoStores();){
            NodeStore nodeStore = neoStores.getNodeStore();
            RelationshipStore relationshipStore = neoStores.getRelationshipStore();
            int highLabelId = (int)neoStores.getLabelTokenStore().getHighId();
            int highRelationshipTypeId = (int)neoStores.getRelationshipTypeTokenStore().getHighId();
            CountsComputer countsComputer = new CountsComputer(lastCommittedTransactionId, nodeStore, relationshipStore, highLabelId, highRelationshipTypeId, NumberArrayFactories.AUTO_WITHOUT_PAGECACHE, this.databaseLayout, progressReporter, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            try (GBPTreeCountsStore countsStore = this.createCountsStore((CountsBuilder)countsComputer);){
                countsStore.start(PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
                countsStore.checkpoint(IOLimiter.UNLIMITED, PageCursorTracer.NULL);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class InvocationTrackingProgressReporter
    implements ProgressReporter {
        private boolean startInvoked;
        private boolean completeInvoked;

        private InvocationTrackingProgressReporter() {
        }

        public void start(long max) {
            this.startInvoked = true;
        }

        public void progress(long add) {
        }

        public void completed() {
            this.completeInvoked = true;
        }

        boolean isStartInvoked() {
            return this.startInvoked;
        }

        boolean isCompleteInvoked() {
            return this.completeInvoked;
        }
    }
}

