/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.neo4j.internal.nativeimpl.NativeAccessProvider;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.impl.api.TestCommandReaderFactory;
import org.neo4j.kernel.impl.transaction.SimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.LogHeaderCache;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFileChannelNativeAccessor;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogChannelAllocator;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesContext;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesHelper;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
class TransactionLogChannelAllocatorIT {
    private static final long ROTATION_THRESHOLD = ByteUnit.mebiBytes((long)25L);
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private FileSystemAbstraction fileSystem;
    private TransactionLogFilesHelper fileHelper;
    private TransactionLogChannelAllocator fileAllocator;

    TransactionLogChannelAllocatorIT() {
    }

    @BeforeEach
    void setUp() {
        this.fileHelper = new TransactionLogFilesHelper(this.fileSystem, this.testDirectory.homeDir());
        this.fileAllocator = this.createLogFileAllocator();
    }

    @Test
    @EnabledOnOs(value={OS.LINUX})
    void allocateNewTransactionLogFile() throws IOException {
        PhysicalLogVersionedStoreChannel logChannel = this.fileAllocator.createLogChannel(10L, () -> 1L);
        Assertions.assertEquals((long)ROTATION_THRESHOLD, (long)logChannel.size());
    }

    @Test
    @DisabledOnOs(value={OS.LINUX})
    void allocateNewTransactionLogFileOnSystemThatDoesNotSupportPreallocations() throws IOException {
        try (PhysicalLogVersionedStoreChannel logChannel = this.fileAllocator.createLogChannel(10L, () -> 1L);){
            Assertions.assertEquals((long)64L, (long)logChannel.size());
        }
    }

    @Test
    void openExistingFileDoesNotPerformAnyAllocations() throws IOException {
        File file = this.fileHelper.getLogFileForVersion(11L);
        this.fileSystem.write(file).close();
        TransactionLogChannelAllocator fileAllocator = this.createLogFileAllocator();
        try (PhysicalLogVersionedStoreChannel channel = fileAllocator.createLogChannel(11L, () -> 1L);){
            Assertions.assertEquals((long)64L, (long)channel.size());
        }
    }

    private TransactionLogChannelAllocator createLogFileAllocator() {
        LogHeaderCache logHeaderCache = new LogHeaderCache(10);
        TransactionLogFilesContext logFileContext = this.createLogFileContext();
        LogFileChannelNativeAccessor nativeChannelAccessor = new LogFileChannelNativeAccessor(this.fileSystem, logFileContext);
        return new TransactionLogChannelAllocator(logFileContext, this.fileHelper, logHeaderCache, nativeChannelAccessor);
    }

    private TransactionLogFilesContext createLogFileContext() {
        return new TransactionLogFilesContext(new AtomicLong(ROTATION_THRESHOLD), new AtomicBoolean(true), (LogEntryReader)new VersionAwareLogEntryReader((CommandReaderFactory)new TestCommandReaderFactory()), () -> 1L, () -> 1L, () -> new LogPosition(0L, 1L), SimpleLogVersionRepository::new, this.fileSystem, (LogProvider)NullLogProvider.getInstance(), DatabaseTracers.EMPTY, () -> StoreId.UNKNOWN, NativeAccessProvider.getNativeAccess(), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }
}

