/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.ArrayUtils;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.neo4j.exceptions.KernelException;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.internal.recordstorage.RecordStorageReader;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.state.storeview.NeoStoreIndexStoreView;
import org.neo4j.kernel.impl.transaction.state.storeview.NodeStoreScan;
import org.neo4j.kernel.impl.transaction.state.storeview.RelationshipStoreScan;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.lock.Lock;
import org.neo4j.lock.LockService;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.EntityTokenUpdate;
import org.neo4j.storageengine.api.EntityUpdates;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StorageRelationshipScanCursor;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@DbmsExtension
class NeoStoreIndexStoreViewTest {
    @Inject
    private GraphDatabaseAPI graphDb;
    @Inject
    private RecordStorageEngine storageEngine;
    @Inject
    private CheckPointer checkPointer;
    private final Map<Long, Lock> lockMocks = new HashMap<Long, Lock>();
    private final Label label = Label.label((String)"Person");
    private final RelationshipType relationshipType = RelationshipType.withName((String)"Knows");
    private NeoStoreIndexStoreView storeView;
    private int labelId;
    private int relTypeId;
    private int propertyKeyId;
    private int relPropertyKeyId;
    private Node alistair;
    private Node stefan;
    private LockService locks;
    private NeoStores neoStores;
    private Relationship aKnowsS;
    private Relationship sKnowsA;
    private StorageReader reader;
    private NodePropertyAccessor propertyAccessor;

    NeoStoreIndexStoreViewTest() {
    }

    @BeforeEach
    void before() throws KernelException {
        this.createAlistairAndStefanNodes();
        this.getOrCreateIds();
        this.neoStores = this.storageEngine.testAccessNeoStores();
        this.locks = (LockService)Mockito.mock(LockService.class);
        Mockito.when((Object)this.locks.acquireNodeLock(ArgumentMatchers.anyLong(), (LockService.LockType)ArgumentMatchers.any())).thenAnswer(invocation -> {
            Long nodeId = (Long)invocation.getArgument(0);
            return this.lockMocks.computeIfAbsent(nodeId, k -> (Lock)Mockito.mock(Lock.class));
        });
        Mockito.when((Object)this.locks.acquireRelationshipLock(ArgumentMatchers.anyLong(), (LockService.LockType)ArgumentMatchers.any())).thenAnswer(invocation -> {
            Long nodeId = (Long)invocation.getArgument(0);
            return this.lockMocks.computeIfAbsent(nodeId, k -> (Lock)Mockito.mock(Lock.class));
        });
        this.storeView = new NeoStoreIndexStoreView(this.locks, () -> ((RecordStorageEngine)this.storageEngine).newReader());
        this.propertyAccessor = this.storeView.newPropertyAccessor(PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        this.reader = this.storageEngine.newReader();
    }

    @AfterEach
    void after() {
        this.propertyAccessor.close();
        this.reader.close();
    }

    @Test
    void shouldScanExistingNodesForALabel() throws Exception {
        EntityUpdateCollectingVisitor visitor = new EntityUpdateCollectingVisitor();
        Visitor labelVisitor = (Visitor)Mockito.mock(Visitor.class);
        StoreScan storeScan = this.storeView.visitNodes(new int[]{this.labelId}, id -> id == this.propertyKeyId, (Visitor)visitor, labelVisitor, false, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        storeScan.run();
        org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new EntityUpdates[]{this.add(this.alistair.getId(), this.propertyKeyId, "Alistair", new long[]{this.labelId}), this.add(this.stefan.getId(), this.propertyKeyId, "Stefan", new long[]{this.labelId})}), visitor.getUpdates());
    }

    @Test
    void shouldScanExistingRelationshipsForARelationshipType() throws Exception {
        EntityUpdateCollectingVisitor visitor = new EntityUpdateCollectingVisitor();
        StoreScan storeScan = this.storeView.visitRelationships(new int[]{this.relTypeId}, id -> id == this.relPropertyKeyId, (Visitor)visitor, null, true, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        storeScan.run();
        org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new EntityUpdates[]{this.add(this.aKnowsS.getId(), this.relPropertyKeyId, "long", new long[]{this.relTypeId}), this.add(this.sKnowsA.getId(), this.relPropertyKeyId, "lengthy", new long[]{this.relTypeId})}), visitor.getUpdates());
    }

    @Test
    void shouldIgnoreDeletedNodesDuringScan() throws Exception {
        this.deleteAlistairAndStefanNodes();
        EntityUpdateCollectingVisitor visitor = new EntityUpdateCollectingVisitor();
        Visitor labelVisitor = (Visitor)Mockito.mock(Visitor.class);
        StoreScan storeScan = this.storeView.visitNodes(new int[]{this.labelId}, id -> id == this.propertyKeyId, (Visitor)visitor, labelVisitor, false, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        storeScan.run();
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptySet(), visitor.getUpdates());
    }

    @Test
    void shouldIgnoreDeletedRelationshipsDuringScan() throws Exception {
        this.deleteAlistairAndStefanNodes();
        EntityUpdateCollectingVisitor visitor = new EntityUpdateCollectingVisitor();
        StoreScan storeScan = this.storeView.visitRelationships(new int[]{this.relTypeId}, id -> id == this.relPropertyKeyId, (Visitor)visitor, null, true, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        storeScan.run();
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptySet(), visitor.getUpdates());
    }

    @Test
    void shouldLockNodesWhileReadingThem() throws Exception {
        Visitor visitor = (Visitor)Mockito.mock(Visitor.class);
        StoreScan storeScan = this.storeView.visitNodes(new int[]{this.labelId}, id -> id == this.propertyKeyId, visitor, null, false, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        storeScan.run();
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.lockMocks.size()).as("allocated locks: " + this.lockMocks.keySet(), new Object[0])).isGreaterThanOrEqualTo(2);
        Lock lock0 = this.lockMocks.get(0L);
        Lock lock1 = this.lockMocks.get(1L);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)lock0, (String)"Lock[node=0] never acquired");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)lock1, (String)"Lock[node=1] never acquired");
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.locks, lock0, lock1});
        ((LockService)order.verify((Object)this.locks)).acquireNodeLock(0L, LockService.LockType.READ_LOCK);
        ((Lock)order.verify((Object)lock0)).release();
        ((LockService)order.verify((Object)this.locks)).acquireNodeLock(1L, LockService.LockType.READ_LOCK);
        ((Lock)order.verify((Object)lock1)).release();
    }

    @Test
    void shouldLockRelationshipsWhileReadingThem() throws Exception {
        Visitor visitor = (Visitor)Mockito.mock(Visitor.class);
        StoreScan storeScan = this.storeView.visitRelationships(new int[]{this.relTypeId}, id -> id == this.relPropertyKeyId, visitor, null, true, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        storeScan.run();
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.lockMocks.size()).as("allocated locks: " + this.lockMocks.keySet(), new Object[0])).isGreaterThanOrEqualTo(2);
        Lock lock0 = this.lockMocks.get(0L);
        Lock lock1 = this.lockMocks.get(1L);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)lock0, (String)"Lock[relationship=0] never acquired");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)lock1, (String)"Lock[relationship=1] never acquired");
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.locks, lock0, lock1});
        ((LockService)order.verify((Object)this.locks)).acquireRelationshipLock(0L, LockService.LockType.READ_LOCK);
        ((Lock)order.verify((Object)lock0)).release();
        ((LockService)order.verify((Object)this.locks)).acquireRelationshipLock(1L, LockService.LockType.READ_LOCK);
        ((Lock)order.verify((Object)lock1)).release();
    }

    @Test
    void shouldReadProperties() throws EntityNotFoundException {
        Value value = this.propertyAccessor.getNodePropertyValue(this.alistair.getId(), this.propertyKeyId, PageCursorTracer.NULL);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)value.equals(Values.of((Object)"Alistair")));
    }

    @Test
    void processAllNodeProperties() {
        CopyUpdateVisitor propertyUpdateVisitor = new CopyUpdateVisitor();
        NodeStoreScan nodeStoreScan = new NodeStoreScan((StorageReader)new RecordStorageReader(this.neoStores), this.locks, null, (Visitor)propertyUpdateVisitor, new int[]{this.labelId}, id -> true, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (StorageNodeCursor nodeCursor = this.reader.allocateNodeCursor(PageCursorTracer.NULL);){
            nodeCursor.single(1L);
            nodeCursor.next();
            nodeStoreScan.process(nodeCursor);
        }
        EntityUpdates propertyUpdates = propertyUpdateVisitor.getPropertyUpdates();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)propertyUpdates, (String)"Visitor should contain container with updates.");
        LabelSchemaDescriptor index1 = SchemaDescriptor.forLabel((int)0, (int[])new int[]{0});
        LabelSchemaDescriptor index2 = SchemaDescriptor.forLabel((int)0, (int[])new int[]{1});
        LabelSchemaDescriptor index3 = SchemaDescriptor.forLabel((int)0, (int[])new int[]{0, 1});
        LabelSchemaDescriptor index4 = SchemaDescriptor.forLabel((int)1, (int[])new int[]{1});
        List<LabelSchemaDescriptor> indexes = Arrays.asList(index1, index2, index3, index4);
        Assertions.assertThat((Iterable)Iterables.map(IndexEntryUpdate::indexKey, (Iterable)propertyUpdates.forIndexKeys(indexes))).contains((Object[])new LabelSchemaDescriptor[]{index1, index2, index3});
    }

    @Test
    void tracePageCacheAccessOnStoreViewNodeScan() throws IOException {
        this.checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("forcedCheckpoint"));
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer();
        CountingVisitor countingVisitor = new CountingVisitor();
        try (PageCursorTracer cursorTracer = pageCacheTracer.createPageCursorTracer("tracePageCacheAccessOnStoreViewNodeScan");){
            NodeStoreScan scan = new NodeStoreScan((StorageReader)this.storageEngine.newReader(), this.locks, null, (Visitor)countingVisitor, new int[]{this.labelId}, id -> true, cursorTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            scan.run();
        }
        Assertions.assertThat((int)countingVisitor.countedUpdates()).isEqualTo(2);
        Assertions.assertThat((long)pageCacheTracer.pins()).isEqualTo(3L);
        Assertions.assertThat((long)pageCacheTracer.unpins()).isEqualTo(3L);
        Assertions.assertThat((long)pageCacheTracer.hits()).isEqualTo(3L);
    }

    @Test
    void processAllRelationshipProperties() {
        this.createAlistairAndStefanNodes();
        CopyUpdateVisitor propertyUpdateVisitor = new CopyUpdateVisitor();
        RelationshipStoreScan relationshipStoreScan = new RelationshipStoreScan((StorageReader)new RecordStorageReader(this.neoStores), this.locks, null, (Visitor)propertyUpdateVisitor, new int[]{this.relTypeId}, id -> true, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (StorageRelationshipScanCursor relationshipScanCursor = this.reader.allocateRelationshipScanCursor(PageCursorTracer.NULL);){
            relationshipScanCursor.single(1L);
            relationshipScanCursor.next();
            relationshipStoreScan.process(relationshipScanCursor);
        }
        EntityUpdates propertyUpdates = propertyUpdateVisitor.getPropertyUpdates();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)propertyUpdates, (String)"Visitor should contain container with updates.");
        RelationTypeSchemaDescriptor index1 = SchemaDescriptor.forRelType((int)0, (int[])new int[]{2});
        RelationTypeSchemaDescriptor index2 = SchemaDescriptor.forRelType((int)0, (int[])new int[]{3});
        RelationTypeSchemaDescriptor index3 = SchemaDescriptor.forRelType((int)0, (int[])new int[]{2, 3});
        RelationTypeSchemaDescriptor index4 = SchemaDescriptor.forRelType((int)1, (int[])new int[]{3});
        List<RelationTypeSchemaDescriptor> indexes = Arrays.asList(index1, index2, index3, index4);
        Assertions.assertThat((Iterable)Iterables.map(IndexEntryUpdate::indexKey, (Iterable)propertyUpdates.forIndexKeys(indexes))).contains((Object[])new RelationTypeSchemaDescriptor[]{index1, index2, index3});
    }

    @Test
    void tracePageCacheAccessOnRelationshipStoreScan() throws Exception {
        this.checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("forcedCheckpoint"));
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer();
        CountingVisitor countingVisitor = new CountingVisitor();
        try (PageCursorTracer cursorTracer = pageCacheTracer.createPageCursorTracer("tracePageCacheAccessOnRelationshipStoreScan");){
            RelationshipStoreScan scan = new RelationshipStoreScan((StorageReader)this.storageEngine.newReader(), this.locks, null, (Visitor)countingVisitor, new int[]{this.relTypeId}, id -> true, cursorTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            scan.run();
        }
        Assertions.assertThat((int)countingVisitor.countedUpdates()).isEqualTo(2);
        Assertions.assertThat((long)pageCacheTracer.pins()).isEqualTo(2L);
        Assertions.assertThat((long)pageCacheTracer.unpins()).isEqualTo(2L);
        Assertions.assertThat((long)pageCacheTracer.hits()).isEqualTo(2L);
    }

    @Test
    void processAllRelationshipTypes() throws Exception {
        CopyTokenUpdateVisitor relationshipTypeUpdateVisitor = new CopyTokenUpdateVisitor();
        StoreScan storeViewRelationshipStoreScan = this.storeView.visitRelationships(ArrayUtils.EMPTY_INT_ARRAY, Predicates.ALWAYS_TRUE_INT, null, relationshipTypeUpdateVisitor, true, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        storeViewRelationshipStoreScan.run();
        Set<EntityTokenUpdate> updates = relationshipTypeUpdateVisitor.getUpdates();
        Assertions.assertThat((int)updates.size()).isEqualTo(2);
        for (EntityTokenUpdate update : updates) {
            long[] tokensAfter = update.getTokensAfter();
            Assertions.assertThat((int)tokensAfter.length).isEqualTo(1);
            Assertions.assertThat((long)tokensAfter[0]).isEqualTo(0L);
            Assertions.assertThat((long)update.getEntityId()).satisfiesAnyOf(id -> Assertions.assertThat((Long)id).isEqualTo(0L), id -> Assertions.assertThat((Long)id).isEqualTo(1L));
        }
    }

    private EntityUpdates add(long nodeId, int propertyKeyId, Object value, long[] labels) {
        return EntityUpdates.forEntity((long)nodeId, (boolean)true).withTokens(labels).added(propertyKeyId, Values.of((Object)value)).build();
    }

    private void createAlistairAndStefanNodes() {
        try (Transaction tx = this.graphDb.beginTx();){
            this.alistair = tx.createNode(new Label[]{this.label});
            this.alistair.setProperty("name", (Object)"Alistair");
            this.alistair.setProperty("country", (Object)"UK");
            this.stefan = tx.createNode(new Label[]{this.label});
            this.stefan.setProperty("name", (Object)"Stefan");
            this.stefan.setProperty("country", (Object)"Deutschland");
            this.aKnowsS = this.alistair.createRelationshipTo(this.stefan, this.relationshipType);
            this.aKnowsS.setProperty("duration", (Object)"long");
            this.aKnowsS.setProperty("irrelevant", (Object)"prop");
            this.sKnowsA = this.stefan.createRelationshipTo(this.alistair, this.relationshipType);
            this.sKnowsA.setProperty("duration", (Object)"lengthy");
            this.sKnowsA.setProperty("irrelevant", (Object)"prop");
            tx.commit();
        }
    }

    private void deleteAlistairAndStefanNodes() {
        try (Transaction tx = this.graphDb.beginTx();){
            tx.getRelationshipById(this.aKnowsS.getId()).delete();
            tx.getRelationshipById(this.sKnowsA.getId()).delete();
            tx.getNodeById(this.alistair.getId()).delete();
            tx.getNodeById(this.stefan.getId()).delete();
            tx.commit();
        }
    }

    private void getOrCreateIds() throws KernelException {
        try (Transaction tx = this.graphDb.beginTx();){
            TokenWrite tokenWrite = ((InternalTransaction)tx).kernelTransaction().tokenWrite();
            this.labelId = tokenWrite.labelGetOrCreateForName("Person");
            this.relTypeId = tokenWrite.relationshipTypeGetOrCreateForName("Knows");
            this.propertyKeyId = tokenWrite.propertyKeyGetOrCreateForName("name");
            this.relPropertyKeyId = tokenWrite.propertyKeyGetOrCreateForName("duration");
            tx.commit();
        }
    }

    private static class CopyTokenUpdateVisitor<EXCEPTION extends Exception>
    implements Visitor<EntityTokenUpdate, EXCEPTION> {
        private final Set<EntityTokenUpdate> updates = new HashSet<EntityTokenUpdate>();

        private CopyTokenUpdateVisitor() {
        }

        public boolean visit(EntityTokenUpdate element) {
            this.updates.add(element);
            return false;
        }

        Set<EntityTokenUpdate> getUpdates() {
            return this.updates;
        }
    }

    static class EntityUpdateCollectingVisitor
    implements Visitor<EntityUpdates, Exception> {
        private final Set<EntityUpdates> updates = new HashSet<EntityUpdates>();

        EntityUpdateCollectingVisitor() {
        }

        public boolean visit(EntityUpdates propertyUpdates) {
            this.updates.add(propertyUpdates);
            return false;
        }

        Set<EntityUpdates> getUpdates() {
            return this.updates;
        }
    }

    private static class CopyUpdateVisitor
    implements Visitor<EntityUpdates, RuntimeException> {
        private EntityUpdates propertyUpdates;

        private CopyUpdateVisitor() {
        }

        public boolean visit(EntityUpdates element) throws RuntimeException {
            this.propertyUpdates = element;
            return true;
        }

        EntityUpdates getPropertyUpdates() {
            return this.propertyUpdates;
        }
    }

    private static class CountingVisitor
    implements Visitor<EntityUpdates, RuntimeException> {
        private final AtomicInteger counter = new AtomicInteger();

        private CountingVisitor() {
        }

        public boolean visit(EntityUpdates element) throws RuntimeException {
            this.counter.incrementAndGet();
            return true;
        }

        int countedUpdates() {
            return this.counter.get();
        }
    }
}

