/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.transaction.state.storeview.NeoStoreIndexStoreView;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.lock.LockService;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class NeoStoreIndexStoreViewTracingIT {
    @Inject
    private GraphDatabaseAPI database;
    @Inject
    private LockService lockService;
    @Inject
    private RecordStorageEngine storageEngine;

    NeoStoreIndexStoreViewTracingIT() {
    }

    @Test
    void tracePageCacheAccess() throws Exception {
        int nodeCount = 1000;
        Label label = Label.label((String)"marker");
        try (Transaction tx = this.database.beginTx();){
            for (int i = 0; i < nodeCount; ++i) {
                Node node = tx.createNode(new Label[]{label});
                node.setProperty("a", (Object)RandomStringUtils.randomAscii((int)10));
            }
            tx.commit();
        }
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer();
        try (PageCursorTracer cursorTracer = pageCacheTracer.createPageCursorTracer("tracePageCacheAccess");){
            NeoStoreIndexStoreView indexStoreView = new NeoStoreIndexStoreView(this.lockService, () -> ((RecordStorageEngine)this.storageEngine).newReader());
            StoreScan storeScan = indexStoreView.visitNodes(ArrayUtils.EMPTY_INT_ARRAY, Predicates.ALWAYS_TRUE_INT, null, element -> false, true, cursorTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            storeScan.run();
        }
        Assertions.assertThat((long)pageCacheTracer.pins()).isEqualTo(2L);
        Assertions.assertThat((long)pageCacheTracer.unpins()).isEqualTo(2L);
        Assertions.assertThat((long)pageCacheTracer.hits()).isEqualTo(2L);
    }
}

