/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.UncloseableDelegatingFileSystemAbstraction;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@EphemeralTestDirectoryExtension
class KernelRecoveryTest {
    @Inject
    private EphemeralFileSystemAbstraction fileSystem;
    @Inject
    private TestDirectory testDirectory;
    private DatabaseManagementService managementService;

    KernelRecoveryTest() {
    }

    @AfterEach
    void cleanUp() {
        if (this.managementService != null) {
            this.managementService.shutdown();
        }
    }

    @Test
    void shouldHandleWritesProperlyAfterRecovery() throws Exception {
        long node2;
        GraphDatabaseService db = this.newDB((FileSystemAbstraction)this.fileSystem, "main");
        long node1 = KernelRecoveryTest.createNode(db, "k", "v1");
        ArrayList<TransactionRepresentation> transactions = new ArrayList<TransactionRepresentation>();
        try (EphemeralFileSystemAbstraction crashedFs = this.fileSystem.snapshot();){
            this.managementService.shutdown();
            db = this.newDB((FileSystemAbstraction)crashedFs, "main");
            node2 = KernelRecoveryTest.createNode(db, "k", "v2");
            KernelRecoveryTest.extractTransactions((GraphDatabaseAPI)db, transactions);
            this.managementService.shutdown();
        }
        GraphDatabaseService rebuilt = this.newDB((FileSystemAbstraction)this.fileSystem, "rebuilt");
        KernelRecoveryTest.applyTransactions(transactions, (GraphDatabaseAPI)rebuilt);
        try (Transaction tx = rebuilt.beginTx();){
            Assertions.assertEquals((Object)"v1", (Object)tx.getNodeById(node1).getProperty("k"));
            Assertions.assertEquals((Object)"v2", (Object)tx.getNodeById(node2).getProperty("k"));
            tx.commit();
        }
    }

    private static void applyTransactions(List<TransactionRepresentation> transactions, GraphDatabaseAPI rebuilt) throws TransactionFailureException {
        TransactionCommitProcess commitProcess = (TransactionCommitProcess)rebuilt.getDependencyResolver().resolveDependency(TransactionCommitProcess.class);
        for (TransactionRepresentation transaction : transactions) {
            commitProcess.commit(new TransactionToApply(transaction, PageCursorTracer.NULL), CommitEvent.NULL, TransactionApplicationMode.EXTERNAL);
        }
    }

    private static void extractTransactions(GraphDatabaseAPI db, List<TransactionRepresentation> transactions) throws IOException {
        LogicalTransactionStore txStore = (LogicalTransactionStore)db.getDependencyResolver().resolveDependency(LogicalTransactionStore.class);
        try (TransactionCursor cursor = txStore.getTransactions(2L);){
            cursor.forAll(tx -> transactions.add(tx.getTransactionRepresentation()));
        }
    }

    private GraphDatabaseService newDB(FileSystemAbstraction fs, String name) {
        this.managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.directory(name, new String[0])).setFileSystem((FileSystemAbstraction)new UncloseableDelegatingFileSystemAbstraction(fs)).impermanent().build();
        return this.managementService.database("neo4j");
    }

    private static long createNode(GraphDatabaseService db, String key, Object value) {
        long nodeId;
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode();
            node.setProperty(key, value);
            nodeId = node.getId();
            tx.commit();
        }
        return nodeId;
    }
}

