/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.security;

import java.util.function.IntSupplier;
import java.util.function.Supplier;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.PrivilegeAction;

public class TestAccessMode
implements AccessMode {
    private final boolean allowRead;
    private final boolean allowReadAll;
    private final boolean allowWrite;
    private final boolean allowSchema;

    public TestAccessMode(boolean allowRead, boolean allowReadAll, boolean allowWrite, boolean allowSchema) {
        this.allowRead = allowRead;
        this.allowReadAll = allowReadAll;
        this.allowWrite = allowWrite;
        this.allowSchema = allowSchema;
    }

    public boolean allowsWrites() {
        return this.allowWrite;
    }

    public boolean allowsTokenCreates(PrivilegeAction action) {
        return this.allowWrite;
    }

    public boolean allowsSchemaWrites() {
        return this.allowSchema;
    }

    public boolean allowsSchemaWrites(PrivilegeAction action) {
        return this.allowSchema;
    }

    public boolean allowsTraverseAllLabels() {
        return this.allowReadAll;
    }

    public boolean allowsTraverseAllNodesWithLabel(long label) {
        return this.allowReadAll;
    }

    public boolean disallowsTraverseLabel(long label) {
        return !this.allowRead;
    }

    public boolean allowsTraverseNode(long ... labels) {
        return this.allowRead;
    }

    public boolean allowsTraverseAllRelTypes() {
        return this.allowReadAll;
    }

    public boolean allowsTraverseRelType(int relType) {
        return this.allowRead;
    }

    public boolean allowsReadPropertyAllLabels(int propertyKey) {
        return this.allowReadAll;
    }

    public boolean disallowsReadPropertyForSomeLabel(int propertyKey) {
        return !this.allowReadAll;
    }

    public boolean allowsReadNodeProperty(Supplier<TokenSet> labels, int propertyKey) {
        return this.allowRead;
    }

    public boolean allowsReadPropertyAllRelTypes(int propertyKey) {
        return this.allowReadAll;
    }

    public boolean allowsReadRelationshipProperty(IntSupplier relType, int propertyKey) {
        return this.allowRead;
    }

    public boolean allowsSeePropertyKeyToken(int propertyKey) {
        return this.allowRead;
    }

    public boolean allowsProcedureWith(String[] allowed) {
        return false;
    }

    public boolean allowsSetLabel(long labelId) {
        return this.allowWrite;
    }

    public boolean allowsRemoveLabel(long labelId) {
        return this.allowWrite;
    }

    public boolean allowsCreateNode(int[] labelIds) {
        return this.allowWrite;
    }

    public boolean allowsDeleteNode(Supplier<TokenSet> labelSupplier) {
        return this.allowWrite;
    }

    public boolean allowsCreateRelationship(int relType) {
        return this.allowWrite;
    }

    public boolean allowsDeleteRelationship(int relType) {
        return this.allowWrite;
    }

    public boolean allowsSetProperty(Supplier<TokenSet> labels, int propertyKey) {
        return this.allowWrite;
    }

    public boolean allowsSetProperty(IntSupplier relType, int propertyKey) {
        return this.allowWrite;
    }

    public AuthorizationViolationException onViolation(String msg) {
        return new AuthorizationViolationException("Forbidden in testAccessMode");
    }

    public String name() {
        return "Test";
    }
}

