/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;

class DiagnosticsLoggingTest {
    DiagnosticsLoggingTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldSeeExpectedDiagnostics() {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder().setInternalLogProvider((LogProvider)logProvider).impermanent().setConfig(GraphDatabaseInternalSettings.dump_configuration, (Object)true).setConfig(GraphDatabaseSettings.pagecache_memory, (Object)"4M").build();
        try {
            LogAssertions.assertThat((AssertableLogProvider)logProvider).containsMessages(new String[]{"Network information", "Disk space on partition", "Local timezone", "Page cache: 4M"});
            for (MetaDataStore.Position position : MetaDataStore.Position.values()) {
                LogAssertions.assertThat((AssertableLogProvider)logProvider).containsMessages(new String[]{position.name()});
            }
            LogAssertions.assertThat((AssertableLogProvider)logProvider).containsMessages(new String[]{"Transaction log", "TimeZone version: "});
        }
        finally {
            managementService.shutdown();
        }
    }
}

