/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.StringSearchMode;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class RequireTransactionIT {
    @Inject
    private GraphDatabaseAPI databaseAPI;
    private Transaction transaction;

    RequireTransactionIT() {
    }

    @BeforeEach
    void setUp() {
        this.transaction = this.databaseAPI.beginTx();
    }

    @AfterEach
    void tearDown() {
        if (this.transaction != null) {
            this.transaction.close();
        }
    }

    @Test
    void requireTransactionForNodeCreation() {
        Executable executable = () -> ((Transaction)this.transaction).createNode();
        this.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForNodeCreationWithLabels() {
        Executable executable = () -> this.transaction.createNode(new Label[]{Label.label((String)"label")});
        this.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForNodeLookupById() {
        Node node;
        try (Transaction tx = this.databaseAPI.beginTx();){
            node = tx.createNode();
            tx.commit();
        }
        Executable executable = () -> this.transaction.getNodeById(node.getId());
        this.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForRelationshipLookupById() {
        Relationship relationship;
        try (Transaction tx = this.databaseAPI.beginTx();){
            relationship = tx.createNode().createRelationshipTo(tx.createNode(), RelationshipType.withName((String)"type"));
            tx.commit();
        }
        Executable executable = () -> this.transaction.getNodeById(relationship.getId());
        this.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForBidirectionalTraversal() {
        Executable executable = () -> this.transaction.bidirectionalTraversalDescription();
        this.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForTraversal() {
        Executable executable = () -> this.transaction.traversalDescription();
        this.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForQueryExecution() {
        Executable executable = () -> this.transaction.execute("MATCH (n) RETURN count(n)");
        this.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForQueryExecutionWithParameters() {
        Executable executable = () -> this.transaction.execute("MATCH (n) RETURN count(n)", Collections.emptyMap());
        this.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForAllUsedLabelsLookup() {
        Executable executable = () -> this.transaction.getAllLabelsInUse();
        this.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForAllUsedRelationshipTypesLookup() {
        Executable executable = () -> this.transaction.getAllRelationshipTypesInUse();
        this.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForAllLabelsLookup() {
        Executable executable = () -> this.transaction.getAllLabels();
        this.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForAllRelationshipTypesLookup() {
        Executable executable = () -> this.transaction.getAllRelationshipTypes();
        this.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForAllPropertyKeysLookup() {
        Executable executable = () -> this.transaction.getAllPropertyKeys();
        this.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForNodeLookupByLabelPropertyTemplate() {
        Executable executable = () -> this.transaction.findNodes(Label.label((String)"label"), "a", "aa", StringSearchMode.CONTAINS);
        this.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForNodeLookupByLabelPropertyValues() {
        Executable executable = () -> this.transaction.findNodes(Label.label((String)"label"), Map.of("a", "b", "c", "d"));
        this.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForNodeLookupByLabelPropertyValuesPairs3() {
        Executable executable = () -> this.transaction.findNodes(Label.label((String)"label"), "a", (Object)"b", "c", (Object)"d", "e", (Object)"f");
        this.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForNodeLookupByLabelPropertyValuesPairs2() {
        Executable executable = () -> this.transaction.findNodes(Label.label((String)"label"), "a", (Object)"b", "c", (Object)"d");
        this.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForNodeLookupByLabelPropertyValuesPair() {
        Executable executable = () -> this.transaction.findNode(Label.label((String)"label"), "a", (Object)"b");
        this.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForNodesLookupByLabelPropertyValuesPair() {
        Executable executable = () -> this.transaction.findNodes(Label.label((String)"label"), "a", (Object)"b");
        this.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForNodeLookupByLabel() {
        Executable executable = () -> this.transaction.findNodes(Label.label((String)"label"));
        this.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void terminateCanBeCalledOnAnyTransaction() {
        this.transaction.terminate();
        this.transaction.close();
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> this.transaction.terminate());
    }

    @Test
    void closeCanBeCalledOnAnyTransaction() {
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> this.transaction.close());
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> this.transaction.close());
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> this.transaction.close());
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> this.transaction.close());
    }

    @Test
    void requireTransactionForRollback() {
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> this.transaction.rollback());
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> this.transaction.rollback());
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> this.transaction.rollback());
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> this.transaction.rollback());
    }

    @Test
    void requireTransactionForCommit() {
        Executable executable = () -> this.transaction.commit();
        this.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForAllNodesLookup() {
        Executable executable = () -> this.transaction.getAllNodes();
        this.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForAllRelationshipsLookup() {
        Executable executable = () -> this.transaction.getAllRelationships();
        this.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForWriteLockAcquisition() {
        Node node;
        try (Transaction tx = this.databaseAPI.beginTx();){
            node = tx.createNode();
            tx.commit();
        }
        Executable executable = () -> this.transaction.acquireWriteLock((Entity)node);
        this.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForReadLockAcquisition() {
        Node node;
        try (Transaction tx = this.databaseAPI.beginTx();){
            node = tx.createNode();
            tx.commit();
        }
        Executable executable = () -> this.transaction.acquireReadLock((Entity)node);
        this.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForSchemaAccess() {
        Executable executable = () -> this.transaction.schema();
        this.checkTransactionRequirement(this.transaction, executable);
    }

    private void checkTransactionRequirement(Transaction transaction, Executable executable) {
        try (Transaction transaction2 = transaction;){
            this.checkDoesNotThrow(executable);
        }
        this.checkThrowNotInTransaction(executable);
    }

    void checkDoesNotThrow(Executable executable) {
        org.junit.jupiter.api.Assertions.assertDoesNotThrow((Executable)executable);
    }

    void checkThrowNotInTransaction(Executable executable) {
        Exception e = (Exception)org.junit.jupiter.api.Assertions.assertThrows(Exception.class, (Executable)executable);
        Assertions.assertThat((Throwable)ExceptionUtils.getRootCause((Throwable)e)).isInstanceOf(NotInTransactionException.class);
    }
}

