/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestSupport;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public abstract class RelationshipWriteTestBase<G extends KernelAPIWriteTestSupport>
extends KernelAPIWriteTestBase<G> {
    @Test
    void shouldCreateRelationship() throws Exception {
        long r;
        long n2;
        long n1;
        try (Transaction tx = graphDb.beginTx();){
            n1 = tx.createNode().getId();
            n2 = tx.createNode().getId();
            tx.commit();
        }
        try (KernelTransaction tx = this.beginTransaction();){
            int label = tx.token().relationshipTypeGetOrCreateForName("R");
            r = tx.dataWrite().relationshipCreate(n1, label, n2);
            tx.commit();
        }
        tx = graphDb.beginTx();
        try {
            List relationships = Iterables.asList((Iterable)tx.getNodeById(n1).getRelationships());
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)relationships.size());
            org.junit.jupiter.api.Assertions.assertEquals((long)((Relationship)relationships.get(0)).getId(), (long)r);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldCreateRelationshipBetweenInTransactionNodes() throws Exception {
        long r;
        long n1;
        try (KernelTransaction tx = this.beginTransaction();){
            n1 = tx.dataWrite().nodeCreate();
            long n2 = tx.dataWrite().nodeCreate();
            int label = tx.token().relationshipTypeGetOrCreateForName("R");
            r = tx.dataWrite().relationshipCreate(n1, label, n2);
            tx.commit();
        }
        tx = graphDb.beginTx();
        try {
            List relationships = Iterables.asList((Iterable)tx.getNodeById(n1).getRelationships());
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)relationships.size());
            org.junit.jupiter.api.Assertions.assertEquals((long)((Relationship)relationships.get(0)).getId(), (long)r);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldRollbackRelationshipOnFailure() throws Exception {
        long n2;
        long n1;
        try (Transaction tx = graphDb.beginTx();){
            n1 = tx.createNode().getId();
            n2 = tx.createNode().getId();
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            int label = tx.token().relationshipTypeGetOrCreateForName("R");
            tx.dataWrite().relationshipCreate(n1, label, n2);
            tx.rollback();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = graphDb.beginTx();
        try {
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)tx.getNodeById(n1).getDegree());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldDeleteRelationship() throws Exception {
        long r;
        long n1;
        try (Transaction tx = graphDb.beginTx();){
            Node node1 = tx.createNode();
            Node node2 = tx.createNode();
            n1 = node1.getId();
            r = node1.createRelationshipTo(node2, RelationshipType.withName((String)"R")).getId();
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)tx.dataWrite().relationshipDelete(r), (String)"should delete relationship");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = graphDb.beginTx();
        try {
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)tx.getNodeById(n1).getDegree());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldNotDeleteRelationshipThatDoesNotExist() throws Exception {
        long relationship = 0L;
        try (KernelTransaction tx = this.beginTransaction();){
            org.junit.jupiter.api.Assertions.assertFalse((boolean)tx.dataWrite().relationshipDelete(relationship));
            tx.rollback();
        }
        tx = this.beginTransaction();
        try {
            org.junit.jupiter.api.Assertions.assertFalse((boolean)tx.dataWrite().relationshipDelete(relationship));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldDeleteRelationshipAddedInTransaction() throws Exception {
        long n2;
        long n1;
        try (Transaction tx = graphDb.beginTx();){
            n1 = tx.createNode().getId();
            n2 = tx.createNode().getId();
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            int label = tx.token().relationshipTypeGetOrCreateForName("R");
            long r = tx.dataWrite().relationshipCreate(n1, label, n2);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)tx.dataWrite().relationshipDelete(r));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = graphDb.beginTx();
        try {
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)tx.getNodeById(n1).getDegree());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldAddPropertyToRelationship() throws Exception {
        long relationshipId;
        String propertyKey = "prop";
        try (Transaction tx = graphDb.beginTx();){
            Node node1 = tx.createNode();
            Node node2 = tx.createNode();
            relationshipId = node1.createRelationshipTo(node2, RelationshipType.withName((String)"R")).getId();
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            int token = tx.token().propertyKeyGetOrCreateForName(propertyKey);
            Assertions.assertThat((Object)tx.dataWrite().relationshipSetProperty(relationshipId, token, (Value)Values.stringValue((String)"hello"))).isEqualTo((Object)Values.NO_VALUE);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction transaction = graphDb.beginTx();){
            Assertions.assertThat((Object)transaction.getRelationshipById(relationshipId).getProperty("prop")).isEqualTo((Object)"hello");
        }
    }

    @Test
    void shouldUpdatePropertyToRelationship() throws Exception {
        long relationshipId;
        String propertyKey = "prop";
        try (Transaction tx = graphDb.beginTx();){
            Node node1 = tx.createNode();
            Node node2 = tx.createNode();
            Relationship r = node1.createRelationshipTo(node2, RelationshipType.withName((String)"R"));
            r.setProperty(propertyKey, (Object)42);
            relationshipId = r.getId();
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            int token = tx.token().propertyKeyGetOrCreateForName(propertyKey);
            Assertions.assertThat((Object)tx.dataWrite().relationshipSetProperty(relationshipId, token, (Value)Values.stringValue((String)"hello"))).isEqualTo((Object)Values.intValue((int)42));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction transaction = graphDb.beginTx();){
            Assertions.assertThat((Object)transaction.getRelationshipById(relationshipId).getProperty("prop")).isEqualTo((Object)"hello");
        }
    }

    @Test
    void shouldRemovePropertyFromRelationship() throws Exception {
        long relationshipId;
        String propertyKey = "prop";
        try (Transaction tx = graphDb.beginTx();){
            Node node1 = tx.createNode();
            Node node2 = tx.createNode();
            Relationship proxy = node1.createRelationshipTo(node2, RelationshipType.withName((String)"R"));
            relationshipId = proxy.getId();
            proxy.setProperty(propertyKey, (Object)42);
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            int token = tx.token().propertyKeyGetOrCreateForName(propertyKey);
            Assertions.assertThat((Object)tx.dataWrite().relationshipRemoveProperty(relationshipId, token)).isEqualTo((Object)Values.intValue((int)42));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction transaction = graphDb.beginTx();){
            org.junit.jupiter.api.Assertions.assertFalse((boolean)transaction.getRelationshipById(relationshipId).hasProperty("prop"));
        }
    }

    @Test
    void shouldRemoveNonExistingPropertyFromRelationship() throws Exception {
        long relationshipId;
        String propertyKey = "prop";
        try (Transaction tx = graphDb.beginTx();){
            Node node1 = tx.createNode();
            Node node2 = tx.createNode();
            Relationship proxy = node1.createRelationshipTo(node2, RelationshipType.withName((String)"R"));
            relationshipId = proxy.getId();
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            int token = tx.token().propertyKeyGetOrCreateForName(propertyKey);
            Assertions.assertThat((Object)tx.dataWrite().relationshipRemoveProperty(relationshipId, token)).isEqualTo((Object)Values.NO_VALUE);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction transaction = graphDb.beginTx();){
            org.junit.jupiter.api.Assertions.assertFalse((boolean)transaction.getRelationshipById(relationshipId).hasProperty("prop"));
        }
    }

    @Test
    void shouldRemovePropertyFromRelationshipTwice() throws Exception {
        long relationshipId;
        String propertyKey = "prop";
        try (Transaction tx = graphDb.beginTx();){
            Node node1 = tx.createNode();
            Node node2 = tx.createNode();
            Relationship proxy = node1.createRelationshipTo(node2, RelationshipType.withName((String)"R"));
            relationshipId = proxy.getId();
            proxy.setProperty(propertyKey, (Object)42);
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            int token = tx.token().propertyKeyGetOrCreateForName(propertyKey);
            Assertions.assertThat((Object)tx.dataWrite().relationshipRemoveProperty(relationshipId, token)).isEqualTo((Object)Values.intValue((int)42));
            Assertions.assertThat((Object)tx.dataWrite().relationshipRemoveProperty(relationshipId, token)).isEqualTo((Object)Values.NO_VALUE);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction transaction = graphDb.beginTx();){
            org.junit.jupiter.api.Assertions.assertFalse((boolean)transaction.getRelationshipById(relationshipId).hasProperty("prop"));
        }
    }

    @Test
    void shouldUpdatePropertyToRelationshipInTransaction() throws Exception {
        long relationshipId;
        String propertyKey = "prop";
        try (Transaction tx = graphDb.beginTx();){
            Node node1 = tx.createNode();
            Node node2 = tx.createNode();
            relationshipId = node1.createRelationshipTo(node2, RelationshipType.withName((String)"R")).getId();
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            int token = tx.token().propertyKeyGetOrCreateForName(propertyKey);
            Assertions.assertThat((Object)tx.dataWrite().relationshipSetProperty(relationshipId, token, (Value)Values.stringValue((String)"hello"))).isEqualTo((Object)Values.NO_VALUE);
            Assertions.assertThat((Object)tx.dataWrite().relationshipSetProperty(relationshipId, token, (Value)Values.stringValue((String)"world"))).isEqualTo((Object)Values.stringValue((String)"hello"));
            Assertions.assertThat((Object)tx.dataWrite().relationshipSetProperty(relationshipId, token, (Value)Values.intValue((int)1337))).isEqualTo((Object)Values.stringValue((String)"world"));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction transaction = graphDb.beginTx();){
            Assertions.assertThat((Object)transaction.getRelationshipById(relationshipId).getProperty("prop")).isEqualTo((Object)1337);
        }
    }

    @Test
    void shouldNotWriteWhenSettingPropertyToSameValue() throws Exception {
        long relationshipId;
        String propertyKey = "prop";
        TextValue theValue = Values.stringValue((String)"The Value");
        try (Transaction ctx = graphDb.beginTx();){
            Node node1 = ctx.createNode();
            Node node2 = ctx.createNode();
            Relationship r = node1.createRelationshipTo(node2, RelationshipType.withName((String)"R"));
            r.setProperty(propertyKey, theValue.asObject());
            relationshipId = r.getId();
            ctx.commit();
        }
        KernelTransaction tx = this.beginTransaction();
        int property = tx.token().propertyKeyGetOrCreateForName(propertyKey);
        Assertions.assertThat((Object)tx.dataWrite().relationshipSetProperty(relationshipId, property, (Value)theValue)).isEqualTo((Object)theValue);
        Assertions.assertThat((long)tx.commit()).isEqualTo(0L);
    }
}

