/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.OpenOption;
import java.time.Duration;
import java.util.Arrays;
import java.util.function.LongSupplier;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.set.ImmutableSet;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.exceptions.KernelException;
import org.neo4j.exceptions.UnderlyingStorageException;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.id.DefaultIdGeneratorFactory;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.id.indexed.IndexedIdGenerator;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.internal.recordstorage.TransactionRecordState;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.fs.UncloseableDelegatingFileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreNotFoundException;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.PropertyKeyValue;
import org.neo4j.storageengine.api.RelationshipSelection;
import org.neo4j.storageengine.api.RelationshipVisitor;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StorageRelationshipScanCursor;
import org.neo4j.storageengine.api.StorageRelationshipTraversalCursor;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.string.UTF8;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.EphemeralNeo4jLayoutExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.pagecache.EphemeralPageCacheExtension;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.token.DelegatingTokenHolder;
import org.neo4j.token.api.TokenHolder;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@EphemeralNeo4jLayoutExtension
@EphemeralPageCacheExtension
public class NeoStoresTest {
    private static final NullLogProvider LOG_PROVIDER = NullLogProvider.getInstance();
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private TestDirectory dir;
    @Inject
    private PageCache pageCache;
    @Inject
    private DatabaseLayout databaseLayout;
    private PropertyStore pStore;
    private NodeStore nodeStore;
    private Database database;
    private KernelTransaction tx;
    private TransactionState transactionState;
    private StorageReader storageReader;
    private TokenHolder propertyKeyTokenHolder;
    private DatabaseManagementService managementService;

    @BeforeEach
    public void setUpNeoStores() {
        Config config = Config.defaults();
        StoreFactory sf = this.getStoreFactory(config, this.databaseLayout, this.fs, NullLogProvider.getInstance());
        sf.openAllNeoStores(true).close();
        this.propertyKeyTokenHolder = new DelegatingTokenHolder(this::createPropertyKeyToken, "PropertyKey");
    }

    @AfterEach
    void tearDown() {
        if (this.managementService != null) {
            this.managementService.shutdown();
        }
    }

    private int createPropertyKeyToken(String name, boolean internal) {
        return (int)this.nextId(PropertyKeyTokenRecord.class);
    }

    @Test
    void impossibleToGetStoreFromClosedNeoStoresContainer() {
        Config config = Config.defaults();
        StoreFactory sf = this.getStoreFactory(config, this.databaseLayout, this.fs, NullLogProvider.getInstance());
        NeoStores neoStores = sf.openAllNeoStores(true);
        Assertions.assertNotNull((Object)neoStores.getMetaDataStore());
        neoStores.close();
        IllegalStateException e = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> ((NeoStores)neoStores).getMetaDataStore());
        Assertions.assertEquals((Object)"Specified store was already closed.", (Object)e.getMessage());
    }

    @Test
    void notAllowCreateDynamicStoreWithNegativeBlockSize() {
        Config config = Config.defaults();
        StoreFactory sf = this.getStoreFactory(config, this.databaseLayout, this.fs, NullLogProvider.getInstance());
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> {
            try (NeoStores neoStores = sf.openNeoStores(true, new StoreType[0]);){
                neoStores.createDynamicArrayStore(new File("someStore"), new File("someIdFile"), IdType.ARRAY_BLOCK, -2, PageCursorTracer.NULL);
            }
        });
        Assertions.assertEquals((Object)"Block size of dynamic array store should be positive integer.", (Object)e.getMessage());
    }

    @Test
    void impossibleToGetNotRequestedStore() {
        Config config = Config.defaults();
        StoreFactory sf = this.getStoreFactory(config, this.databaseLayout, this.fs, NullLogProvider.getInstance());
        IllegalStateException e = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> {
            try (NeoStores neoStores = sf.openNeoStores(true, new StoreType[]{StoreType.NODE_LABEL});){
                neoStores.getMetaDataStore();
            }
        });
        Assertions.assertEquals((Object)("Specified store was not initialized. Please specify " + StoreType.META_DATA.name() + " as one of the stores types that should be open to be able to use it."), (Object)e.getMessage());
    }

    private StorageProperty nodeAddProperty(long nodeId, int key, Object value) {
        PropertyKeyValue property = new PropertyKeyValue(key, Values.of((Object)value));
        StorageProperty oldProperty = null;
        try (StorageNodeCursor nodeCursor = this.storageReader.allocateNodeCursor(PageCursorTracer.NULL);){
            StorageProperty fetched;
            nodeCursor.single(nodeId);
            if (nodeCursor.next() && (fetched = this.getProperty(key, nodeCursor.propertiesReference())) != null) {
                oldProperty = fetched;
            }
        }
        if (oldProperty == null) {
            this.transactionState.nodeDoAddProperty(nodeId, key, property.value());
        } else {
            this.transactionState.nodeDoChangeProperty(nodeId, key, property.value());
        }
        return property;
    }

    private StorageProperty getProperty(int key, long propertyId) {
        try (StoragePropertyCursor propertyCursor = this.storageReader.allocatePropertyCursor(PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            Value oldValue;
            propertyCursor.initNodeProperties(propertyId);
            if (propertyCursor.next() && (oldValue = propertyCursor.propertyValue()) != null) {
                PropertyKeyValue propertyKeyValue = new PropertyKeyValue(key, oldValue);
                return propertyKeyValue;
            }
        }
        return null;
    }

    @Test
    void testRels1() throws Exception {
        int i;
        this.reinitializeStores(this.databaseLayout);
        this.startTx();
        int relType1 = (int)this.nextId(RelationshipType.class);
        String typeName = "relationshiptype1";
        this.transactionState.relationshipTypeDoCreateForName(typeName, false, relType1);
        long[] nodeIds = new long[3];
        for (i = 0; i < 3; ++i) {
            nodeIds[i] = this.nextId(Node.class);
            this.transactionState.nodeDoCreate(nodeIds[i]);
            this.nodeAddProperty(nodeIds[i], this.index("nisse"), 10 - i);
        }
        for (i = 0; i < 2; ++i) {
            this.transactionState.relationshipDoCreate(this.nextId(Relationship.class), relType1, nodeIds[i], nodeIds[i + 1]);
        }
        this.commitTx();
        this.startTx();
        for (i = 0; i < 3; i += 2) {
            this.deleteRelationships(nodeIds[i]);
            this.transactionState.nodeDoDelete(nodeIds[i]);
        }
        this.commitTx();
    }

    private void relDelete(long id) {
        RelationshipVisitor visitor = (relId, type, startNode, endNode) -> this.transactionState.relationshipDoDelete(relId, type, startNode, endNode);
        if (!this.transactionState.relationshipVisit(id, visitor)) {
            try (StorageRelationshipScanCursor cursor = this.storageReader.allocateRelationshipScanCursor(PageCursorTracer.NULL);){
                cursor.single(id);
                if (!cursor.next()) {
                    throw new RuntimeException("Relationship " + id + " not found");
                }
                visitor.visit(id, cursor.type(), cursor.sourceNodeReference(), cursor.targetNodeReference());
            }
        }
    }

    @Test
    void testRels2() throws Exception {
        int i;
        this.reinitializeStores(this.databaseLayout);
        this.startTx();
        int relType1 = (int)this.nextId(RelationshipType.class);
        String typeName = "relationshiptype1";
        this.transactionState.relationshipTypeDoCreateForName(typeName, false, relType1);
        long[] nodeIds = new long[3];
        for (i = 0; i < 3; ++i) {
            nodeIds[i] = this.nextId(Node.class);
            this.transactionState.nodeDoCreate(nodeIds[i]);
            this.nodeAddProperty(nodeIds[i], this.index("nisse"), 10 - i);
        }
        for (i = 0; i < 2; ++i) {
            this.transactionState.relationshipDoCreate(this.nextId(Relationship.class), relType1, nodeIds[i], nodeIds[i + 1]);
        }
        this.transactionState.relationshipDoCreate(this.nextId(Relationship.class), relType1, nodeIds[0], nodeIds[2]);
        this.commitTx();
        this.startTx();
        for (i = 0; i < 3; ++i) {
            this.deleteRelationships(nodeIds[i]);
            this.transactionState.nodeDoDelete(nodeIds[i]);
        }
        this.commitTx();
    }

    @Test
    void testRels3() throws Exception {
        int i;
        this.reinitializeStores(this.databaseLayout);
        this.startTx();
        int relType1 = (int)this.nextId(RelationshipType.class);
        this.transactionState.relationshipTypeDoCreateForName("relationshiptype1", false, relType1);
        long[] nodeIds = new long[8];
        for (i = 0; i < nodeIds.length; ++i) {
            nodeIds[i] = this.nextId(Node.class);
            this.transactionState.nodeDoCreate(nodeIds[i]);
        }
        for (i = 0; i < nodeIds.length / 2; ++i) {
            this.transactionState.relationshipDoCreate(this.nextId(Relationship.class), relType1, nodeIds[i], nodeIds[i * 2]);
        }
        long rel5 = this.nextId(Relationship.class);
        this.transactionState.relationshipDoCreate(rel5, relType1, nodeIds[0], nodeIds[5]);
        long rel2 = this.nextId(Relationship.class);
        this.transactionState.relationshipDoCreate(rel2, relType1, nodeIds[1], nodeIds[2]);
        long rel3 = this.nextId(Relationship.class);
        this.transactionState.relationshipDoCreate(rel3, relType1, nodeIds[1], nodeIds[3]);
        long rel6 = this.nextId(Relationship.class);
        this.transactionState.relationshipDoCreate(rel6, relType1, nodeIds[1], nodeIds[6]);
        long rel1 = this.nextId(Relationship.class);
        this.transactionState.relationshipDoCreate(rel1, relType1, nodeIds[0], nodeIds[1]);
        long rel4 = this.nextId(Relationship.class);
        this.transactionState.relationshipDoCreate(rel4, relType1, nodeIds[0], nodeIds[4]);
        long rel7 = this.nextId(Relationship.class);
        this.transactionState.relationshipDoCreate(rel7, relType1, nodeIds[0], nodeIds[7]);
        this.commitTx();
        this.startTx();
        this.relDelete(rel7);
        this.relDelete(rel4);
        this.relDelete(rel1);
        this.relDelete(rel6);
        this.relDelete(rel3);
        this.relDelete(rel2);
        this.relDelete(rel5);
        this.commitTx();
    }

    @Test
    void setVersion() throws Exception {
        File storeDir = this.dir.homeDir();
        NeoStoresTest.createShutdownTestDatabase(this.fs, storeDir);
        Assertions.assertEquals((long)0L, (long)MetaDataStore.setRecord((PageCache)this.pageCache, (File)this.databaseLayout.metadataStore(), (MetaDataStore.Position)MetaDataStore.Position.LOG_VERSION, (long)10L, (PageCursorTracer)PageCursorTracer.NULL));
        Assertions.assertEquals((long)10L, (long)MetaDataStore.setRecord((PageCache)this.pageCache, (File)this.databaseLayout.metadataStore(), (MetaDataStore.Position)MetaDataStore.Position.LOG_VERSION, (long)12L, (PageCursorTracer)PageCursorTracer.NULL));
        Config config = Config.defaults();
        StoreFactory sf = this.getStoreFactory(config, this.databaseLayout, this.fs, LOG_PROVIDER);
        NeoStores neoStores = sf.openAllNeoStores();
        Assertions.assertEquals((long)12L, (long)neoStores.getMetaDataStore().getCurrentLogVersion());
        neoStores.close();
    }

    @Test
    void shouldNotReadNonRecordDataAsRecord() throws Exception {
        StoreFactory factory = NeoStoresTest.newStoreFactory(this.databaseLayout, this.pageCache, this.fs);
        long recordVersion = NeoStoresTest.defaultStoreVersion();
        try (NeoStores neoStores = factory.openAllNeoStores(true);){
            MetaDataStore metaDataStore = neoStores.getMetaDataStore();
            metaDataStore.setCreationTime(3L, PageCursorTracer.NULL);
            metaDataStore.setRandomNumber(4L, PageCursorTracer.NULL);
            metaDataStore.setCurrentLogVersion(5L, PageCursorTracer.NULL);
            metaDataStore.setLastCommittedAndClosedTransactionId(6L, 0, 0L, 43L, 44L, PageCursorTracer.NULL);
            metaDataStore.setStoreVersion(recordVersion, PageCursorTracer.NULL);
            metaDataStore.setLatestConstraintIntroducingTx(9L, PageCursorTracer.NULL);
        }
        File file = this.databaseLayout.metadataStore();
        try (StoreChannel channel = this.fs.write(file);){
            channel.position(0L);
            channel.writeAll(ByteBuffer.wrap(UTF8.encode((String)"This is some data that is not a record.")));
        }
        MetaDataStore.setRecord((PageCache)this.pageCache, (File)file, (MetaDataStore.Position)MetaDataStore.Position.STORE_VERSION, (long)recordVersion, (PageCursorTracer)PageCursorTracer.NULL);
        try (NeoStores neoStores = factory.openAllNeoStores();){
            MetaDataStore metaDataStore = neoStores.getMetaDataStore();
            Assertions.assertEquals((long)-1L, (long)metaDataStore.getCreationTime());
            Assertions.assertEquals((long)-1L, (long)metaDataStore.getRandomNumber());
            Assertions.assertEquals((long)-1L, (long)metaDataStore.getCurrentLogVersion());
            Assertions.assertEquals((long)-1L, (long)metaDataStore.getLastCommittedTransactionId());
            Assertions.assertEquals((long)-1L, (long)metaDataStore.getLastClosedTransactionId());
            Assertions.assertEquals((long)recordVersion, (long)metaDataStore.getStoreVersion());
            Assertions.assertEquals((long)9L, (long)metaDataStore.getLatestConstraintIntroducingTx());
            Assertions.assertArrayEquals((long[])new long[]{-1L, 44L, 43L}, (long[])metaDataStore.getLastClosedTransaction());
        }
    }

    @Test
    void testSetLatestConstraintTx() throws IOException {
        Config config = Config.defaults();
        StoreFactory sf = new StoreFactory(this.databaseLayout, config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(this.fs, RecoveryCleanupWorkCollector.immediate()), this.pageCache, this.fs, (LogProvider)LOG_PROVIDER, PageCacheTracer.NULL);
        NeoStores neoStores = sf.openAllNeoStores(true);
        MetaDataStore metaDataStore = neoStores.getMetaDataStore();
        Assertions.assertEquals((long)0L, (long)metaDataStore.getLatestConstraintIntroducingTx());
        metaDataStore.setLatestConstraintIntroducingTx(10L, PageCursorTracer.NULL);
        Assertions.assertEquals((long)10L, (long)metaDataStore.getLatestConstraintIntroducingTx());
        neoStores.flush(IOLimiter.UNLIMITED, PageCursorTracer.NULL);
        neoStores.close();
        neoStores = sf.openAllNeoStores();
        Assertions.assertEquals((long)10L, (long)neoStores.getMetaDataStore().getLatestConstraintIntroducingTx());
        neoStores.close();
    }

    @Test
    void shouldInitializeTheTxIdToOne() {
        StoreFactory factory = this.getStoreFactory(Config.defaults(), this.databaseLayout, this.fs, LOG_PROVIDER);
        try (NeoStores neoStores = factory.openAllNeoStores(true);){
            neoStores.getMetaDataStore();
        }
        neoStores = factory.openAllNeoStores();
        try {
            long lastCommittedTransactionId = neoStores.getMetaDataStore().getLastCommittedTransactionId();
            Assertions.assertEquals((long)1L, (long)lastCommittedTransactionId);
        }
        finally {
            if (neoStores != null) {
                neoStores.close();
            }
        }
    }

    @Test
    void shouldThrowUnderlyingStorageExceptionWhenFailingToLoadStorage() {
        FileSystemAbstraction fileSystem = this.fs;
        StoreFactory factory = this.getStoreFactory(Config.defaults(), this.databaseLayout, fileSystem, LOG_PROVIDER);
        try (NeoStores neoStores = factory.openAllNeoStores(true);){
            neoStores.getMetaDataStore();
        }
        File file = this.databaseLayout.metadataStore();
        fileSystem.deleteFile(file);
        Assertions.assertThrows(StoreNotFoundException.class, () -> {
            try (NeoStores neoStores = factory.openAllNeoStores();){
                neoStores.getMetaDataStore();
            }
        });
    }

    @Test
    void shouldAddUpgradeFieldsToTheNeoStoreIfNotPresent() throws IOException {
        MetaDataStore metaDataStore;
        StoreFactory factory = NeoStoresTest.newStoreFactory(this.databaseLayout, this.pageCache, this.fs);
        long recordVersion = NeoStoresTest.defaultStoreVersion();
        try (NeoStores neoStores = factory.openAllNeoStores(true);){
            MetaDataStore metaDataStore2 = neoStores.getMetaDataStore();
            metaDataStore2.setCreationTime(3L, PageCursorTracer.NULL);
            metaDataStore2.setRandomNumber(4L, PageCursorTracer.NULL);
            metaDataStore2.setCurrentLogVersion(5L, PageCursorTracer.NULL);
            metaDataStore2.setLastCommittedAndClosedTransactionId(6L, 42, 0L, 43L, 44L, PageCursorTracer.NULL);
            metaDataStore2.setStoreVersion(recordVersion, PageCursorTracer.NULL);
            metaDataStore2.setLatestConstraintIntroducingTx(9L, PageCursorTracer.NULL);
        }
        File file = this.databaseLayout.metadataStore();
        Assertions.assertNotEquals((long)10L, (long)MetaDataStore.getRecord((PageCache)this.pageCache, (File)file, (MetaDataStore.Position)MetaDataStore.Position.UPGRADE_TRANSACTION_ID, (PageCursorTracer)PageCursorTracer.NULL));
        Assertions.assertNotEquals((long)11L, (long)MetaDataStore.getRecord((PageCache)this.pageCache, (File)file, (MetaDataStore.Position)MetaDataStore.Position.UPGRADE_TRANSACTION_CHECKSUM, (PageCursorTracer)PageCursorTracer.NULL));
        MetaDataStore.setRecord((PageCache)this.pageCache, (File)file, (MetaDataStore.Position)MetaDataStore.Position.UPGRADE_TRANSACTION_ID, (long)10L, (PageCursorTracer)PageCursorTracer.NULL);
        MetaDataStore.setRecord((PageCache)this.pageCache, (File)file, (MetaDataStore.Position)MetaDataStore.Position.UPGRADE_TRANSACTION_CHECKSUM, (long)11L, (PageCursorTracer)PageCursorTracer.NULL);
        MetaDataStore.setRecord((PageCache)this.pageCache, (File)file, (MetaDataStore.Position)MetaDataStore.Position.UPGRADE_TIME, (long)12L, (PageCursorTracer)PageCursorTracer.NULL);
        try (NeoStores neoStores = factory.openAllNeoStores();){
            metaDataStore = neoStores.getMetaDataStore();
            Assertions.assertEquals((long)3L, (long)metaDataStore.getCreationTime());
            Assertions.assertEquals((long)4L, (long)metaDataStore.getRandomNumber());
            Assertions.assertEquals((long)5L, (long)metaDataStore.getCurrentLogVersion());
            Assertions.assertEquals((long)6L, (long)metaDataStore.getLastCommittedTransactionId());
            Assertions.assertEquals((long)recordVersion, (long)metaDataStore.getStoreVersion());
            Assertions.assertEquals((long)9L, (long)metaDataStore.getLatestConstraintIntroducingTx());
            Assertions.assertEquals((Object)new TransactionId(10L, 11, 0L), (Object)metaDataStore.getUpgradeTransaction());
            Assertions.assertEquals((long)12L, (long)metaDataStore.getUpgradeTime());
            Assertions.assertArrayEquals((long[])new long[]{6L, 44L, 43L}, (long[])metaDataStore.getLastClosedTransaction());
        }
        MetaDataStore.setRecord((PageCache)this.pageCache, (File)file, (MetaDataStore.Position)MetaDataStore.Position.UPGRADE_TRANSACTION_COMMIT_TIMESTAMP, (long)13L, (PageCursorTracer)PageCursorTracer.NULL);
        neoStores = factory.openAllNeoStores();
        try {
            metaDataStore = neoStores.getMetaDataStore();
            Assertions.assertEquals((Object)new TransactionId(10L, 11, 13L), (Object)metaDataStore.getUpgradeTransaction());
        }
        finally {
            if (neoStores != null) {
                neoStores.close();
            }
        }
    }

    @Test
    void shouldSetHighestTransactionIdWhenNeeded() {
        StoreFactory factory = this.getStoreFactory(Config.defaults(), this.databaseLayout, this.fs, LOG_PROVIDER);
        try (NeoStores neoStore = factory.openAllNeoStores(true);){
            MetaDataStore store = neoStore.getMetaDataStore();
            store.setLastCommittedAndClosedTransactionId(40L, 4444, 0L, 64L, 0L, PageCursorTracer.NULL);
            store.transactionCommitted(42L, 6666, 0L, PageCursorTracer.NULL);
            Assertions.assertEquals((Object)new TransactionId(42L, 6666, 0L), (Object)store.getLastCommittedTransaction());
            Assertions.assertArrayEquals((long[])new long[]{40L, 0L, 64L}, (long[])store.getLastClosedTransaction());
        }
    }

    @Test
    void tracePageCacheAccessOnTransactionCloseCall() {
        StoreFactory factory = this.getStoreFactory(Config.defaults(), this.databaseLayout, this.fs, LOG_PROVIDER);
        try (NeoStores neoStore = factory.openAllNeoStores(true);){
            MetaDataStore store = neoStore.getMetaDataStore();
            DefaultPageCacheTracer cacheTracer = new DefaultPageCacheTracer();
            PageCursorTracer cursorTracer = cacheTracer.createPageCursorTracer("tracePageCacheAccessOnTransactionCloseCall");
            store.transactionClosed(0L, 6666L, 15L, cursorTracer);
            Assertions.assertEquals((long)1L, (long)cursorTracer.pins());
            Assertions.assertEquals((long)1L, (long)cursorTracer.hits());
            Assertions.assertEquals((long)1L, (long)cursorTracer.unpins());
        }
    }

    @Test
    void tracePageCacheAccessOnTransactionCommittedCall() {
        StoreFactory factory = this.getStoreFactory(Config.defaults(), this.databaseLayout, this.fs, LOG_PROVIDER);
        try (NeoStores neoStore = factory.openAllNeoStores(true);){
            MetaDataStore store = neoStore.getMetaDataStore();
            DefaultPageCacheTracer cacheTracer = new DefaultPageCacheTracer();
            PageCursorTracer cursorTracer = cacheTracer.createPageCursorTracer("tracePageCacheAccessOnTransactionCommittedCall");
            store.transactionCommitted(42L, 6666, 0L, cursorTracer);
            Assertions.assertEquals((long)1L, (long)cursorTracer.pins());
            Assertions.assertEquals((long)1L, (long)cursorTracer.hits());
            Assertions.assertEquals((long)1L, (long)cursorTracer.unpins());
        }
    }

    @Test
    void shouldNotSetHighestTransactionIdWhenNeeded() {
        StoreFactory factory = this.getStoreFactory(Config.defaults(), this.databaseLayout, this.fs, LOG_PROVIDER);
        try (NeoStores neoStore = factory.openAllNeoStores(true);){
            MetaDataStore store = neoStore.getMetaDataStore();
            store.setLastCommittedAndClosedTransactionId(40L, 4444, 0L, 64L, 0L, PageCursorTracer.NULL);
            store.transactionCommitted(39L, 3333, 0L, PageCursorTracer.NULL);
            Assertions.assertEquals((Object)new TransactionId(40L, 4444, 0L), (Object)store.getLastCommittedTransaction());
            Assertions.assertArrayEquals((long[])new long[]{40L, 0L, 64L}, (long[])store.getLastClosedTransaction());
        }
    }

    @Test
    void shouldCloseAllTheStoreEvenIfExceptionsAreThrown() {
        Config defaults = Config.defaults((Setting)GraphDatabaseInternalSettings.counts_store_rotation_timeout, (Object)Duration.ofMinutes(60L));
        String errorMessage = "Failing for the heck of it";
        StoreFactory factory = new StoreFactory(this.databaseLayout, defaults, (IdGeneratorFactory)new CloseFailingDefaultIdGeneratorFactory(this.fs, errorMessage), this.pageCache, this.fs, (LogProvider)NullLogProvider.getInstance(), PageCacheTracer.NULL);
        NeoStores neoStore = factory.openAllNeoStores(true);
        UnderlyingStorageException ex = (UnderlyingStorageException)Assertions.assertThrows(UnderlyingStorageException.class, () -> ((NeoStores)neoStore).close());
        Assertions.assertEquals((Object)errorMessage, (Object)ex.getCause().getMessage());
    }

    @Test
    void isPresentAfterCreatingAllStores() throws Exception {
        this.fs.deleteRecursively(this.databaseLayout.databaseDirectory());
        DefaultIdGeneratorFactory idFactory = new DefaultIdGeneratorFactory(this.fs, RecoveryCleanupWorkCollector.immediate());
        StoreFactory factory = new StoreFactory(this.databaseLayout, Config.defaults(), (IdGeneratorFactory)idFactory, this.pageCache, this.fs, (LogProvider)LOG_PROVIDER, PageCacheTracer.NULL);
        try (NeoStores ignore = factory.openAllNeoStores(true);){
            Assertions.assertTrue((boolean)NeoStores.isStorePresent((FileSystemAbstraction)this.fs, (DatabaseLayout)this.databaseLayout));
        }
    }

    @Test
    void isPresentFalseAfterCreatingAllButLastStoreType() throws Exception {
        this.fs.deleteRecursively(this.databaseLayout.databaseDirectory());
        DefaultIdGeneratorFactory idFactory = new DefaultIdGeneratorFactory(this.fs, RecoveryCleanupWorkCollector.immediate());
        StoreFactory factory = new StoreFactory(this.databaseLayout, Config.defaults(), (IdGeneratorFactory)idFactory, this.pageCache, this.fs, (LogProvider)LOG_PROVIDER, PageCacheTracer.NULL);
        StoreType[] allStoreTypes = StoreType.values();
        StoreType[] allButLastStoreTypes = Arrays.copyOf(allStoreTypes, allStoreTypes.length - 1);
        try (NeoStores ignore = factory.openNeoStores(true, allButLastStoreTypes);){
            Assertions.assertFalse((boolean)NeoStores.isStorePresent((FileSystemAbstraction)this.fs, (DatabaseLayout)this.databaseLayout));
        }
    }

    private static long defaultStoreVersion() {
        return MetaDataStore.versionStringToLong((String)RecordFormatSelector.defaultFormat().storeVersion());
    }

    private static StoreFactory newStoreFactory(DatabaseLayout databaseLayout, PageCache pageCache, FileSystemAbstraction fs) {
        RecordFormats recordFormats = RecordFormatSelector.defaultFormat();
        Config config = Config.defaults();
        DefaultIdGeneratorFactory idGeneratorFactory = new DefaultIdGeneratorFactory(fs, RecoveryCleanupWorkCollector.immediate());
        return new StoreFactory(databaseLayout, config, (IdGeneratorFactory)idGeneratorFactory, pageCache, fs, recordFormats, (LogProvider)LOG_PROVIDER, PageCacheTracer.NULL, Sets.immutable.empty());
    }

    private void reinitializeStores(DatabaseLayout databaseLayout) {
        Dependencies dependencies = new Dependencies();
        Config config = Config.defaults((Setting)GraphDatabaseSettings.fail_on_missing_files, (Object)false);
        dependencies.satisfyDependency((Object)config);
        if (this.managementService != null) {
            this.managementService.shutdown();
        }
        this.managementService = new TestDatabaseManagementServiceBuilder().setFileSystem(this.fs).setExternalDependencies((DependencyResolver)dependencies).setDatabaseRootDirectory(databaseLayout.databaseDirectory()).build();
        GraphDatabaseAPI databaseAPI = (GraphDatabaseAPI)this.managementService.database("neo4j");
        this.database = (Database)databaseAPI.getDependencyResolver().resolveDependency(Database.class);
        NeoStores neoStores = ((RecordStorageEngine)this.database.getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores();
        this.pStore = neoStores.getPropertyStore();
        this.nodeStore = neoStores.getNodeStore();
        this.storageReader = ((StorageEngine)this.database.getDependencyResolver().resolveDependency(StorageEngine.class)).newReader();
    }

    private void startTx() throws TransactionFailureException {
        this.tx = this.database.getKernel().beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        this.transactionState = ((KernelTransactionImplementation)this.tx).txState();
    }

    private void commitTx() throws TransactionFailureException {
        this.tx.commit();
    }

    private int index(String key) throws KernelException {
        return this.propertyKeyTokenHolder.getOrCreateId(key);
    }

    private long nextId(Class<?> clazz) {
        NeoStores neoStores = ((RecordStorageEngine)this.database.getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores();
        if (clazz.equals(PropertyKeyTokenRecord.class)) {
            return neoStores.getPropertyKeyTokenStore().nextId(PageCursorTracer.NULL);
        }
        if (clazz.equals(RelationshipType.class)) {
            return neoStores.getRelationshipTypeTokenStore().nextId(PageCursorTracer.NULL);
        }
        if (clazz.equals(Node.class)) {
            return neoStores.getNodeStore().nextId(PageCursorTracer.NULL);
        }
        if (clazz.equals(Relationship.class)) {
            return neoStores.getRelationshipStore().nextId(PageCursorTracer.NULL);
        }
        throw new IllegalArgumentException(clazz.getName());
    }

    private StorageRelationshipTraversalCursor allocateRelationshipTraversalCursor(StorageNodeCursor node) {
        StorageRelationshipTraversalCursor relationships = this.storageReader.allocateRelationshipTraversalCursor(PageCursorTracer.NULL);
        node.relationships(relationships, RelationshipSelection.ALL_RELATIONSHIPS);
        return relationships;
    }

    private StorageNodeCursor allocateNodeCursor(long nodeId) {
        StorageNodeCursor nodeCursor = this.storageReader.allocateNodeCursor(PageCursorTracer.NULL);
        nodeCursor.single(nodeId);
        return nodeCursor;
    }

    private void deleteRelationships(long nodeId) {
        try (StorageNodeCursor nodeCursor = this.allocateNodeCursor(nodeId);){
            Assertions.assertTrue((boolean)nodeCursor.next());
            try (StorageRelationshipTraversalCursor relationships = this.allocateRelationshipTraversalCursor(nodeCursor);){
                while (relationships.next()) {
                    this.relDelete(relationships.entityReference());
                }
            }
        }
    }

    private static void createShutdownTestDatabase(FileSystemAbstraction fileSystem, File storeDir) {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(storeDir).setFileSystem((FileSystemAbstraction)new UncloseableDelegatingFileSystemAbstraction(fileSystem)).impermanent().build();
        managementService.shutdown();
    }

    private <RECEIVER extends TransactionRecordState.PropertyReceiver<PropertyKeyValue>> void nodeLoadProperties(long nodeId, RECEIVER receiver) {
        NodeRecord nodeRecord = (NodeRecord)this.nodeStore.getRecord(nodeId, (AbstractBaseRecord)((NodeRecord)this.nodeStore.newRecord()), RecordLoad.NORMAL, PageCursorTracer.NULL);
        this.loadProperties(nodeRecord.getNextProp(), receiver);
    }

    private <RECEIVER extends TransactionRecordState.PropertyReceiver<PropertyKeyValue>> void loadProperties(long nextProp, RECEIVER receiver) {
        PropertyRecord record = this.pStore.newRecord();
        while (!Record.NULL_REFERENCE.is(nextProp)) {
            this.pStore.getRecord(nextProp, (AbstractBaseRecord)record, RecordLoad.NORMAL, PageCursorTracer.NULL);
            for (PropertyBlock propBlock : record) {
                receiver.receive((StorageProperty)propBlock.newPropertyKeyValue(this.pStore, PageCursorTracer.NULL), record.getId());
            }
            nextProp = record.getNextProp();
        }
    }

    private StoreFactory getStoreFactory(Config config, DatabaseLayout databaseLayout, FileSystemAbstraction fs, NullLogProvider logProvider) {
        return new StoreFactory(databaseLayout, config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(fs, RecoveryCleanupWorkCollector.immediate()), this.pageCache, fs, (LogProvider)logProvider, PageCacheTracer.NULL);
    }

    private static class CloseFailingDefaultIdGeneratorFactory
    extends DefaultIdGeneratorFactory {
        private final String errorMessage;

        CloseFailingDefaultIdGeneratorFactory(FileSystemAbstraction fs, String errorMessage) {
            super(fs, RecoveryCleanupWorkCollector.immediate());
            this.errorMessage = errorMessage;
        }

        protected IndexedIdGenerator instantiate(FileSystemAbstraction fs, PageCache pageCache, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, File fileName, LongSupplier highIdSupplier, long maxValue, IdType idType, boolean readOnly, PageCursorTracer cursorTracer, ImmutableSet<OpenOption> openOptions) {
            if (idType == IdType.NODE) {
                return new IndexedIdGenerator(pageCache, fileName, RecoveryCleanupWorkCollector.immediate(), idType, this.allowLargeIdCaches, () -> 42L, maxValue, readOnly, cursorTracer){

                    public synchronized void close() {
                        super.close();
                        throw new IllegalStateException(errorMessage);
                    }
                };
            }
            return super.instantiate(fs, pageCache, recoveryCleanupWorkCollector, fileName, highIdSupplier, maxValue, idType, readOnly, cursorTracer, openOptions);
        }
    }
}

