/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import org.apache.commons.lang3.RandomStringUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.index.label.LabelScanStore;
import org.neo4j.internal.index.label.RelationshipTypeScanStore;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.transaction.state.storeview.DynamicIndexStoreView;
import org.neo4j.kernel.impl.transaction.state.storeview.NeoStoreIndexStoreView;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.lock.LockService;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class DynamicIndexStoreViewTracingIT {
    @Inject
    private GraphDatabaseAPI database;
    @Inject
    private LockService lockService;
    @Inject
    private LabelScanStore labelScanStore;
    @Inject
    private RelationshipTypeScanStore relationshipTypeScanStore;
    @Inject
    private RecordStorageEngine storageEngine;

    DynamicIndexStoreViewTracingIT() {
    }

    @Test
    void tracePageCacheAccess() throws Exception {
        int nodeCount = 1000;
        Label label = Label.label((String)"marker");
        try (Transaction tx = this.database.beginTx();){
            for (int i = 0; i < nodeCount; ++i) {
                Node node = tx.createNode(new Label[]{label});
                node.setProperty("a", (Object)RandomStringUtils.randomAscii((int)10));
            }
            tx.commit();
        }
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer();
        try (PageCursorTracer cursorTracer = pageCacheTracer.createPageCursorTracer("tracePageCacheAccess");){
            NeoStoreIndexStoreView neoStoreStoreView = new NeoStoreIndexStoreView(this.lockService, () -> ((RecordStorageEngine)this.storageEngine).newReader());
            DynamicIndexStoreView indexStoreView = new DynamicIndexStoreView(neoStoreStoreView, this.labelScanStore, this.relationshipTypeScanStore, this.lockService, () -> ((RecordStorageEngine)this.storageEngine).newReader(), (LogProvider)NullLogProvider.nullLogProvider(), Config.defaults());
            StoreScan storeScan = indexStoreView.visitNodes(new int[]{0, 1, 2}, Predicates.ALWAYS_TRUE_INT, null, element -> false, false, cursorTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            storeScan.run();
        }
        Assertions.assertThat((long)pageCacheTracer.pins()).isEqualTo(6L);
        Assertions.assertThat((long)pageCacheTracer.unpins()).isEqualTo(6L);
        Assertions.assertThat((long)pageCacheTracer.hits()).isEqualTo(6L);
    }
}

