/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal;

import java.util.Collections;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.internal.locker.FileLockException;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
class LockerLifecycleAdapterTest {
    @Inject
    private TestDirectory directory;

    LockerLifecycleAdapterTest() {
    }

    @Test
    void shouldAllowDatabasesToUseFilesetsSequentially() {
        DatabaseManagementService managementService = this.newDb();
        managementService.shutdown();
        managementService = this.newDb();
        managementService.shutdown();
    }

    @Test
    void shouldNotAllowDatabasesToUseFilesetsConcurrently() {
        this.shouldNotAllowDatabasesToUseFilesetsConcurrently(Collections.emptyMap());
    }

    @Test
    void shouldNotAllowDatabasesToUseFilesetsConcurrentlyEvenIfTheyAreInReadOnlyMode() {
        this.shouldNotAllowDatabasesToUseFilesetsConcurrently(Map.of(GraphDatabaseSettings.read_only, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shouldNotAllowDatabasesToUseFilesetsConcurrently(Map<Setting<?>, Object> config) {
        DatabaseManagementService managementService = this.newDb();
        DatabaseManagementService embeddedService = null;
        try {
            embeddedService = new TestDatabaseManagementServiceBuilder(this.directory.homeDir()).setConfig(config).build();
            org.junit.jupiter.api.Assertions.fail();
        }
        catch (RuntimeException e) {
            Assertions.assertThat((Throwable)e.getCause().getCause()).isInstanceOf(FileLockException.class);
        }
        finally {
            if (embeddedService != null) {
                embeddedService.shutdown();
            }
            if (managementService != null) {
                managementService.shutdown();
            }
        }
    }

    private DatabaseManagementService newDb() {
        return new TestDatabaseManagementServiceBuilder(this.directory.homeDir()).build();
    }
}

