/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.junit.jupiter.api.Test;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.NodeIndexCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.IndexReadAsserts;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestSupport;

abstract class NodeLabelIndexCursorTestBase<G extends KernelAPIWriteTestSupport>
extends KernelAPIWriteTestBase<G> {
    private int labelOne = 1;
    private int labelTwo = 2;
    private int labelThree = 3;
    private int labelFirst = 4;

    NodeLabelIndexCursorTestBase() {
    }

    @Test
    void shouldFindNodesByLabel() throws Exception {
        long toDelete;
        try (KernelTransaction tx = this.beginTransaction();){
            this.createNode(tx.dataWrite(), this.labelOne, this.labelFirst);
            this.createNode(tx.dataWrite(), this.labelTwo, this.labelFirst);
            this.createNode(tx.dataWrite(), this.labelThree, this.labelFirst);
            toDelete = this.createNode(tx.dataWrite(), this.labelOne);
            this.createNode(tx.dataWrite(), this.labelTwo);
            this.createNode(tx.dataWrite(), this.labelThree);
            this.createNode(tx.dataWrite(), this.labelThree);
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            tx.dataWrite().nodeDelete(toDelete);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.beginTransaction();
        try {
            Read read = tx.dataRead();
            try (NodeLabelIndexCursor cursor = tx.cursors().allocateNodeLabelIndexCursor(tx.pageCursorTracer());){
                LongHashSet uniqueIds = new LongHashSet();
                read.nodeLabelScan(this.labelOne, cursor, IndexOrder.NONE);
                IndexReadAsserts.assertNodeCount((NodeIndexCursor)cursor, 1, (MutableLongSet)uniqueIds);
                read.nodeLabelScan(this.labelTwo, cursor, IndexOrder.NONE);
                IndexReadAsserts.assertNodeCount((NodeIndexCursor)cursor, 2, (MutableLongSet)uniqueIds);
                read.nodeLabelScan(this.labelThree, cursor, IndexOrder.NONE);
                IndexReadAsserts.assertNodeCount((NodeIndexCursor)cursor, 3, (MutableLongSet)uniqueIds);
                uniqueIds.clear();
                read.nodeLabelScan(this.labelFirst, cursor, IndexOrder.NONE);
                IndexReadAsserts.assertNodeCount((NodeIndexCursor)cursor, 3, (MutableLongSet)uniqueIds);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldFindNodesByLabelInTx() throws Exception {
        long deletedInTx;
        long inStore;
        try (KernelTransaction tx = this.beginTransaction();){
            inStore = this.createNode(tx.dataWrite(), this.labelOne);
            this.createNode(tx.dataWrite(), this.labelTwo);
            deletedInTx = this.createNode(tx.dataWrite(), this.labelOne);
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            tx.dataWrite().nodeDelete(deletedInTx);
            long createdInTx = this.createNode(tx.dataWrite(), this.labelOne);
            this.createNode(tx.dataWrite(), this.labelTwo);
            Read read = tx.dataRead();
            try (NodeLabelIndexCursor cursor = tx.cursors().allocateNodeLabelIndexCursor(tx.pageCursorTracer());){
                LongHashSet uniqueIds = new LongHashSet();
                read.nodeLabelScan(this.labelOne, cursor, IndexOrder.NONE);
                IndexReadAsserts.assertNodes((NodeIndexCursor)cursor, (MutableLongSet)uniqueIds, inStore, createdInTx);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private long createNode(Write write, int ... labels) throws KernelException {
        long nodeId = write.nodeCreate();
        for (int label : labels) {
            write.nodeAddLabel(nodeId, label);
        }
        return nodeId;
    }
}

