/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.DatabaseStateService;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.transaction.log.FlushablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParserSetV2_3;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.kernel.recovery.LogTailScanner;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.migration.UpgradeNotAllowedException;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.extension.pagecache.PageCacheExtension;
import org.neo4j.test.rule.TestDirectory;

@PageCacheExtension
@Neo4jLayoutExtension
class LogVersionUpgradeCheckerIT {
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private FileSystemAbstraction fileSystem;
    @Inject
    private PageCache pageCache;
    private DatabaseLayout databaseLayout;

    LogVersionUpgradeCheckerIT() {
    }

    @BeforeEach
    void setUp() {
        this.databaseLayout = DatabaseLayout.ofFlat((File)this.testDirectory.directory("neo4j", new String[0]));
    }

    @Test
    void startAsNormalWhenUpgradeIsNotAllowed() {
        this.createGraphDbAndKillIt();
        DatabaseManagementService managementService = this.startDatabaseService(false);
        managementService.database("neo4j");
        managementService.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void failToStartFromOlderTransactionLogsIfNotAllowed() throws Exception {
        this.createStoreWithLogEntryVersion(LogEntryParserSetV2_3.V2_3.version());
        DatabaseManagementService managementService = this.startDatabaseService(false);
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
        try {
            DatabaseStateService dbStateService = (DatabaseStateService)db.getDependencyResolver().resolveDependency(DatabaseStateService.class);
            Optional failure = dbStateService.causeOfFailure(db.databaseId());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)failure.isPresent());
            Assertions.assertThat((Throwable)((Throwable)failure.get())).hasRootCauseInstanceOf(UpgradeNotAllowedException.class);
        }
        finally {
            managementService.shutdown();
        }
    }

    @Test
    void startFromOlderTransactionLogsIfAllowed() throws Exception {
        this.createStoreWithLogEntryVersion(LogEntryParserSetV2_3.V2_3.version());
        DatabaseManagementService managementService = this.startDatabaseService(true);
        managementService.database("neo4j");
        managementService.shutdown();
    }

    private void createGraphDbAndKillIt() {
        DatabaseManagementService managementService = this.startDatabaseService(false);
        GraphDatabaseService db = managementService.database("neo4j");
        try (Transaction tx = db.beginTx();){
            tx.createNode(new Label[]{Label.label((String)"FOO")});
            tx.createNode(new Label[]{Label.label((String)"BAR")});
            tx.commit();
        }
        managementService.shutdown();
    }

    private void createStoreWithLogEntryVersion(byte logEntryVersion) throws Exception {
        this.createGraphDbAndKillIt();
        this.appendCheckpoint(logEntryVersion);
    }

    private void appendCheckpoint(byte logEntryVersion) throws IOException {
        VersionAwareLogEntryReader logEntryReader = new VersionAwareLogEntryReader(StorageEngineFactory.selectStorageEngine().commandReaderFactory());
        LogFiles logFiles = LogFilesBuilder.activeFilesBuilder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem, (PageCache)this.pageCache).withLogEntryReader((LogEntryReader)logEntryReader).build();
        LogTailScanner tailScanner = new LogTailScanner(logFiles, (LogEntryReader)logEntryReader, new Monitors(), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        LogTailScanner.LogTailInformation tailInformation = tailScanner.getTailInformation();
        try (Lifespan lifespan = new Lifespan(new Lifecycle[]{logFiles});){
            FlushablePositionAwareChecksumChannel channel = logFiles.getLogFile().getWriter();
            LogPosition logPosition = tailInformation.lastCheckPoint.getLogPosition();
            channel.put(logEntryVersion).put((byte)7).putLong(logPosition.getLogVersion()).putLong(logPosition.getByteOffset());
            channel.prepareForFlush().flush();
        }
    }

    private DatabaseManagementService startDatabaseService(boolean allowUpgrade) {
        File rootDirectory = this.databaseLayout.databaseDirectory().getParentFile();
        return new TestDatabaseManagementServiceBuilder(this.databaseLayout).setFileSystem(this.fileSystem).impermanent().setConfig(GraphDatabaseSettings.transaction_logs_root_path, (Object)rootDirectory.toPath()).setConfig(GraphDatabaseSettings.allow_upgrade, (Object)allowUpgrade).build();
    }
}

