/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.transaction.SimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.SimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class LogPruningIT {
    private static final SimpleTriggerInfo triggerInfo = new SimpleTriggerInfo("forced trigger");
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    private LogRotation logRotation;
    @Inject
    private CheckPointer checkPointer;
    @Inject
    private Config config;
    @Inject
    private FileSystemAbstraction fs;

    LogPruningIT() {
    }

    @Test
    void pruningStrategyShouldBeDynamic() throws IOException {
        LogFiles logFiles = LogFilesBuilder.builder((DatabaseLayout)this.db.databaseLayout(), (FileSystemAbstraction)this.fs).withLogVersionRepository((LogVersionRepository)new SimpleLogVersionRepository()).withLastCommittedTransactionIdSupplier(() -> 1L).withCommandReaderFactory(((StorageEngineFactory)this.db.getDependencyResolver().resolveDependency(StorageEngineFactory.class)).commandReaderFactory()).withTransactionIdStore((TransactionIdStore)new SimpleTransactionIdStore()).build();
        this.writeTransactionsAndRotateTwice();
        this.checkPointer.forceCheckPoint((TriggerInfo)triggerInfo);
        Assertions.assertThat((int)LogPruningIT.countTransactionLogs(logFiles)).isEqualTo(3);
        this.config.setDynamic(GraphDatabaseSettings.keep_logical_logs, (Object)"false", "LogPruningIT");
        this.checkPointer.forceCheckPoint((TriggerInfo)triggerInfo);
        Assertions.assertThat((int)LogPruningIT.countTransactionLogs(logFiles)).isEqualTo(2);
    }

    private void writeTransactionsAndRotateTwice() throws IOException {
        try (Transaction tx = this.db.beginTx();){
            tx.createNode();
            tx.commit();
        }
        this.logRotation.rotateLogFile(LogAppendEvent.NULL);
        tx = this.db.beginTx();
        try {
            tx.createNode();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.logRotation.rotateLogFile(LogAppendEvent.NULL);
        tx = this.db.beginTx();
        try {
            tx.createNode();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.createNode();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private static int countTransactionLogs(LogFiles logFiles) {
        return logFiles.logFiles().length;
    }
}

