/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
public class IndexingCompositeQueryAcceptanceTest {
    @Inject
    private GraphDatabaseAPI db;
    private static final Label LABEL = Label.label((String)"LABEL1");
    private static final IndexSeek biIndexSeek = (keys, values, db, tx) -> {
        assert (keys.length == 2);
        assert (values.length == 2);
        return tx.findNodes(LABEL, keys[0], values[0], keys[1], values[1]);
    };
    private static final IndexSeek triIndexSeek = (keys, values, db, tx) -> {
        assert (keys.length == 3);
        assert (values.length == 3);
        return tx.findNodes(LABEL, keys[0], values[0], keys[1], values[1], keys[2], values[2]);
    };
    private static final IndexSeek mapIndexSeek = (keys, values, db, tx) -> tx.findNodes(LABEL, IndexingCompositeQueryAcceptanceTest.propertyMap(keys, values));

    public static Stream<Arguments> data() {
        return Stream.of(IndexingCompositeQueryAcceptanceTest.testCase((Integer[])Iterators.array((Object[])new Integer[]{2, 3}), biIndexSeek, true), IndexingCompositeQueryAcceptanceTest.testCase((Integer[])Iterators.array((Object[])new Integer[]{2, 3}), biIndexSeek, false), IndexingCompositeQueryAcceptanceTest.testCase((Integer[])Iterators.array((Object[])new Integer[]{2, 3, 4}), triIndexSeek, true), IndexingCompositeQueryAcceptanceTest.testCase((Integer[])Iterators.array((Object[])new Integer[]{2, 3, 4}), triIndexSeek, false), IndexingCompositeQueryAcceptanceTest.testCase((Integer[])Iterators.array((Object[])new Integer[]{2, 3, 4, 5, 6}), mapIndexSeek, true), IndexingCompositeQueryAcceptanceTest.testCase((Integer[])Iterators.array((Object[])new Integer[]{2, 3, 4, 5, 6}), mapIndexSeek, false));
    }

    public void setup(boolean withIndex, String[] keys) {
        if (withIndex) {
            try (Transaction tx = this.db.beginTx();){
                tx.schema().indexFor(LABEL).on(keys[0]).create();
                IndexCreator indexCreator = tx.schema().indexFor(LABEL);
                for (String key : keys) {
                    indexCreator = indexCreator.on(key);
                }
                indexCreator.create();
                tx.commit();
            }
            tx = this.db.beginTx();
            try {
                tx.schema().awaitIndexesOnline(5L, TimeUnit.MINUTES);
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void shouldSupportIndexSeek(String[] keys, Object[] values, Object[][] nonMatching, IndexSeek indexSeek, boolean withIndex) {
        this.setup(withIndex, keys);
        this.createNodes((GraphDatabaseService)this.db, LABEL, keys, nonMatching);
        MutableLongSet expected = this.createNodes((GraphDatabaseService)this.db, LABEL, keys, new Object[][]{values});
        LongHashSet found = new LongHashSet();
        try (Transaction tx = this.db.beginTx();){
            this.collectNodes((MutableLongSet)found, indexSeek.findNodes(keys, values, (GraphDatabaseService)this.db, tx));
        }
        Assertions.assertThat((Object)found).isEqualTo((Object)expected);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void shouldSupportIndexSeekBackwardsOrder(String[] keys, Object[] values, Object[][] nonMatching, IndexSeek indexSeek, boolean withIndex) {
        this.setup(withIndex, keys);
        this.createNodes((GraphDatabaseService)this.db, LABEL, keys, nonMatching);
        MutableLongSet expected = this.createNodes((GraphDatabaseService)this.db, LABEL, keys, new Object[][]{values});
        LongHashSet found = new LongHashSet();
        String[] reversedKeys = new String[keys.length];
        Object[] reversedValues = new Object[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            reversedValues[keys.length - 1 - i] = values[i];
            reversedKeys[keys.length - 1 - i] = keys[i];
        }
        try (Transaction tx = this.db.beginTx();){
            this.collectNodes((MutableLongSet)found, indexSeek.findNodes(reversedKeys, reversedValues, (GraphDatabaseService)this.db, tx));
        }
        Assertions.assertThat((Object)found).isEqualTo((Object)expected);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void shouldIncludeNodesCreatedInSameTxInIndexSeek(String[] keys, Object[] values, Object[][] nonMatching, IndexSeek indexSeek, boolean withIndex) {
        this.setup(withIndex, keys);
        this.createNodes((GraphDatabaseService)this.db, LABEL, keys, nonMatching[0], nonMatching[1]);
        MutableLongSet expected = this.createNodes((GraphDatabaseService)this.db, LABEL, keys, new Object[][]{values});
        LongHashSet found = new LongHashSet();
        try (Transaction tx = this.db.beginTx();){
            expected.add(this.createNode(tx, IndexingCompositeQueryAcceptanceTest.propertyMap(keys, values), LABEL).getId());
            this.createNode(tx, IndexingCompositeQueryAcceptanceTest.propertyMap(keys, nonMatching[2]), LABEL);
            this.collectNodes((MutableLongSet)found, indexSeek.findNodes(keys, values, (GraphDatabaseService)this.db, tx));
        }
        Assertions.assertThat((Object)found).isEqualTo((Object)expected);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void shouldNotIncludeNodesDeletedInSameTxInIndexSeek(String[] keys, Object[] values, Object[][] nonMatching, IndexSeek indexSeek, boolean withIndex) {
        this.setup(withIndex, keys);
        this.createNodes((GraphDatabaseService)this.db, LABEL, keys, new Object[][]{nonMatching[0]});
        MutableLongSet toDelete = this.createNodes((GraphDatabaseService)this.db, LABEL, keys, values, nonMatching[1], nonMatching[2]);
        MutableLongSet expected = this.createNodes((GraphDatabaseService)this.db, LABEL, keys, new Object[][]{values});
        LongHashSet found = new LongHashSet();
        try (Transaction tx = this.db.beginTx();){
            LongIterator deleting = toDelete.longIterator();
            while (deleting.hasNext()) {
                long id = deleting.next();
                tx.getNodeById(id).delete();
                expected.remove(id);
            }
            this.collectNodes((MutableLongSet)found, indexSeek.findNodes(keys, values, (GraphDatabaseService)this.db, tx));
        }
        Assertions.assertThat((Object)found).isEqualTo((Object)expected);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void shouldConsiderNodesChangedInSameTxInIndexSeek(String[] keys, Object[] values, Object[][] nonMatching, IndexSeek indexSeek, boolean withIndex) {
        this.setup(withIndex, keys);
        this.createNodes((GraphDatabaseService)this.db, LABEL, keys, new Object[][]{nonMatching[0]});
        MutableLongSet toChangeToMatch = this.createNodes((GraphDatabaseService)this.db, LABEL, keys, new Object[][]{nonMatching[1]});
        MutableLongSet toChangeToNotMatch = this.createNodes((GraphDatabaseService)this.db, LABEL, keys, new Object[][]{values});
        MutableLongSet expected = this.createNodes((GraphDatabaseService)this.db, LABEL, keys, new Object[][]{values});
        LongHashSet found = new LongHashSet();
        try (Transaction tx = this.db.beginTx();){
            LongIterator toMatching = toChangeToMatch.longIterator();
            while (toMatching.hasNext()) {
                long id = toMatching.next();
                this.setProperties(tx, id, keys, values);
                expected.add(id);
            }
            LongIterator toNotMatching = toChangeToNotMatch.longIterator();
            while (toNotMatching.hasNext()) {
                long id = toNotMatching.next();
                this.setProperties(tx, id, keys, nonMatching[2]);
                expected.remove(id);
            }
            this.collectNodes((MutableLongSet)found, indexSeek.findNodes(keys, values, (GraphDatabaseService)this.db, tx));
        }
        Assertions.assertThat((Object)found).isEqualTo((Object)expected);
    }

    private MutableLongSet createNodes(GraphDatabaseService db, Label label, String[] keys, Object[] ... propertyValueTuples) {
        LongHashSet expected = new LongHashSet();
        try (Transaction tx = db.beginTx();){
            for (Object[] valueTuple : propertyValueTuples) {
                expected.add(this.createNode(tx, IndexingCompositeQueryAcceptanceTest.propertyMap(keys, valueTuple), label).getId());
            }
            tx.commit();
        }
        return expected;
    }

    private static Map<String, Object> propertyMap(String[] keys, Object[] valueTuple) {
        HashMap<String, Object> propertyValues = new HashMap<String, Object>();
        for (int i = 0; i < keys.length; ++i) {
            propertyValues.put(keys[i], valueTuple[i]);
        }
        return propertyValues;
    }

    private void collectNodes(MutableLongSet bucket, ResourceIterator<Node> toCollect) {
        while (toCollect.hasNext()) {
            bucket.add(((Node)toCollect.next()).getId());
        }
    }

    public Node createNode(Transaction transaction, Map<String, Object> properties, Label ... labels) {
        Node node = transaction.createNode(labels);
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            node.setProperty(property.getKey(), property.getValue());
        }
        return node;
    }

    private static Arguments testCase(Integer[] values, IndexSeek indexSeek, boolean withIndex) {
        Object[][] nonMatching = new Object[][]{IndexingCompositeQueryAcceptanceTest.plus(values, 1), IndexingCompositeQueryAcceptanceTest.plus(values, 2), IndexingCompositeQueryAcceptanceTest.plus(values, 3)};
        String[] keys = (String[])Arrays.stream(values).map(v -> "key" + v).toArray(String[]::new);
        return Arguments.of((Object[])new Object[]{keys, values, nonMatching, indexSeek, withIndex});
    }

    private static <T> Object[] plus(Integer[] values, int offset) {
        Object[] result = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = values[i] + offset;
        }
        return result;
    }

    private void setProperties(Transaction tx, long id, String[] keys, Object[] values) {
        Node node = tx.getNodeById(id);
        for (int i = 0; i < keys.length; ++i) {
            node.setProperty(keys[i], values[i]);
        }
    }

    private static interface IndexSeek {
        public ResourceIterator<Node> findNodes(String[] var1, Object[] var2, GraphDatabaseService var3, Transaction var4);
    }
}

