/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.database.DbmsRuntimeRepository;
import org.neo4j.dbms.database.DbmsRuntimeSystemGraphComponent;
import org.neo4j.dbms.database.DbmsRuntimeVersion;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.dbms.database.SystemGraphComponents;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.ResultTransformer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;

@TestDirectoryExtension
@DbmsExtension
class DbmsRuntimeSystemGraphComponentTest {
    @Inject
    private GraphDatabaseService userDatabase;
    private GraphDatabaseService fakeSystemDb;
    private final SystemGraphComponents systemGraphComponents = new SystemGraphComponents();
    private DbmsRuntimeSystemGraphComponent dbmsRuntimeSystemGraphComponent;

    DbmsRuntimeSystemGraphComponentTest() {
    }

    @BeforeEach
    void beforeEach() {
        this.fakeSystemDb = new FakeSystemDb(this.userDatabase);
        this.initDbmsComponent(false);
    }

    @Test
    void testInitialisationOnFreshDatabase() {
        this.systemGraphComponents.initializeSystemGraph(this.fakeSystemDb);
        this.assertDbmsRuntimeNode(DbmsRuntimeRepository.LATEST_VERSION.getVersionNumber());
        this.assertStatus(SystemGraphComponent.Status.CURRENT);
    }

    @Test
    void testInitialisationOnExistingDatabase() {
        this.userDatabase.executeTransactionally("CREATE (:Version)");
        this.systemGraphComponents.initializeSystemGraph(this.fakeSystemDb);
        this.assertDbmsRuntimeNode(DbmsRuntimeVersion.V4_1.getVersionNumber());
        this.assertStatus(SystemGraphComponent.Status.REQUIRES_UPGRADE);
    }

    @Test
    void testInitialisationOnExistingDatabaseWithAutomaticUpgrade() {
        this.systemGraphComponents.deregister("dbms-runtime");
        this.initDbmsComponent(true);
        this.userDatabase.executeTransactionally("CREATE (:Version)");
        this.systemGraphComponents.initializeSystemGraph(this.fakeSystemDb);
        this.assertDbmsRuntimeNode(DbmsRuntimeRepository.LATEST_VERSION.getVersionNumber());
        this.assertStatus(SystemGraphComponent.Status.CURRENT);
    }

    @Test
    void testCurrentVersionPresent() {
        this.createDbmsRuntimeNode(DbmsRuntimeRepository.LATEST_VERSION);
        this.systemGraphComponents.initializeSystemGraph(this.fakeSystemDb);
        this.assertDbmsRuntimeNode(DbmsRuntimeRepository.LATEST_VERSION.getVersionNumber());
        this.assertStatus(SystemGraphComponent.Status.CURRENT);
    }

    @Test
    void testOldVersionPresent() {
        this.createDbmsRuntimeNode(DbmsRuntimeVersion.V4_1);
        this.systemGraphComponents.initializeSystemGraph(this.fakeSystemDb);
        this.assertDbmsRuntimeNode(DbmsRuntimeVersion.V4_1.getVersionNumber());
        this.assertStatus(SystemGraphComponent.Status.REQUIRES_UPGRADE);
    }

    @Test
    void testUpgrade() throws Exception {
        this.createDbmsRuntimeNode(DbmsRuntimeVersion.V4_1);
        this.assertStatus(SystemGraphComponent.Status.REQUIRES_UPGRADE);
        this.systemGraphComponents.upgradeToCurrent(this.fakeSystemDb);
        this.assertDbmsRuntimeNode(DbmsRuntimeRepository.LATEST_VERSION.getVersionNumber());
        this.assertStatus(SystemGraphComponent.Status.CURRENT);
    }

    @Test
    void upgradeFromUninitialized() throws Exception {
        this.assertStatus(SystemGraphComponent.Status.UNINITIALIZED);
        this.systemGraphComponents.upgradeToCurrent(this.fakeSystemDb);
        this.assertDbmsRuntimeNode(DbmsRuntimeRepository.LATEST_VERSION.getVersionNumber());
        this.assertStatus(SystemGraphComponent.Status.CURRENT);
    }

    private void initDbmsComponent(boolean automaticUpgrade) {
        Config config = Config.newBuilder().set(GraphDatabaseSettings.allow_single_automatic_upgrade, (Object)automaticUpgrade).build();
        this.dbmsRuntimeSystemGraphComponent = new DbmsRuntimeSystemGraphComponent(config);
        this.systemGraphComponents.register((SystemGraphComponent)this.dbmsRuntimeSystemGraphComponent);
    }

    private void assertDbmsRuntimeNode(int expectedVersion) {
        int foundVersion = (Integer)this.userDatabase.executeTransactionally("MATCH (n:DbmsRuntime) RETURN n.version AS version", Map.of(), result -> {
            ResourceIterator ri = result.columnAs("version");
            return (Integer)ri.stream().findFirst().get();
        });
        Assertions.assertEquals((int)expectedVersion, (int)foundVersion);
    }

    private void assertStatus(SystemGraphComponent.Status expectedStatus) {
        try (Transaction tx = this.userDatabase.beginTx();){
            Assertions.assertEquals((Object)expectedStatus, (Object)this.dbmsRuntimeSystemGraphComponent.detect(tx));
        }
    }

    private void createDbmsRuntimeNode(DbmsRuntimeVersion version) {
        try (Transaction tx = this.userDatabase.beginTx();){
            tx.createNode(new Label[]{Label.label((String)"DbmsRuntime")}).setProperty("version", (Object)version.getVersionNumber());
            tx.commit();
        }
    }

    private static class FakeSystemDb
    implements GraphDatabaseService {
        private final GraphDatabaseService wrappedDb;

        FakeSystemDb(GraphDatabaseService wrappedDb) {
            this.wrappedDb = wrappedDb;
        }

        public boolean isAvailable(long timeout) {
            return this.wrappedDb.isAvailable(timeout);
        }

        public Transaction beginTx() {
            return this.wrappedDb.beginTx();
        }

        public Transaction beginTx(long timeout, TimeUnit unit) {
            return this.wrappedDb.beginTx(timeout, unit);
        }

        public void executeTransactionally(String query) throws QueryExecutionException {
            throw new IllegalStateException("Not implemented");
        }

        public void executeTransactionally(String query, Map<String, Object> parameters) throws QueryExecutionException {
            throw new IllegalStateException("Not implemented");
        }

        public <T> T executeTransactionally(String query, Map<String, Object> parameters, ResultTransformer<T> resultTransformer) throws QueryExecutionException {
            throw new IllegalStateException("Not implemented");
        }

        public <T> T executeTransactionally(String query, Map<String, Object> parameters, ResultTransformer<T> resultTransformer, Duration timeout) throws QueryExecutionException {
            throw new IllegalStateException("Not implemented");
        }

        public String databaseName() {
            return "system";
        }
    }
}

