/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;

class NodeManagerTest {
    private GraphDatabaseAPI db;
    private DatabaseManagementService managementService;

    NodeManagerTest() {
    }

    @BeforeEach
    void init() {
        this.managementService = new TestDatabaseManagementServiceBuilder().impermanent().build();
        this.db = (GraphDatabaseAPI)this.managementService.database("neo4j");
    }

    @AfterEach
    void stop() {
        this.managementService.shutdown();
    }

    @Test
    void getAllNodesIteratorShouldPickUpHigherIdsThanHighIdWhenStarted() throws Exception {
        Transaction tx = this.db.beginTx();
        tx.createNode();
        tx.createNode();
        tx.commit();
        try (Transaction transaction = this.db.beginTx();){
            ResourceIterator allNodes = transaction.getAllNodes().iterator();
            allNodes.next();
            Thread thread = new Thread(() -> {
                Transaction newTx = this.db.beginTx();
                newTx.createNode();
                newTx.commit();
            });
            thread.start();
            thread.join();
            Assertions.assertThat((int)((ArrayList)Iterators.addToCollection((Iterator)allNodes, new ArrayList())).size()).isEqualTo(2);
        }
    }

    @Test
    void getAllRelationshipsIteratorShouldPickUpHigherIdsThanHighIdWhenStarted() throws Exception {
        Transaction tx = this.db.beginTx();
        this.createRelationshipAssumingTxWith(tx, "key", 1);
        this.createRelationshipAssumingTxWith(tx, "key", 2);
        tx.commit();
        tx = this.db.beginTx();
        ResourceIterator allRelationships = tx.getAllRelationships().iterator();
        Thread thread = new Thread(() -> {
            Transaction newTx = this.db.beginTx();
            this.createRelationshipAssumingTxWith(newTx, "key", 3);
            newTx.commit();
        });
        thread.start();
        thread.join();
        Assertions.assertThat((int)((ArrayList)Iterators.addToCollection((Iterator)allRelationships, new ArrayList())).size()).isEqualTo(3);
        tx.commit();
    }

    private void createRelationshipAssumingTxWith(Transaction transaction, String key, Object value) {
        Node a = transaction.createNode();
        Node b = transaction.createNode();
        Relationship relationship = a.createRelationshipTo(b, RelationshipType.withName((String)"FOO"));
        relationship.setProperty(key, value);
    }
}

