/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.rule.concurrent.ThreadingExtension;
import org.neo4j.test.rule.concurrent.ThreadingRule;

@DbmsExtension(configurationCallback="configure")
@ExtendWith(value={ThreadingExtension.class})
public class ListQueriesProcedureTest {
    @Inject
    private GraphDatabaseService db;
    @Inject
    private ThreadingRule threads;
    private static final int SECONDS_TIMEOUT = 240;
    private static final Condition<Object> LONG_VALUE = new Condition(value -> value instanceof Long, "long value", new Object[0]);

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseSettings.cypher_hints_error, (Object)true).setConfig(GraphDatabaseSettings.track_query_allocation, (Object)true).setConfig(GraphDatabaseSettings.track_query_cpu_time, (Object)true);
    }

    @Test
    void shouldContainTheQueryItself() {
        try (Transaction transaction = this.db.beginTx();){
            String query = "CALL dbms.listQueries";
            Result result = transaction.execute(query);
            Map row = result.next();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)result.hasNext());
            org.junit.jupiter.api.Assertions.assertEquals((Object)query, row.get("query"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)this.db.databaseName(), row.get("database"));
            transaction.commit();
        }
    }

    @Test
    void shouldNotIncludeDeprecatedFields() {
        try (Transaction transaction = this.db.beginTx();){
            Result result = transaction.execute("CALL dbms.listQueries");
            Map row = result.next();
            Assertions.assertThat((Map)row).doesNotContainKey((Object)"elapsedTime");
            Assertions.assertThat((Map)row).doesNotContainKey((Object)"connectionDetails");
            transaction.commit();
        }
    }

    @Test
    void shouldContainSpecificConnectionDetails() {
        Map<String, Object> data = this.getQueryListing("CALL dbms.listQueries");
        Assertions.assertThat(data).containsKey((Object)"protocol");
        Assertions.assertThat(data).containsKey((Object)"connectionId");
        Assertions.assertThat(data).containsKey((Object)"clientAddress");
        Assertions.assertThat(data).containsKey((Object)"requestUri");
    }

    @Test
    void shouldContainPageHitsAndPageFaults() throws Exception {
        String query = "MATCH (n) SET n.v = n.v + 1";
        try (Resource<Node> test = this.test(Transaction::createNode, query);){
            Map<String, Object> data = this.getQueryListing(query);
            Assertions.assertThat(data).hasEntrySatisfying((Object)"pageHits", LONG_VALUE);
            Assertions.assertThat(data).hasEntrySatisfying((Object)"pageFaults", LONG_VALUE);
        }
    }

    @Test
    void shouldListUsedIndexes() throws Exception {
        String label = "IndexedLabel";
        String property = "indexedProperty";
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(Label.label((String)label)).on(property).create();
            tx.commit();
        }
        this.ensureIndexesAreOnline();
        this.shouldListUsedIndexes(label, property);
    }

    private void ensureIndexesAreOnline() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexesOnline(240L, TimeUnit.SECONDS);
            tx.commit();
        }
    }

    @Test
    void shouldListUsedUniqueIndexes() throws Exception {
        String label = "UniqueLabel";
        String property = "uniqueProperty";
        try (Transaction tx = this.db.beginTx();){
            tx.schema().constraintFor(Label.label((String)label)).assertPropertyIsUnique(property).create();
            tx.commit();
        }
        this.ensureIndexesAreOnline();
        this.shouldListUsedIndexes(label, property);
    }

    @Test
    void shouldListIndexesUsedForScans() throws Exception {
        String QUERY = "MATCH (n:Node) USING INDEX n:Node(value) WHERE 1 < n.value < 10 SET n.value = 2";
        try (Transaction tx2 = this.db.beginTx();){
            tx2.schema().indexFor(Label.label((String)"Node")).on("value").create();
            tx2.commit();
        }
        this.ensureIndexesAreOnline();
        try (Resource<Node> test = this.test(tx -> {
            Node node = tx.createNode(new Label[]{Label.label((String)"Node")});
            node.setProperty("value", (Object)5L);
            return node;
        }, "MATCH (n:Node) USING INDEX n:Node(value) WHERE 1 < n.value < 10 SET n.value = 2");){
            Map<String, Object> data = this.getQueryListing("MATCH (n:Node) USING INDEX n:Node(value) WHERE 1 < n.value < 10 SET n.value = 2");
            Assertions.assertThat(data).hasEntrySatisfying((Object)"indexes", value -> Assertions.assertThat((Object)value).isInstanceOf(List.class));
            List indexes = (List)data.get("indexes");
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)indexes.size(), (String)"number of indexes used");
            Map index = (Map)indexes.get(0);
            Assertions.assertThat((Map)index).containsEntry((Object)"identifier", (Object)"n");
            Assertions.assertThat((Map)index).containsEntry((Object)"label", (Object)"Node");
            Assertions.assertThat((Map)index).containsEntry((Object)"propertyKey", (Object)"value");
        }
    }

    private void shouldListUsedIndexes(String label, String property) throws Exception {
        String QUERY1 = "MATCH (n:" + label + "{" + property + ":5}) USING INDEX n:" + label + "(" + property + ") SET n." + property + " = 3";
        try (Resource<Node> test = this.test(tx -> {
            Node node = tx.createNode(new Label[]{Label.label((String)label)});
            node.setProperty(property, (Object)5L);
            return node;
        }, QUERY1);){
            Map<String, Object> data = this.getQueryListing(QUERY1);
            Assertions.assertThat(data).containsEntry((Object)"runtime", (Object)"interpreted");
            Assertions.assertThat(data).containsEntry((Object)"status", (Object)"waiting");
            Assertions.assertThat(data).hasEntrySatisfying((Object)"indexes", value -> Assertions.assertThat((Object)value).isInstanceOf(List.class));
            List indexes = (List)data.get("indexes");
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)indexes.size(), (String)"number of indexes used");
            Map index = (Map)indexes.get(0);
            Assertions.assertThat((Map)index).containsEntry((Object)"identifier", (Object)"n");
            Assertions.assertThat((Map)index).containsEntry((Object)"label", (Object)label);
            Assertions.assertThat((Map)index).containsEntry((Object)"propertyKey", (Object)property);
        }
        String QUERY2 = "MATCH (n:" + label + "{" + property + ":3}) USING INDEX n:" + label + "(" + property + ") MATCH (u:" + label + "{" + property + ":4}) USING INDEX u:" + label + "(" + property + ") CREATE (n)-[:KNOWS]->(u)";
        try (Resource<Node> test = this.test(tx -> {
            Node node = tx.createNode(new Label[]{Label.label((String)label)});
            node.setProperty(property, (Object)4L);
            return node;
        }, QUERY2);){
            Map<String, Object> data = this.getQueryListing(QUERY2);
            Assertions.assertThat(data).hasEntrySatisfying((Object)"indexes", value -> Assertions.assertThat((Object)value).isInstanceOf(List.class));
            List indexes = (List)data.get("indexes");
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)indexes.size(), (String)"number of indexes used");
            Map index1 = (Map)indexes.get(0);
            Assertions.assertThat((Map)index1).containsEntry((Object)"identifier", (Object)"n");
            Assertions.assertThat((Map)index1).containsEntry((Object)"label", (Object)label);
            Assertions.assertThat((Map)index1).containsEntry((Object)"propertyKey", (Object)property);
            Map index2 = (Map)indexes.get(1);
            Assertions.assertThat((Map)index2).containsEntry((Object)"identifier", (Object)"u");
            Assertions.assertThat((Map)index2).containsEntry((Object)"label", (Object)label);
            Assertions.assertThat((Map)index2).containsEntry((Object)"propertyKey", (Object)property);
        }
    }

    private Map<String, Object> getQueryListing(String query) {
        try (Transaction transaction = this.db.beginTx();){
            try (Result rows = transaction.execute("CALL dbms.listQueries");){
                while (true) {
                    if (rows.hasNext()) {
                        Map row = rows.next();
                        if (!query.equals(row.get("query"))) continue;
                        Map map = row;
                        return map;
                        continue;
                    }
                    break;
                }
            }
            transaction.commit();
        }
        throw new AssertionError((Object)("query not active: " + query));
    }

    private <T extends Entity> Resource<T> test(Function<Transaction, T> setup, String ... queries) throws InterruptedException, ExecutionException {
        Entity resource;
        CountDownLatch resourceLocked = new CountDownLatch(1);
        CountDownLatch listQueriesLatch = new CountDownLatch(1);
        CountDownLatch finishQueriesLatch = new CountDownLatch(1);
        try (Transaction tx = this.db.beginTx();){
            resource = (Entity)setup.apply(tx);
            tx.commit();
        }
        this.threads.execute(parameter -> {
            try (Transaction tx = this.db.beginTx();){
                tx.acquireWriteLock(resource);
                resourceLocked.countDown();
                listQueriesLatch.await();
            }
            return null;
        }, null);
        resourceLocked.await();
        this.threads.executeAndAwait(parameter -> {
            try (Transaction tx = this.db.beginTx();){
                for (String query : queries) {
                    tx.execute(query).close();
                }
                tx.commit();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            finally {
                finishQueriesLatch.countDown();
            }
            return null;
        }, null, ThreadingRule.waitingWhileIn(Locks.Client.class, (String)"acquireExclusive"), 240L, TimeUnit.SECONDS);
        return new Resource<Entity>(listQueriesLatch, finishQueriesLatch, resource);
    }

    private static class Resource<T>
    implements AutoCloseable {
        private final CountDownLatch latch;
        private final CountDownLatch finishLatch;
        private final T resource;

        private Resource(CountDownLatch latch, CountDownLatch finishLatch, T resource) {
            this.latch = latch;
            this.finishLatch = finishLatch;
            this.resource = resource;
        }

        @Override
        public void close() throws InterruptedException {
            this.latch.countDown();
            this.finishLatch.await();
        }

        public T resource() {
            return this.resource;
        }
    }
}

