/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.Kernel;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.test.Race;

class KernelAPIParallelStress {
    KernelAPIParallelStress() {
    }

    static <RESOURCE extends AutoCloseable> void parallelStressInTx(Kernel kernel, int nThreads, Function<KernelTransaction, RESOURCE> resourceSupplier, BiFunction<Read, RESOURCE, Runnable> runnable) throws Throwable {
        Race race = new Race();
        long endTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(30L);
        race.withEndCondition(new BooleanSupplier[]{() -> System.currentTimeMillis() > endTime});
        ArrayList<AutoCloseable> nodeCursors = new ArrayList<AutoCloseable>();
        try (KernelTransaction tx = kernel.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);){
            try (AutoCloseable nodeCursor = (AutoCloseable)resourceSupplier.apply(tx);){
                runnable.apply(tx.dataRead(), nodeCursor).run();
            }
            for (int i = 0; i < nThreads; ++i) {
                AutoCloseable resource = (AutoCloseable)resourceSupplier.apply(tx);
                race.addContestant(runnable.apply(tx.dataRead(), resource));
                nodeCursors.add(resource);
            }
            race.go();
            for (AutoCloseable cursor : nodeCursors) {
                cursor.close();
            }
            tx.commit();
        }
    }
}

