/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.common.EntityType;
import org.neo4j.common.Subject;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobMonitoringParams;

class IndexPopulationJobMonitoringTest {
    private final MultipleIndexPopulator populator = (MultipleIndexPopulator)Mockito.mock(MultipleIndexPopulator.class);
    private final MemoryTracker memoryTracker = (MemoryTracker)Mockito.mock(MemoryTracker.class);
    private final StoreScan<IndexPopulationFailedKernelException> scan = (StoreScan)Mockito.mock(StoreScan.class);

    IndexPopulationJobMonitoringTest() {
    }

    @Test
    void testPopulationOfSingleIndex() {
        Mockito.when((Object)this.populator.createStoreScan((PageCursorTracer)ArgumentMatchers.any())).thenReturn(this.scan);
        Mockito.when((Object)this.populator.hasPopulators()).thenReturn((Object)true);
        Mockito.when((Object)this.scan.getProgress()).thenReturn((Object)PopulationProgress.NONE, (Object[])new PopulationProgress[]{PopulationProgress.single((long)9L, (long)1000L), PopulationProgress.single((long)99L, (long)1000L), PopulationProgress.single((long)999L, (long)1000L), PopulationProgress.DONE});
        IndexPopulationJob job = new IndexPopulationJob(this.populator, IndexingService.NO_MONITOR, false, PageCacheTracer.NULL, this.memoryTracker, "Test DB", new Subject("Test User"), EntityType.NODE);
        this.addIndex(job, "the ONE");
        JobMonitoringParams monitoringParams = job.getMonitoringParams();
        Assertions.assertThat((String)monitoringParams.getSubmitter().describe()).isEqualTo("Test User");
        Assertions.assertThat((String)monitoringParams.getTargetDatabaseName()).isEqualTo("Test DB");
        Assertions.assertThat((String)monitoringParams.getDescription()).isEqualTo("Population of index 'the ONE'");
        this.verifyCurrentState(monitoringParams, "Total progress: 0.0%");
        job.run();
        this.verifyCurrentState(monitoringParams, "Total progress: 0.0%");
        this.verifyCurrentState(monitoringParams, "Total progress: 0.9%");
        this.verifyCurrentState(monitoringParams, "Total progress: 9.9%");
        this.verifyCurrentState(monitoringParams, "Total progress: 99.9%");
        this.verifyCurrentState(monitoringParams, "Total progress: 100.0%");
    }

    @Test
    void testPopulationOfMultipleIndexes() {
        Mockito.when((Object)this.populator.createStoreScan((PageCursorTracer)ArgumentMatchers.any())).thenReturn(this.scan);
        Mockito.when((Object)this.populator.hasPopulators()).thenReturn((Object)true);
        Mockito.when((Object)this.scan.getProgress()).thenReturn((Object)PopulationProgress.NONE, (Object[])new PopulationProgress[]{PopulationProgress.single((long)9L, (long)1000L), PopulationProgress.single((long)99L, (long)1000L), PopulationProgress.single((long)999L, (long)1000L), PopulationProgress.DONE});
        IndexPopulationJob job = new IndexPopulationJob(this.populator, IndexingService.NO_MONITOR, false, PageCacheTracer.NULL, this.memoryTracker, "Another Test DB", new Subject("Another Test User"), EntityType.NODE);
        this.addIndex(job, "index 1");
        this.addIndex(job, "index 2");
        this.addIndex(job, "index 3");
        JobMonitoringParams monitoringParams = job.getMonitoringParams();
        Assertions.assertThat((String)monitoringParams.getSubmitter().describe()).isEqualTo("Another Test User");
        Assertions.assertThat((String)monitoringParams.getTargetDatabaseName()).isEqualTo("Another Test DB");
        Assertions.assertThat((String)monitoringParams.getDescription()).isEqualTo("Population of 3 'NODE' indexes");
        this.verifyCurrentState(monitoringParams, "Population of indexes 'index 1','index 2','index 3'; Total progress: 0.0%");
        job.run();
        this.verifyCurrentState(monitoringParams, "Population of indexes 'index 1','index 2','index 3'; Total progress: 0.0%");
        this.verifyCurrentState(monitoringParams, "Population of indexes 'index 1','index 2','index 3'; Total progress: 0.9%");
        this.verifyCurrentState(monitoringParams, "Population of indexes 'index 1','index 2','index 3'; Total progress: 9.9%");
        this.verifyCurrentState(monitoringParams, "Population of indexes 'index 1','index 2','index 3'; Total progress: 99.9%");
        this.verifyCurrentState(monitoringParams, "Population of indexes 'index 1','index 2','index 3'; Total progress: 100.0%");
    }

    private void addIndex(IndexPopulationJob job, String indexName) {
        IndexPrototype idxPrototype = IndexPrototype.forSchema((SchemaDescriptor)((SchemaDescriptor)Mockito.mock(SchemaDescriptor.class))).withName(indexName);
        IndexDescriptor indexDescriptor = idxPrototype.materialise(99L);
        job.addPopulator(null, indexDescriptor, null, null, null);
    }

    private void verifyCurrentState(JobMonitoringParams monitoringParams, String expectedCurrentStateDescription) {
        Assertions.assertThat((String)monitoringParams.getCurrentStateDescription()).isEqualTo(expectedCurrentStateDescription);
    }
}

