/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestBase;
import org.neo4j.kernel.impl.newapi.ReadTestSupport;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.ValueType;
import org.neo4j.values.storable.Values;

@ExtendWith(value={RandomExtension.class})
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class IndexProvidedValuesNativeBTree10Test
extends KernelAPIReadTestBase<ReadTestSupport> {
    private static final int N_NODES = 10000;
    @Inject
    private RandomRule randomRule;
    private List<Value> singlePropValues = new ArrayList<Value>();
    private List<ValueTuple> doublePropValues = new ArrayList<ValueTuple>();
    private IndexDescriptor indexNodeProp;
    private IndexDescriptor indexNodePropPrip;

    @Override
    public ReadTestSupport newTestSupport() {
        ReadTestSupport readTestSupport = new ReadTestSupport();
        readTestSupport.addSetting(GraphDatabaseSettings.default_schema_provider, GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10.providerName());
        return readTestSupport;
    }

    @Override
    public void createTestGraph(GraphDatabaseService graphDb) {
        try (Transaction tx = graphDb.beginTx();){
            this.indexNodeProp = this.unwrap(tx.schema().indexFor(Label.label((String)"Node")).on("prop").create());
            this.indexNodePropPrip = this.unwrap(tx.schema().indexFor(Label.label((String)"Node")).on("prop").on("prip").create());
            tx.commit();
        }
        tx = graphDb.beginTx();
        try {
            tx.schema().awaitIndexesOnline(5L, TimeUnit.MINUTES);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = graphDb.beginTx();
        try {
            RandomValues randomValues = this.randomRule.randomValues();
            ValueType[] allExceptNonSortable = RandomValues.excluding((ValueType[])new ValueType[]{ValueType.STRING, ValueType.STRING_ARRAY});
            for (int i = 0; i < 10000; ++i) {
                Node node = tx.createNode(new Label[]{Label.label((String)"Node")});
                Value propValue = randomValues.nextValueOfTypes(allExceptNonSortable);
                node.setProperty("prop", propValue.asObject());
                Value pripValue = randomValues.nextValueOfTypes(allExceptNonSortable);
                node.setProperty("prip", pripValue.asObject());
                this.singlePropValues.add(propValue);
                this.doublePropValues.add(ValueTuple.of((Value[])new Value[]{propValue, pripValue}));
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.singlePropValues.sort((Comparator<Value>)Values.COMPARATOR);
        this.doublePropValues.sort(ValueTuple.COMPARATOR);
    }

    private IndexDescriptor unwrap(IndexDefinition indexDefinition) {
        return ((IndexDefinitionImpl)indexDefinition).getIndexReference();
    }

    @Test
    void shouldGetAllSinglePropertyValues() throws Exception {
        IndexReadSession index = this.read.indexReadSession(this.indexNodeProp);
        try (NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor(PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            this.read.nodeIndexScan(index, node, IndexQueryConstraints.unorderedValues());
            ArrayList<Value> values = new ArrayList<Value>();
            while (node.next()) {
                values.add(node.propertyValue(0));
            }
            values.sort((Comparator<Value>)Values.COMPARATOR);
            for (int i = 0; i < this.singlePropValues.size(); ++i) {
                Assertions.assertEquals((Object)this.singlePropValues.get(i), values.get(i));
            }
        }
    }

    @Test
    void shouldGetAllDoublePropertyValues() throws Exception {
        IndexReadSession index = this.read.indexReadSession(this.indexNodePropPrip);
        try (NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor(PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            this.read.nodeIndexScan(index, node, IndexQueryConstraints.unorderedValues());
            ArrayList<ValueTuple> values = new ArrayList<ValueTuple>();
            while (node.next()) {
                values.add(ValueTuple.of((Value[])new Value[]{node.propertyValue(0), node.propertyValue(1)}));
            }
            values.sort(ValueTuple.COMPARATOR);
            for (int i = 0; i < this.doublePropValues.size(); ++i) {
                Assertions.assertEquals((Object)this.doublePropValues.get(i), values.get(i));
            }
        }
    }
}

