/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.junit.jupiter.api.Test;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipTypeIndexCursor;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.IndexReadAsserts;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestSupport;
import org.neo4j.kernel.impl.newapi.TestKernelReadTracer;

abstract class RelationshipTypeIndexCursorTestBase<G extends KernelAPIWriteTestSupport>
extends KernelAPIWriteTestBase<G> {
    private int typeOne = 1;
    private int typeTwo = 2;
    private int typeThree = 3;

    RelationshipTypeIndexCursorTestBase() {
    }

    @Test
    void shouldFindRelationshipsByType() throws KernelException {
        long toDelete;
        try (KernelTransaction tx = this.beginTransaction();){
            RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), this.typeOne);
            RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), this.typeTwo);
            RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), this.typeThree);
            toDelete = RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), this.typeOne);
            RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), this.typeTwo);
            RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), this.typeThree);
            RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), this.typeThree);
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            tx.dataWrite().relationshipDelete(toDelete);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.beginTransaction();
        try {
            Read read = tx.dataRead();
            try (RelationshipTypeIndexCursor cursor = tx.cursors().allocateRelationshipTypeIndexCursor();){
                LongHashSet uniqueIds = new LongHashSet();
                read.relationshipTypeScan(this.typeOne, cursor);
                IndexReadAsserts.assertRelationshipCount((RelationshipIndexCursor)cursor, 1, (MutableLongSet)uniqueIds);
                read.relationshipTypeScan(this.typeTwo, cursor);
                IndexReadAsserts.assertRelationshipCount((RelationshipIndexCursor)cursor, 2, (MutableLongSet)uniqueIds);
                read.relationshipTypeScan(this.typeThree, cursor);
                IndexReadAsserts.assertRelationshipCount((RelationshipIndexCursor)cursor, 3, (MutableLongSet)uniqueIds);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldFindRelationshipsByTypeInTx() throws KernelException {
        long deletedInTx;
        long inStore;
        try (KernelTransaction tx = this.beginTransaction();){
            inStore = RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), this.typeOne);
            RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), this.typeTwo);
            deletedInTx = RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), this.typeOne);
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            tx.dataWrite().relationshipDelete(deletedInTx);
            long createdInTx = RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), this.typeOne);
            RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), this.typeTwo);
            Read read = tx.dataRead();
            try (RelationshipTypeIndexCursor cursor = tx.cursors().allocateRelationshipTypeIndexCursor();){
                LongHashSet uniqueIds = new LongHashSet();
                read.relationshipTypeScan(this.typeOne, cursor);
                IndexReadAsserts.assertRelationships((RelationshipIndexCursor)cursor, (MutableLongSet)uniqueIds, inStore, createdInTx);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldTraceRelationshipTypeScanEvents() throws KernelException {
        long third;
        long second;
        long first;
        try (KernelTransaction tx = this.beginTransaction();){
            first = RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), this.typeOne);
            second = RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), this.typeTwo);
            third = RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), this.typeTwo);
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            Read read = tx.dataRead();
            try (RelationshipTypeIndexCursor cursor = tx.cursors().allocateRelationshipTypeIndexCursor();){
                TestKernelReadTracer tracer = new TestKernelReadTracer();
                cursor.setTracer((KernelReadTracer)tracer);
                LongHashSet uniqueIds = new LongHashSet();
                read.relationshipTypeScan(this.typeOne, cursor);
                RelationshipTypeIndexCursorTestBase.exhaustCursor(cursor);
                tracer.assertEvents(new TestKernelReadTracer.TraceEvent(TestKernelReadTracer.TraceEventKind.RelationshipTypeScan, this.typeOne), new TestKernelReadTracer.TraceEvent(TestKernelReadTracer.TraceEventKind.Relationship, first));
                read.relationshipTypeScan(this.typeTwo, cursor);
                RelationshipTypeIndexCursorTestBase.exhaustCursor(cursor);
                tracer.assertEvents(new TestKernelReadTracer.TraceEvent(TestKernelReadTracer.TraceEventKind.RelationshipTypeScan, this.typeTwo), new TestKernelReadTracer.TraceEvent(TestKernelReadTracer.TraceEventKind.Relationship, second), new TestKernelReadTracer.TraceEvent(TestKernelReadTracer.TraceEventKind.Relationship, third));
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private static void exhaustCursor(RelationshipTypeIndexCursor cursor) {
        while (cursor.next()) {
        }
    }

    private static long createRelationship(Write write, int type) throws KernelException {
        long sourceNode = write.nodeCreate();
        long targetNode = write.nodeCreate();
        return write.relationshipCreate(sourceNode, type, targetNode);
    }
}

