/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tracers;

import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventListener;
import org.neo4j.graphdb.event.TransactionEventListenerAdapter;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class TransactionTracingIT {
    private static final int ENTITY_COUNT = 1000;
    @Inject
    private GraphDatabaseAPI database;
    @Inject
    private DatabaseManagementService managementService;

    TransactionTracingIT() {
    }

    @Test
    void tracePageCacheAccessOnAllNodesAccess() {
        try (Transaction transaction = this.database.beginTx();){
            for (int i = 0; i < 1000; ++i) {
                transaction.createNode();
            }
            transaction.commit();
        }
        transaction = (InternalTransaction)this.database.beginTx();
        try {
            PageCursorTracer cursorTracer = transaction.kernelTransaction().pageCursorTracer();
            this.assertZeroCursor(cursorTracer);
            org.junit.jupiter.api.Assertions.assertEquals((long)1000L, (long)Iterables.count((Iterable)transaction.getAllNodes()));
            Assertions.assertThat((long)cursorTracer.pins()).isEqualTo(2L);
            Assertions.assertThat((long)cursorTracer.unpins()).isEqualTo(1L);
            Assertions.assertThat((long)cursorTracer.hits()).isEqualTo(2L);
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void tracePageCacheAccessOnNodeCreation() {
        try (InternalTransaction transaction = (InternalTransaction)this.database.beginTx();){
            PageCursorTracer cursorTracer = transaction.kernelTransaction().pageCursorTracer();
            CommitCursorChecker commitCursorChecker = new CommitCursorChecker(cursorTracer);
            this.managementService.registerTransactionEventListener(this.database.databaseName(), (TransactionEventListener)commitCursorChecker);
            for (int i = 0; i < 1000; ++i) {
                transaction.createNode();
            }
            this.assertZeroCursor(cursorTracer);
            transaction.commit();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)commitCursorChecker.isInvoked());
        }
    }

    @Test
    void tracePageCacheAccessOnAllRelationshipsAccess() {
        try (Transaction transaction = this.database.beginTx();){
            for (int i = 0; i < 1000; ++i) {
                Node source = transaction.createNode();
                source.createRelationshipTo(transaction.createNode(), RelationshipType.withName((String)"connection"));
            }
            transaction.commit();
        }
        transaction = (InternalTransaction)this.database.beginTx();
        try {
            PageCursorTracer cursorTracer = transaction.kernelTransaction().pageCursorTracer();
            this.assertZeroCursor(cursorTracer);
            org.junit.jupiter.api.Assertions.assertEquals((long)1000L, (long)Iterables.count((Iterable)transaction.getAllRelationships()));
            Assertions.assertThat((long)cursorTracer.pins()).isEqualTo(5L);
            Assertions.assertThat((long)cursorTracer.unpins()).isEqualTo(5L);
            Assertions.assertThat((long)cursorTracer.hits()).isEqualTo(5L);
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void tracePageCacheAccessOnFindNodes() {
        Label marker = Label.label((String)"marker");
        RelationshipType type = RelationshipType.withName((String)"connection");
        try (Transaction transaction = this.database.beginTx();){
            for (int i = 0; i < 1000; ++i) {
                Node source = transaction.createNode(new Label[]{marker});
                source.createRelationshipTo(transaction.createNode(), type);
            }
            transaction.commit();
        }
        transaction = (InternalTransaction)this.database.beginTx();
        try {
            PageCursorTracer cursorTracer = transaction.kernelTransaction().pageCursorTracer();
            this.assertZeroCursor(cursorTracer);
            org.junit.jupiter.api.Assertions.assertEquals((long)1000L, (long)Iterators.count((Iterator)transaction.findNodes(marker)));
            Assertions.assertThat((long)cursorTracer.pins()).isEqualTo(2L);
            Assertions.assertThat((long)cursorTracer.unpins()).isEqualTo(2L);
            Assertions.assertThat((long)cursorTracer.hits()).isEqualTo(2L);
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void tracePageCacheAccessOnDetachDelete() throws KernelException {
        long sourceId;
        RelationshipType type = RelationshipType.withName((String)"connection");
        try (Transaction transaction = this.database.beginTx();){
            Node source = transaction.createNode();
            for (int i = 0; i < 10; ++i) {
                source.createRelationshipTo(transaction.createNode(), type);
            }
            sourceId = source.getId();
            transaction.commit();
        }
        transaction = (InternalTransaction)this.database.beginTx();
        try {
            PageCursorTracer cursorTracer = transaction.kernelTransaction().pageCursorTracer();
            this.assertZeroCursor(cursorTracer);
            transaction.kernelTransaction().dataWrite().nodeDetachDelete(sourceId);
            Assertions.assertThat((long)cursorTracer.pins()).isEqualTo(15L);
            Assertions.assertThat((long)cursorTracer.unpins()).isEqualTo(12L);
            Assertions.assertThat((long)cursorTracer.hits()).isEqualTo(15L);
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    private void assertZeroCursor(PageCursorTracer cursorTracer) {
        Assertions.assertThat((long)cursorTracer.pins()).isZero();
        Assertions.assertThat((long)cursorTracer.unpins()).isZero();
        Assertions.assertThat((long)cursorTracer.hits()).isZero();
        Assertions.assertThat((long)cursorTracer.faults()).isZero();
    }

    private static class CommitCursorChecker
    extends TransactionEventListenerAdapter<Object> {
        private final PageCursorTracer cursorTracer;
        private volatile boolean invoked;

        CommitCursorChecker(PageCursorTracer cursorTracer) {
            this.cursorTracer = cursorTracer;
        }

        public boolean isInvoked() {
            return this.invoked;
        }

        public void afterCommit(TransactionData data, Object state, GraphDatabaseService databaseService) {
            Assertions.assertThat((long)this.cursorTracer.pins()).isEqualTo(1003L);
            Assertions.assertThat((long)this.cursorTracer.unpins()).isEqualTo(1003L);
            Assertions.assertThat((long)this.cursorTracer.hits()).isEqualTo(1001L);
            Assertions.assertThat((long)this.cursorTracer.faults()).isEqualTo(2L);
            this.invoked = true;
        }
    }
}

