/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.nio.file.Path;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.configuration.Config;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProviderCompatibilityTestSuite;
import org.neo4j.kernel.api.index.MinimalIndexAccessor;
import org.neo4j.kernel.api.schema.SchemaTestUtil;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;

@Ignore(value="Not a test. This is a compatibility suite that provides test cases for verifying IndexProvider implementations. Each index provider that is to be tested by this suite must create their own test class extending IndexProviderCompatibilityTestSuite. The @Ignore annotation doesn't prevent these tests to run, it rather removes some annoying errors or warnings in some IDEs about test classes needing a public zero-arg constructor.")
public class MinimalIndexAccessorCompatibility
extends IndexProviderCompatibilityTestSuite.Compatibility {
    private MinimalIndexAccessor minimalIndexAccessor;

    public MinimalIndexAccessorCompatibility(IndexProviderCompatibilityTestSuite testSuite) {
        super(testSuite, IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)1, (int[])new int[]{2})));
    }

    @Before
    public void before() {
        IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.defaults());
        IndexPopulator populator = this.indexProvider.getPopulator(this.descriptor, indexSamplingConfig, ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE, SchemaTestUtil.SIMPLE_NAME_LOOKUP);
        populator.create();
        populator.close(true, PageCursorTracer.NULL);
        this.minimalIndexAccessor = this.indexProvider.getMinimalIndexAccessor(this.descriptor);
    }

    @Test
    public void indexDropperMustDropIndex() {
        Path rootDirectory = this.indexProvider.directoryStructure().rootDirectory();
        Path[] files = this.fs.listFiles(rootDirectory);
        Assert.assertEquals((long)1L, (long)files.length);
        this.minimalIndexAccessor.drop();
        files = this.fs.listFiles(rootDirectory);
        Assert.assertEquals((long)0L, (long)files.length);
    }

    @Test
    public void indexDropperMustProvideIndexConfiguration() {
        Map dropperConfiguration = this.minimalIndexAccessor.indexConfig();
        Assert.assertEquals((Object)this.descriptor.getIndexConfig().asMap(), (Object)dropperConfiguration);
    }
}

