/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.impl.coreapi.schema.SchemaImpl;

class SchemaImplMockTest {
    private static final Exception cause = new Exception("Kilroy made it");

    SchemaImplMockTest() {
    }

    @Test
    void includeCauseOfFailure() throws IndexNotFoundKernelException {
        IndexDefinitionImpl indexDefinition = SchemaImplMockTest.mockIndexDefinition();
        Mockito.when((Object)indexDefinition.toString()).thenReturn((Object)"IndexDefinition( of-some-sort )");
        KernelTransaction kernelTransaction = SchemaImplMockTest.mockKernelTransaction();
        SchemaImpl schema = new SchemaImpl(kernelTransaction);
        IllegalStateException e = (IllegalStateException)org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> schema.awaitIndexOnline((IndexDefinition)indexDefinition, 1L, TimeUnit.MINUTES));
        Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{Exceptions.stringify((Throwable)cause)});
    }

    private static IndexDefinitionImpl mockIndexDefinition() {
        IndexDefinitionImpl indexDefinition = (IndexDefinitionImpl)Mockito.mock(IndexDefinitionImpl.class);
        Mockito.when((Object)indexDefinition.getIndexReference()).thenReturn((Object)IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)1, (int[])new int[]{1})).withName("index").materialise(13L));
        return indexDefinition;
    }

    private static KernelTransaction mockKernelTransaction() throws IndexNotFoundKernelException {
        SchemaRead schemaRead = (SchemaRead)Mockito.mock(SchemaRead.class);
        Mockito.when((Object)schemaRead.indexGetState((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class))).thenReturn((Object)InternalIndexState.FAILED);
        Mockito.when((Object)schemaRead.indexGetFailure((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class))).thenReturn((Object)Exceptions.stringify((Throwable)cause));
        KernelTransaction kt = (KernelTransaction)Mockito.mock(KernelTransaction.class);
        Mockito.when((Object)kt.tokenRead()).thenReturn((Object)((TokenRead)Mockito.mock(TokenRead.class)));
        Mockito.when((Object)kt.schemaRead()).thenReturn((Object)schemaRead);
        Mockito.when((Object)kt.isTerminated()).thenReturn((Object)false);
        return kt;
    }
}

