/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestSupport;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.RelationshipSelection;
import org.neo4j.token.TokenHolders;

public abstract class DeepRelationshipTraversalCursorTestBase<G extends KernelAPIReadTestSupport>
extends KernelAPIReadTestBase<G> {
    private static long three_root;
    private static int expected_total;
    private static int expected_unique;
    private RelationshipType PARENT = RelationshipType.withName((String)"PARENT");
    private int parentRelationshipTypeId;

    @Override
    public void createTestGraph(GraphDatabaseService graphDb) {
        try (Transaction tx = graphDb.beginTx();){
            Node inter;
            int i;
            Node root = tx.createNode();
            three_root = root.getId();
            Node[] leafs = new Node[32];
            for (int i2 = 0; i2 < leafs.length; ++i2) {
                leafs[i2] = tx.createNode();
            }
            int offset = 0;
            int duplicate = 12;
            Node interdup = tx.createNode();
            interdup.createRelationshipTo(root, this.PARENT);
            offset = this.relate(duplicate, leafs, offset, interdup);
            for (i = 0; i < 5; ++i) {
                inter = tx.createNode();
                inter.createRelationshipTo(root, this.PARENT);
                offset = this.relate(3 + i, leafs, offset, inter);
            }
            interdup.createRelationshipTo(root, this.PARENT);
            for (i = 0; i < 4; ++i) {
                inter = tx.createNode();
                inter.createRelationshipTo(root, this.PARENT);
                offset = this.relate(2 + i, leafs, offset, inter);
            }
            Node inter2 = tx.createNode();
            inter2.createRelationshipTo(root, this.PARENT);
            offset = this.relate(1, leafs, offset, inter2);
            expected_total = offset + duplicate;
            expected_unique = leafs.length;
            this.parentRelationshipTypeId = ((TokenHolders)((GraphDatabaseAPI)graphDb).getDependencyResolver().resolveDependency(TokenHolders.class)).relationshipTypeTokens().getIdByName(this.PARENT.name());
            tx.commit();
        }
    }

    private int relate(int count, Node[] selection, int offset, Node parent) {
        for (int i = 0; i < count; ++i) {
            selection[offset++ % selection.length].createRelationshipTo(parent, this.PARENT);
        }
        return offset;
    }

    @Test
    void shouldTraverseTreeOfDepthThree() {
        try (NodeCursor node = this.cursors.allocateNodeCursor(PageCursorTracer.NULL);
             RelationshipTraversalCursor relationship1 = this.cursors.allocateRelationshipTraversalCursor(PageCursorTracer.NULL);
             RelationshipTraversalCursor relationship2 = this.cursors.allocateRelationshipTraversalCursor(PageCursorTracer.NULL);){
            LongHashSet leafs = new LongHashSet();
            long total = 0L;
            this.read.singleNode(three_root, node);
            Assertions.assertTrue((boolean)node.next(), (String)"access root node");
            node.relationships(relationship1, RelationshipSelection.selection((int)this.parentRelationshipTypeId, (Direction)Direction.INCOMING));
            while (relationship1.next()) {
                relationship1.otherNode(node);
                Assertions.assertTrue((boolean)node.next(), (String)"child level 1");
                node.relationships(relationship2, RelationshipSelection.selection((int)this.parentRelationshipTypeId, (Direction)Direction.INCOMING));
                while (relationship2.next()) {
                    leafs.add(relationship2.otherNodeReference());
                    ++total;
                }
            }
            Assertions.assertEquals((long)expected_total, (long)total, (String)"total number of leaf nodes");
            Assertions.assertEquals((int)expected_unique, (int)leafs.size(), (String)"number of distinct leaf nodes");
        }
    }
}

