/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BooleanSupplier;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.Race;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;

@DbmsExtension(configurationCallback="configure")
class NeoStoresIT {
    @Inject
    private GraphDatabaseAPI db;
    private static final RelationshipType FRIEND = RelationshipType.withName((String)"FRIEND");
    private static final String LONG_STRING_VALUE = RandomStringUtils.randomAscii((int)2048);

    NeoStoresIT() {
    }

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseSettings.dense_node_threshold, (Object)1);
    }

    @Test
    void tracePageCacheAccessOnHighIdScan() {
        RecordStorageEngine storageEngine = (RecordStorageEngine)this.db.getDependencyResolver().resolveDependency(RecordStorageEngine.class);
        NeoStores neoStores = storageEngine.testAccessNeoStores();
        PropertyStore propertyStore = neoStores.getPropertyStore();
        for (int i = 0; i < 1000; ++i) {
            try (Transaction transaction = this.db.beginTx();){
                Node node = transaction.createNode();
                node.setProperty("a", (Object)RandomStringUtils.randomAscii((int)1024));
                transaction.commit();
                continue;
            }
        }
        PageCursorTracer cursorTracer = new DefaultPageCacheTracer().createPageCursorTracer("tracePageCacheAccessOnHighIdScan");
        propertyStore.scanForHighId(cursorTracer);
        Assertions.assertEquals((long)6L, (long)cursorTracer.hits());
        Assertions.assertEquals((long)6L, (long)cursorTracer.pins());
        Assertions.assertEquals((long)6L, (long)cursorTracer.unpins());
    }

    @Test
    void tracePageCacheAccessOnGetRawRecordData() throws IOException {
        RecordStorageEngine storageEngine = (RecordStorageEngine)this.db.getDependencyResolver().resolveDependency(RecordStorageEngine.class);
        NeoStores neoStores = storageEngine.testAccessNeoStores();
        PropertyStore propertyStore = neoStores.getPropertyStore();
        try (Transaction transaction = this.db.beginTx();){
            Node node = transaction.createNode();
            node.setProperty("a", (Object)"b");
            transaction.commit();
        }
        PageCursorTracer cursorTracer = new DefaultPageCacheTracer().createPageCursorTracer("tracePageCacheAccessOnGetRawRecordData");
        propertyStore.getRawRecordData(1L, cursorTracer);
        Assertions.assertEquals((long)1L, (long)cursorTracer.hits());
        Assertions.assertEquals((long)1L, (long)cursorTracer.pins());
        Assertions.assertEquals((long)1L, (long)cursorTracer.unpins());
    }

    @Test
    void tracePageCacheAccessOnInUseCheck() {
        RecordStorageEngine storageEngine = (RecordStorageEngine)this.db.getDependencyResolver().resolveDependency(RecordStorageEngine.class);
        NeoStores neoStores = storageEngine.testAccessNeoStores();
        PropertyStore propertyStore = neoStores.getPropertyStore();
        try (Transaction transaction = this.db.beginTx();){
            Node node = transaction.createNode();
            node.setProperty("a", (Object)"b");
            transaction.commit();
        }
        PageCursorTracer cursorTracer = new DefaultPageCacheTracer().createPageCursorTracer("tracePageCacheAccessOnInUseCheck");
        propertyStore.isInUse(1L, cursorTracer);
        Assertions.assertEquals((long)1L, (long)cursorTracer.hits());
        Assertions.assertEquals((long)1L, (long)cursorTracer.pins());
        Assertions.assertEquals((long)1L, (long)cursorTracer.unpins());
    }

    @Test
    void tracePageCacheAccessOnGetRecord() {
        long nodeId;
        RecordStorageEngine storageEngine = (RecordStorageEngine)this.db.getDependencyResolver().resolveDependency(RecordStorageEngine.class);
        NeoStores neoStores = storageEngine.testAccessNeoStores();
        NodeStore nodeStore = neoStores.getNodeStore();
        try (Transaction transaction = this.db.beginTx();){
            Node node = transaction.createNode();
            node.setProperty("a", (Object)"b");
            nodeId = node.getId();
            transaction.commit();
        }
        PageCursorTracer cursorTracer = new DefaultPageCacheTracer().createPageCursorTracer("tracePageCacheAccessOnGetRecord");
        nodeStore.getRecord(nodeId, (AbstractBaseRecord)new NodeRecord(nodeId), RecordLoad.NORMAL, cursorTracer);
        Assertions.assertEquals((long)1L, (long)cursorTracer.hits());
        Assertions.assertEquals((long)1L, (long)cursorTracer.pins());
        Assertions.assertEquals((long)1L, (long)cursorTracer.unpins());
    }

    @Test
    void tracePageCacheAccessOnUpdateRecord() {
        long nodeId;
        RecordStorageEngine storageEngine = (RecordStorageEngine)this.db.getDependencyResolver().resolveDependency(RecordStorageEngine.class);
        NeoStores neoStores = storageEngine.testAccessNeoStores();
        NodeStore nodeStore = neoStores.getNodeStore();
        try (Transaction transaction = this.db.beginTx();){
            Node node = transaction.createNode();
            node.setProperty("a", (Object)"b");
            nodeId = node.getId();
            transaction.commit();
        }
        PageCursorTracer cursorTracer = new DefaultPageCacheTracer().createPageCursorTracer("tracePageCacheAccessOnUpdateRecord");
        nodeStore.updateRecord((AbstractBaseRecord)new NodeRecord(nodeId), cursorTracer);
        Assertions.assertEquals((long)5L, (long)cursorTracer.hits());
        Assertions.assertEquals((long)6L, (long)cursorTracer.pins());
        Assertions.assertEquals((long)6L, (long)cursorTracer.unpins());
    }

    @Test
    void tracePageCacheAccessOnTokenReads() {
        RecordStorageEngine storageEngine = (RecordStorageEngine)this.db.getDependencyResolver().resolveDependency(RecordStorageEngine.class);
        NeoStores neoStores = storageEngine.testAccessNeoStores();
        PropertyKeyTokenStore propertyKeys = neoStores.getPropertyKeyTokenStore();
        try (Transaction transaction = this.db.beginTx();){
            Node node = transaction.createNode();
            node.setProperty("a", (Object)"b");
            transaction.commit();
        }
        PageCursorTracer cursorTracer = new DefaultPageCacheTracer().createPageCursorTracer("tracePageCacheAccessOnTokenReads");
        propertyKeys.getAllReadableTokens(cursorTracer);
        Assertions.assertEquals((long)2L, (long)cursorTracer.hits());
        Assertions.assertEquals((long)2L, (long)cursorTracer.pins());
        Assertions.assertEquals((long)2L, (long)cursorTracer.unpins());
    }

    @Test
    void shouldWriteOutTheDynamicChainBeforeUpdatingThePropertyRecord() throws Throwable {
        Race race = new Race();
        long[] latestNodeId = new long[1];
        AtomicLong writes = new AtomicLong();
        AtomicLong reads = new AtomicLong();
        long endTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(2L);
        race.withEndCondition(new BooleanSupplier[]{() -> writes.get() > 100L && reads.get() > 10000L || System.currentTimeMillis() > endTime});
        race.addContestant(() -> {
            try (Transaction tx = this.db.beginTx();){
                Node node = tx.createNode();
                latestNodeId[0] = node.getId();
                node.setProperty("largeProperty", (Object)LONG_STRING_VALUE);
                tx.commit();
            }
            writes.incrementAndGet();
        });
        race.addContestant(() -> {
            try (Transaction tx = this.db.beginTx();){
                Node node = tx.getNodeById(latestNodeId[0]);
                for (String propertyKey : node.getPropertyKeys()) {
                    node.getProperty(propertyKey);
                }
                tx.commit();
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            reads.incrementAndGet();
        });
        race.go();
    }

    @Test
    void shouldWriteOutThePropertyRecordBeforeReferencingItFromANodeRecord() throws Throwable {
        Race race = new Race();
        long[] latestNodeId = new long[1];
        AtomicLong writes = new AtomicLong();
        AtomicLong reads = new AtomicLong();
        long endTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(2L);
        race.withEndCondition(new BooleanSupplier[]{() -> writes.get() > 100L && reads.get() > 10000L || System.currentTimeMillis() > endTime});
        race.addContestant(() -> {
            try (Transaction tx = this.db.beginTx();){
                Node node = tx.createNode();
                latestNodeId[0] = node.getId();
                node.setProperty("largeProperty", (Object)LONG_STRING_VALUE);
                tx.commit();
            }
            writes.incrementAndGet();
        });
        race.addContestant(() -> {
            block9: {
                try (Transaction tx = this.db.beginTx();){
                    Node node = tx.getNodeById(latestNodeId[0]);
                    for (String propertyKey : node.getPropertyKeys()) {
                        node.getProperty(propertyKey);
                    }
                    tx.commit();
                }
                catch (NotFoundException e) {
                    if (ExceptionUtils.indexOfThrowable((Throwable)e, InvalidRecordException.class) == -1) break block9;
                    throw e;
                }
            }
            reads.incrementAndGet();
        });
        race.go();
    }

    @Test
    void shouldWriteOutThePropertyRecordBeforeReferencingItFromARelationshipRecord() throws Throwable {
        long node2Id;
        long node1Id;
        try (Transaction tx = this.db.beginTx();){
            Node node1 = tx.createNode();
            node1Id = node1.getId();
            Node node2 = tx.createNode();
            node2Id = node2.getId();
            tx.commit();
        }
        Race race = new Race();
        long[] latestRelationshipId = new long[1];
        AtomicLong writes = new AtomicLong();
        AtomicLong reads = new AtomicLong();
        long endTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(2L);
        race.withEndCondition(new BooleanSupplier[]{() -> writes.get() > 100L && reads.get() > 10000L || System.currentTimeMillis() > endTime});
        race.addContestant(() -> {
            try (Transaction tx = this.db.beginTx();){
                Node node1 = tx.getNodeById(node1Id);
                Node node2 = tx.getNodeById(node2Id);
                Relationship rel = node1.createRelationshipTo(node2, FRIEND);
                latestRelationshipId[0] = rel.getId();
                rel.setProperty("largeProperty", (Object)LONG_STRING_VALUE);
                tx.commit();
            }
            writes.incrementAndGet();
        });
        race.addContestant(() -> {
            block9: {
                try (Transaction tx = this.db.beginTx();){
                    Relationship rel = tx.getRelationshipById(latestRelationshipId[0]);
                    for (String propertyKey : rel.getPropertyKeys()) {
                        rel.getProperty(propertyKey);
                    }
                    tx.commit();
                }
                catch (NotFoundException e) {
                    if (ExceptionUtils.indexOfThrowable((Throwable)e, InvalidRecordException.class) == -1) break block9;
                    throw e;
                }
            }
            reads.incrementAndGet();
        });
        race.go();
    }
}

