/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import org.neo4j.internal.recordstorage.RecordAccess;
import org.neo4j.kernel.impl.transaction.state.RelationshipCreatorTest;

public class TrackingRecordProxy<RECORD, ADDITIONAL>
implements RecordAccess.RecordProxy<RECORD, ADDITIONAL> {
    private final RecordAccess.RecordProxy<RECORD, ADDITIONAL> delegate;
    private final RelationshipCreatorTest.Tracker tracker;
    private final boolean created;
    private boolean changed;

    public TrackingRecordProxy(RecordAccess.RecordProxy<RECORD, ADDITIONAL> delegate, boolean created, RelationshipCreatorTest.Tracker tracker) {
        this.delegate = delegate;
        this.created = created;
        this.tracker = tracker;
        this.changed = created;
    }

    public long getKey() {
        return this.delegate.getKey();
    }

    public RECORD forChangingLinkage() {
        this.trackChange();
        return (RECORD)this.delegate.forChangingLinkage();
    }

    private void trackChange() {
        if (!this.created && !this.changed) {
            this.tracker.changingRelationship(this.getKey());
            this.changed = true;
        }
    }

    public RECORD forChangingData() {
        this.trackChange();
        return (RECORD)this.delegate.forChangingData();
    }

    public RECORD forReadingLinkage() {
        return (RECORD)this.delegate.forReadingLinkage();
    }

    public RECORD forReadingData() {
        return (RECORD)this.delegate.forReadingData();
    }

    public ADDITIONAL getAdditionalData() {
        return (ADDITIONAL)this.delegate.getAdditionalData();
    }

    public RECORD getBefore() {
        return (RECORD)this.delegate.getBefore();
    }

    public boolean isChanged() {
        return this.changed;
    }

    public boolean isCreated() {
        return this.created;
    }
}

