/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.internal.LogService;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
class GraphDatabaseInternalLogIT {
    private static final String INTERNAL_LOG_FILE = "debug.log";
    @Inject
    private TestDirectory testDir;

    GraphDatabaseInternalLogIT() {
    }

    @Test
    void shouldWriteToInternalDiagnosticsLog() throws Exception {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.testDir.homePath()).setConfig(GraphDatabaseSettings.logs_directory, (Object)this.testDir.directory("logs").toAbsolutePath()).build();
        NamedDatabaseId databaseId = ((GraphDatabaseAPI)managementService.database("neo4j")).databaseId();
        managementService.shutdown();
        Path internalLog = this.testDir.directory("logs").resolve(INTERNAL_LOG_FILE);
        Assertions.assertThat((boolean)Files.isRegularFile(internalLog, new LinkOption[0])).isEqualTo(true);
        Assertions.assertThat((long)Files.size(internalLog)).isGreaterThan(0L);
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)GraphDatabaseInternalLogIT.countOccurrences(internalLog, databaseId + " is ready."));
        org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)GraphDatabaseInternalLogIT.countOccurrences(internalLog, databaseId + " is unavailable."));
    }

    @Test
    void shouldNotWriteDebugToInternalDiagnosticsLogByDefault() throws Exception {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.testDir.homePath()).setConfig(GraphDatabaseSettings.logs_directory, (Object)this.testDir.directory("logs").toAbsolutePath()).build();
        GraphDatabaseService db = managementService.database("neo4j");
        LogService logService = (LogService)((GraphDatabaseAPI)db).getDependencyResolver().resolveDependency(LogService.class);
        logService.getInternalLog(this.getClass()).debug("A debug entry");
        managementService.shutdown();
        Path internalLog = this.testDir.directory("logs").resolve(INTERNAL_LOG_FILE);
        Assertions.assertThat((boolean)Files.isRegularFile(internalLog, new LinkOption[0])).isEqualTo(true);
        Assertions.assertThat((long)Files.size(internalLog)).isGreaterThan(0L);
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)GraphDatabaseInternalLogIT.countOccurrences(internalLog, "A debug entry"));
    }

    private static long countOccurrences(Path file, String substring) throws IOException {
        try (Stream<String> lines = Files.lines(file);){
            long l = lines.filter(line -> line.contains(substring)).count();
            return l;
        }
    }
}

