/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.iterator.MutableLongIterator;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.StringSearchMode;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
abstract class IndexingStringQueryAcceptanceTestBase {
    private final String template;
    private final String[] matching;
    private final String[] nonMatching;
    private final StringSearchMode searchMode;
    private final boolean withIndex;
    private Label LABEL;
    private static final String KEY = "name";
    @Inject
    private GraphDatabaseService db;

    IndexingStringQueryAcceptanceTestBase(String template, String[] matching, String[] nonMatching, StringSearchMode searchMode, boolean withIndex) {
        this.template = template;
        this.matching = matching;
        this.nonMatching = nonMatching;
        this.searchMode = searchMode;
        this.withIndex = withIndex;
    }

    @BeforeEach
    void setup(TestInfo testInfo) {
        this.LABEL = Label.label((String)("LABEL1-" + testInfo.getDisplayName()));
        if (this.withIndex) {
            try (Transaction tx = this.db.beginTx();){
                tx.schema().indexFor(this.LABEL).on(KEY).create();
                tx.commit();
            }
            tx = this.db.beginTx();
            try {
                tx.schema().awaitIndexesOnline(5L, TimeUnit.MINUTES);
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
    }

    @Test
    void shouldSupportIndexSeek() {
        this.createNodes(this.db, this.LABEL, this.nonMatching);
        MutableLongSet expected = this.createNodes(this.db, this.LABEL, this.matching);
        LongHashSet found = new LongHashSet();
        try (Transaction tx = this.db.beginTx();){
            IndexingStringQueryAcceptanceTestBase.collectNodes((MutableLongSet)found, (ResourceIterator<Node>)tx.findNodes(this.LABEL, KEY, this.template, this.searchMode));
        }
        Assertions.assertThat((Object)found).isEqualTo((Object)expected);
    }

    @Test
    void shouldIncludeNodesCreatedInSameTxInIndexSeek() {
        this.createNodes(this.db, this.LABEL, this.nonMatching[0], this.nonMatching[1]);
        MutableLongSet expected = this.createNodes(this.db, this.LABEL, this.matching[0], this.matching[1]);
        LongHashSet found = new LongHashSet();
        try (Transaction tx = this.db.beginTx();){
            expected.add(IndexingStringQueryAcceptanceTestBase.createNode(tx, MapUtil.map((Object[])new Object[]{KEY, this.matching[2]}), this.LABEL).getId());
            IndexingStringQueryAcceptanceTestBase.createNode(tx, MapUtil.map((Object[])new Object[]{KEY, this.nonMatching[2]}), this.LABEL);
            IndexingStringQueryAcceptanceTestBase.collectNodes((MutableLongSet)found, (ResourceIterator<Node>)tx.findNodes(this.LABEL, KEY, this.template, this.searchMode));
        }
        Assertions.assertThat((Object)found).isEqualTo((Object)expected);
    }

    @Test
    void shouldNotIncludeNodesDeletedInSameTxInIndexSeek() {
        this.createNodes(this.db, this.LABEL, this.nonMatching[0]);
        MutableLongSet toDelete = this.createNodes(this.db, this.LABEL, this.matching[0], this.nonMatching[1], this.matching[1], this.nonMatching[2]);
        MutableLongSet expected = this.createNodes(this.db, this.LABEL, this.matching[2]);
        LongHashSet found = new LongHashSet();
        try (Transaction tx = this.db.beginTx();){
            LongIterator deleting = toDelete.longIterator();
            while (deleting.hasNext()) {
                long id = deleting.next();
                tx.getNodeById(id).delete();
                expected.remove(id);
            }
            IndexingStringQueryAcceptanceTestBase.collectNodes((MutableLongSet)found, (ResourceIterator<Node>)tx.findNodes(this.LABEL, KEY, this.template, this.searchMode));
        }
        Assertions.assertThat((Object)found).isEqualTo((Object)expected);
    }

    @Test
    void shouldConsiderNodesChangedInSameTxInIndexSeek() {
        this.createNodes(this.db, this.LABEL, this.nonMatching[0]);
        MutableLongSet toChangeToMatch = this.createNodes(this.db, this.LABEL, this.nonMatching[1]);
        MutableLongSet toChangeToNotMatch = this.createNodes(this.db, this.LABEL, this.matching[0]);
        MutableLongSet expected = this.createNodes(this.db, this.LABEL, this.matching[1]);
        LongHashSet found = new LongHashSet();
        try (Transaction tx = this.db.beginTx();){
            LongIterator toMatching = toChangeToMatch.longIterator();
            while (toMatching.hasNext()) {
                long id = toMatching.next();
                tx.getNodeById(id).setProperty(KEY, (Object)this.matching[2]);
                expected.add(id);
            }
            MutableLongIterator toNotMatching = toChangeToNotMatch.longIterator();
            while (toNotMatching.hasNext()) {
                long id = toNotMatching.next();
                tx.getNodeById(id).setProperty(KEY, (Object)this.nonMatching[2]);
                expected.remove(id);
            }
            IndexingStringQueryAcceptanceTestBase.collectNodes((MutableLongSet)found, (ResourceIterator<Node>)tx.findNodes(this.LABEL, KEY, this.template, this.searchMode));
        }
        Assertions.assertThat((Object)found).isEqualTo((Object)expected);
    }

    private MutableLongSet createNodes(GraphDatabaseService db, Label label, String ... propertyValues) {
        LongHashSet expected = new LongHashSet();
        try (Transaction tx = db.beginTx();){
            for (String value : propertyValues) {
                expected.add(IndexingStringQueryAcceptanceTestBase.createNode(tx, MapUtil.map((Object[])new Object[]{KEY, value}), label).getId());
            }
            tx.commit();
        }
        return expected;
    }

    private static void collectNodes(MutableLongSet bucket, ResourceIterator<Node> toCollect) {
        while (toCollect.hasNext()) {
            bucket.add(((Node)toCollect.next()).getId());
        }
    }

    private static Node createNode(Transaction tx, Map<String, Object> properties, Label ... labels) {
        Node node = tx.createNode(labels);
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            node.setProperty(property.getKey(), property.getValue());
        }
        return node;
    }

    static class ContainsWithoutIndexIndexingStringQueryAcceptanceTest
    extends ContainsIndexingStringQueryAcceptanceTest {
        ContainsWithoutIndexIndexingStringQueryAcceptanceTest() {
            super(false);
        }
    }

    static class ContainsWithIndexIndexingStringQueryAcceptanceTest
    extends ContainsIndexingStringQueryAcceptanceTest {
        ContainsWithIndexIndexingStringQueryAcceptanceTest() {
            super(true);
        }
    }

    static abstract class ContainsIndexingStringQueryAcceptanceTest
    extends IndexingStringQueryAcceptanceTestBase {
        static final String[] MATCHING = new String[]{"good", "fool", "fooooood"};
        static final String[] NON_MATCHING = new String[]{"evil", "genius", "hungry"};

        ContainsIndexingStringQueryAcceptanceTest(boolean withIndex) {
            super("oo", MATCHING, NON_MATCHING, StringSearchMode.CONTAINS, withIndex);
        }
    }

    static class SuffixWithoutIndexIndexingStringQueryAcceptanceTest
    extends SuffixIndexingStringQueryAcceptanceTest {
        SuffixWithoutIndexIndexingStringQueryAcceptanceTest() {
            super(false);
        }
    }

    static class SuffixWithIndexIndexingStringQueryAcceptanceTest
    extends SuffixIndexingStringQueryAcceptanceTest {
        SuffixWithIndexIndexingStringQueryAcceptanceTest() {
            super(true);
        }
    }

    static abstract class SuffixIndexingStringQueryAcceptanceTest
    extends IndexingStringQueryAcceptanceTestBase {
        static final String[] MATCHING = new String[]{"Jansson", "Hansson", "Svensson"};
        static final String[] NON_MATCHING = new String[]{"Taverner", "Svensson-Averbuch", "Taylor"};

        SuffixIndexingStringQueryAcceptanceTest(boolean withIndex) {
            super("sson", MATCHING, NON_MATCHING, StringSearchMode.SUFFIX, withIndex);
        }
    }

    static class PrefixWithoutIndexIndexingStringQueryAcceptanceTest
    extends PrefixIndexingStringQueryAcceptanceTest {
        PrefixWithoutIndexIndexingStringQueryAcceptanceTest() {
            super(false);
        }
    }

    static class PrefixWithIndexIndexingStringQueryAcceptanceTest
    extends PrefixIndexingStringQueryAcceptanceTest {
        PrefixWithIndexIndexingStringQueryAcceptanceTest() {
            super(true);
        }
    }

    static abstract class PrefixIndexingStringQueryAcceptanceTest
    extends IndexingStringQueryAcceptanceTestBase {
        static final String[] MATCHING = new String[]{"Olivia", "Olivia2", "OliviaYtterbrink"};
        static final String[] NON_MATCHING = new String[]{"Johan", "olivia", "InteOlivia"};

        PrefixIndexingStringQueryAcceptanceTest(boolean withIndex) {
            super("Olivia", MATCHING, NON_MATCHING, StringSearchMode.PREFIX, withIndex);
        }
    }

    static class ExactWithoutIndexIndexingStringQueryAcceptanceTest
    extends ExactIndexingStringQueryAcceptanceTest {
        ExactWithoutIndexIndexingStringQueryAcceptanceTest() {
            super(false);
        }
    }

    static class ExactWithIndexIndexingStringQueryAcceptanceTest
    extends ExactIndexingStringQueryAcceptanceTest {
        ExactWithIndexIndexingStringQueryAcceptanceTest() {
            super(true);
        }
    }

    static abstract class ExactIndexingStringQueryAcceptanceTest
    extends IndexingStringQueryAcceptanceTestBase {
        static final String[] MATCHING = new String[]{"Johan", "Johan", "Johan"};
        static final String[] NON_MATCHING = new String[]{"Johanna", "Olivia", "InteJohan"};

        ExactIndexingStringQueryAcceptanceTest(boolean withIndex) {
            super("Johan", MATCHING, NON_MATCHING, StringSearchMode.EXACT, withIndex);
        }
    }
}

