/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.impl.api.index.ControlledPopulationIndexProvider;
import org.neo4j.kernel.impl.api.index.SchemaIndexTestHelper;
import org.neo4j.test.DoubleLatch;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension(configurationCallback="configure")
public class SchemaIndexWaitingAcceptanceTest {
    @Inject
    private GraphDatabaseService database;
    private final ControlledPopulationIndexProvider provider = new ControlledPopulationIndexProvider();

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        List<ExtensionFactory> extensions = Collections.singletonList(SchemaIndexTestHelper.singleInstanceIndexProviderFactory((String)"test", (IndexProvider)this.provider));
        builder.setExtensions(extensions).noOpSystemGraphInitializer();
        builder.setConfig(GraphDatabaseSettings.default_schema_provider, (Object)this.provider.getProviderDescriptor().name());
    }

    @BeforeEach
    void createSomeData() {
        try (Transaction tx = this.database.beginTx();){
            tx.createNode();
            tx.commit();
        }
    }

    @Test
    void shouldTimeoutWaitingForIndexToComeOnline() {
        IndexDefinition index;
        DoubleLatch latch = this.provider.installPopulationJobCompletionLatch();
        try (Transaction tx = this.database.beginTx();){
            index = tx.schema().indexFor(Label.label((String)"Person")).on("name").create();
            tx.commit();
        }
        latch.waitForAllToStart();
        IllegalStateException e = (IllegalStateException)org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> {
            try (Transaction tx = this.database.beginTx();){
                tx.schema().awaitIndexOnline(index, 1L, TimeUnit.MILLISECONDS);
            }
        });
        Assertions.assertThat((Throwable)e).hasMessageContaining("come online");
        latch.finish();
    }

    @Test
    void shouldTimeoutWaitingForIndexByNameToComeOnline() {
        DoubleLatch latch = this.provider.installPopulationJobCompletionLatch();
        try (Transaction tx = this.database.beginTx();){
            tx.schema().indexFor(Label.label((String)"Person")).on("name").withName("my_index").create();
            tx.commit();
        }
        latch.waitForAllToStart();
        IllegalStateException e = (IllegalStateException)org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> {
            try (Transaction tx = this.database.beginTx();){
                tx.schema().awaitIndexOnline("my_index", 1L, TimeUnit.MILLISECONDS);
            }
        });
        Assertions.assertThat((Throwable)e).hasMessageContaining("come online");
        latch.finish();
    }

    @Test
    void shouldTimeoutWaitingForAllIndexesToComeOnline() {
        DoubleLatch latch = this.provider.installPopulationJobCompletionLatch();
        try (Transaction tx = this.database.beginTx();){
            tx.schema().indexFor(Label.label((String)"Person")).on("name").create();
            tx.commit();
        }
        latch.waitForAllToStart();
        IllegalStateException e = (IllegalStateException)org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> {
            try (Transaction tx = this.database.beginTx();){
                tx.schema().awaitIndexesOnline(1L, TimeUnit.MILLISECONDS);
            }
        });
        Assertions.assertThat((Throwable)e).hasMessageContaining("come online");
        latch.finish();
    }
}

