/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.schema;

import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.monitoring.Monitors;
import org.neo4j.test.Barrier;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.TestLabels;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
class CancelIndexPopulationIT {
    private static final Label LABEL = TestLabels.LABEL_ONE;
    private static final String KEY = "key";
    @Inject
    private TestDirectory directory;

    CancelIndexPopulationIT() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldKeepIndexInPopulatingStateBetweenRestarts() throws InterruptedException {
        GraphDatabaseAPI db;
        DatabaseManagementService dbms = new TestDatabaseManagementServiceBuilder(this.directory.homePath()).build();
        try {
            db = (GraphDatabaseAPI)dbms.database("neo4j");
            Monitors monitors = (Monitors)db.getDependencyResolver().resolveDependency(Monitors.class);
            Barrier.Control barrier = new Barrier.Control();
            monitors.addMonitorListener((Object)this.populationCompletionBlocker(barrier), new String[0]);
            this.createRelevantNode((GraphDatabaseService)db);
            this.createIndex((GraphDatabaseService)db);
            barrier.await();
        }
        finally {
            dbms.shutdown();
        }
        dbms = new TestDatabaseManagementServiceBuilder(this.directory.homePath()).build();
        try {
            db = (GraphDatabaseAPI)dbms.database("neo4j");
            Assertions.assertEquals((Object)Schema.IndexState.ONLINE, (Object)this.awaitAndGetIndexState((GraphDatabaseService)db));
        }
        finally {
            dbms.shutdown();
        }
    }

    private Schema.IndexState awaitAndGetIndexState(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            IndexDefinition indexDefinition = (IndexDefinition)Iterables.first((Iterable)tx.schema().getIndexes(LABEL));
            tx.schema().awaitIndexOnline(indexDefinition, 2L, TimeUnit.MINUTES);
            Schema.IndexState indexState = tx.schema().getIndexState(indexDefinition);
            tx.commit();
            Schema.IndexState indexState2 = indexState;
            return indexState2;
        }
    }

    private void createIndex(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            tx.schema().indexFor(LABEL).on(KEY).create();
            tx.commit();
        }
    }

    private void createRelevantNode(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            tx.createNode(new Label[]{LABEL}).setProperty(KEY, (Object)"value");
            tx.commit();
        }
    }

    private IndexingService.MonitorAdapter populationCompletionBlocker(final Barrier.Control barrier) {
        return new IndexingService.MonitorAdapter(){

            public void indexPopulationScanComplete() {
                barrier.reached();
            }

            public void populationCancelled() {
                barrier.release();
            }
        };
    }
}

