/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.RepeatedTest;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.util.concurrent.Futures;

@DbmsExtension
class TokenCreationIT {
    private static final int WORKERS = 10;
    @Inject
    private GraphDatabaseService db;
    private volatile boolean stop;
    private ExecutorService executorService;

    TokenCreationIT() {
    }

    @BeforeEach
    void setUp() {
        this.executorService = Executors.newFixedThreadPool(10);
    }

    @AfterEach
    void tearDown() {
        this.executorService.shutdown();
    }

    @RepeatedTest(value=5)
    void concurrentLabelTokenCreation() throws InterruptedException, ExecutionException {
        CountDownLatch latch = new CountDownLatch(10);
        ArrayList futures = new ArrayList();
        for (int i = 0; i < 10; ++i) {
            futures.add(this.executorService.submit(new LabelCreator(this.db, latch)));
        }
        LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(500L));
        this.stop = true;
        latch.await();
        this.consumeFutures(futures);
    }

    private void consumeFutures(List<Future<?>> futures) throws ExecutionException {
        Futures.getAll(futures);
    }

    private Label[] getLabels() {
        int randomLabelValue = ThreadLocalRandom.current().nextInt(2) + 1;
        Label[] labels = new Label[randomLabelValue];
        for (int i = 0; i < labels.length; ++i) {
            labels[i] = Label.label((String)RandomStringUtils.randomAlphanumeric((int)randomLabelValue));
        }
        return labels;
    }

    private class LabelCreator
    implements Runnable {
        private final GraphDatabaseService database;
        private final CountDownLatch createLatch;

        LabelCreator(GraphDatabaseService database, CountDownLatch createLatch) {
            this.database = database;
            this.createLatch = createLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block12: {
                while (true) {
                    if (TokenCreationIT.this.stop) break block12;
                    try (Transaction transaction = this.database.beginTx();){
                        Label[] createdLabels = TokenCreationIT.this.getLabels();
                        Node node = transaction.createNode(createdLabels);
                        Iterable nodeLabels = node.getLabels();
                        Assertions.assertEquals((Object)Iterables.asSet(Arrays.asList(createdLabels)), (Object)Iterables.asSet((Iterable)nodeLabels));
                        transaction.commit();
                    }
                    catch (Exception e) {
                        TokenCreationIT.this.stop = true;
                        throw e;
                    }
                }
                finally {
                    this.createLatch.countDown();
                }
            }
        }
    }
}

