/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import java.util.HashSet;
import java.util.Iterator;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@ImpermanentDbmsExtension
@Timeout(value=20L)
class CompositeIndexingIT {
    private static final int LABEL_ID = 1;
    @Inject
    private GraphDatabaseAPI graphDatabaseAPI;
    private IndexDescriptor index;

    CompositeIndexingIT() {
    }

    void setup(IndexPrototype prototype) throws Exception {
        KernelTransaction ktx;
        try (Transaction tx = this.graphDatabaseAPI.beginTx();){
            ktx = ((InternalTransaction)tx).kernelTransaction();
            TokenWrite tokenWrite = ktx.tokenWrite();
            tokenWrite.labelGetOrCreateForName("Label0");
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)tokenWrite.labelGetOrCreateForName("Label1"));
            for (int i = 0; i < 10; ++i) {
                tokenWrite.propertyKeyGetOrCreateForName("prop" + i);
            }
            tx.commit();
        }
        tx = this.graphDatabaseAPI.beginTx();
        try {
            ktx = ((InternalTransaction)tx).kernelTransaction();
            if (prototype.isUnique()) {
                ConstraintDescriptor constraint = ktx.schemaWrite().uniquePropertyConstraintCreate(prototype);
                this.index = ktx.schemaRead().indexGetForName(constraint.getName());
            } else {
                this.index = ktx.schemaWrite().indexCreate(prototype.schema(), null);
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.graphDatabaseAPI.beginTx();
        try {
            ktx = ((InternalTransaction)tx).kernelTransaction();
            while (ktx.schemaRead().indexGetState(this.index) != InternalIndexState.ONLINE) {
                Thread.sleep(10L);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @AfterEach
    void clean() throws Exception {
        try (Transaction tx = this.graphDatabaseAPI.beginTx();){
            KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
            if (this.index.isUnique()) {
                Iterator constraints = ktx.schemaRead().constraintsGetForSchema(this.index.schema());
                while (constraints.hasNext()) {
                    ktx.schemaWrite().constraintDrop((ConstraintDescriptor)constraints.next());
                }
            } else {
                ktx.schemaWrite().indexDrop(this.index);
            }
            tx.commit();
        }
        tx = this.graphDatabaseAPI.beginTx();
        try {
            for (Node node : tx.getAllNodes()) {
                node.delete();
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private static Stream<Arguments> params() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)1, (int[])new int[]{1}))}), Arguments.arguments((Object[])new Object[]{IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)1, (int[])new int[]{1, 2}))}), Arguments.arguments((Object[])new Object[]{IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)1, (int[])new int[]{1, 2, 3, 4}))}), Arguments.arguments((Object[])new Object[]{IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)1, (int[])new int[]{1, 2, 3, 4, 5, 6, 7}))}), Arguments.arguments((Object[])new Object[]{IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)1, (int[])new int[]{1}))}), Arguments.arguments((Object[])new Object[]{IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)1, (int[])new int[]{1, 2}))}), Arguments.arguments((Object[])new Object[]{IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)1, (int[])new int[]{1, 2, 3, 4, 5, 6, 7}))}));
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldSeeNodeAddedByPropertyToIndexInTranslation(IndexPrototype prototype) throws Exception {
        this.setup(prototype);
        try (Transaction tx = this.graphDatabaseAPI.beginTx();){
            KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
            Write write = ktx.dataWrite();
            long nodeID = write.nodeCreate();
            write.nodeAddLabel(nodeID, 1);
            for (int propID : this.index.schema().getPropertyIds()) {
                write.nodeSetProperty(nodeID, propID, (Value)Values.intValue((int)propID));
            }
            try (NodeValueIndexCursor cursor = this.seek(ktx);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                Assertions.assertThat((long)cursor.nodeReference()).isEqualTo(nodeID);
                org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldSeeNodeAddedToByLabelIndexInTransaction(IndexPrototype prototype) throws Exception {
        this.setup(prototype);
        try (Transaction tx = this.graphDatabaseAPI.beginTx();){
            KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
            Write write = ktx.dataWrite();
            long nodeID = write.nodeCreate();
            for (int propID : this.index.schema().getPropertyIds()) {
                write.nodeSetProperty(nodeID, propID, (Value)Values.intValue((int)propID));
            }
            write.nodeAddLabel(nodeID, 1);
            try (NodeValueIndexCursor cursor = this.seek(ktx);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                Assertions.assertThat((long)cursor.nodeReference()).isEqualTo(nodeID);
                org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldNotSeeNodeThatWasDeletedInTransaction(IndexPrototype prototype) throws Exception {
        this.setup(prototype);
        long nodeID = this.createNode();
        try (Transaction tx = this.graphDatabaseAPI.beginTx();){
            KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
            ktx.dataWrite().nodeDelete(nodeID);
            try (NodeValueIndexCursor cursor = this.seek(ktx);){
                org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldNotSeeNodeThatHasItsLabelRemovedInTransaction(IndexPrototype prototype) throws Exception {
        this.setup(prototype);
        long nodeID = this.createNode();
        try (Transaction tx = this.graphDatabaseAPI.beginTx();){
            KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
            ktx.dataWrite().nodeRemoveLabel(nodeID, 1);
            try (NodeValueIndexCursor cursor = this.seek(ktx);){
                org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldNotSeeNodeThatHasAPropertyRemovedInTransaction(IndexPrototype prototype) throws Exception {
        this.setup(prototype);
        long nodeID = this.createNode();
        try (Transaction tx = this.graphDatabaseAPI.beginTx();){
            KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
            ktx.dataWrite().nodeRemoveProperty(nodeID, this.index.schema().getPropertyIds()[0]);
            try (NodeValueIndexCursor cursor = this.seek(ktx);){
                org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldSeeAllNodesAddedInTransaction(IndexPrototype prototype) throws Exception {
        this.setup(prototype);
        if (!this.index.isUnique()) {
            long nodeID1 = this.createNode();
            long nodeID2 = this.createNode();
            long nodeID3 = this.createNode();
            try (Transaction tx = this.graphDatabaseAPI.beginTx();){
                KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
                HashSet<Long> result = new HashSet<Long>();
                try (NodeValueIndexCursor cursor = this.seek(ktx);){
                    while (cursor.next()) {
                        result.add(cursor.nodeReference());
                    }
                }
                Assertions.assertThat(result).contains((Object[])new Long[]{nodeID1, nodeID2, nodeID3});
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldSeeAllNodesAddedBeforeTransaction(IndexPrototype prototype) throws Exception {
        this.setup(prototype);
        if (!this.index.isUnique()) {
            long nodeID1 = this.createNode();
            long nodeID2 = this.createNode();
            long nodeID3 = this.createNode();
            try (Transaction tx = this.graphDatabaseAPI.beginTx();){
                KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
                HashSet<Long> result = new HashSet<Long>();
                try (NodeValueIndexCursor cursor = this.seek(ktx);){
                    while (cursor.next()) {
                        result.add(cursor.nodeReference());
                    }
                }
                Assertions.assertThat(result).contains((Object[])new Long[]{nodeID1, nodeID2, nodeID3});
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldNotSeeNodesLackingOneProperty(IndexPrototype prototype) throws Exception {
        this.setup(prototype);
        long nodeID1 = this.createNode();
        try (Transaction tx = this.graphDatabaseAPI.beginTx();){
            KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
            Write write = ktx.dataWrite();
            long irrelevantNodeID = write.nodeCreate();
            write.nodeAddLabel(irrelevantNodeID, 1);
            int[] propertyIds = this.index.schema().getPropertyIds();
            for (int i = 0; i < propertyIds.length - 1; ++i) {
                int propID = propertyIds[i];
                write.nodeSetProperty(irrelevantNodeID, propID, (Value)Values.intValue((int)propID));
            }
            HashSet<Long> result = new HashSet<Long>();
            try (NodeValueIndexCursor cursor = this.seek(ktx);){
                while (cursor.next()) {
                    result.add(cursor.nodeReference());
                }
            }
            Assertions.assertThat(result).containsExactly((Object[])new Long[]{nodeID1});
        }
    }

    private long createNode() throws KernelException {
        long nodeID;
        try (Transaction tx = this.graphDatabaseAPI.beginTx();){
            KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
            Write write = ktx.dataWrite();
            nodeID = write.nodeCreate();
            write.nodeAddLabel(nodeID, 1);
            for (int propID : this.index.schema().getPropertyIds()) {
                write.nodeSetProperty(nodeID, propID, (Value)Values.intValue((int)propID));
            }
            tx.commit();
        }
        return nodeID;
    }

    private NodeValueIndexCursor seek(KernelTransaction transaction) throws KernelException {
        NodeValueIndexCursor cursor = transaction.cursors().allocateNodeValueIndexCursor(transaction.pageCursorTracer(), transaction.memoryTracker());
        IndexReadSession indexSession = transaction.dataRead().indexReadSession(this.index);
        transaction.dataRead().nodeIndexSeek(indexSession, cursor, IndexQueryConstraints.unconstrained(), this.exactQuery());
        return cursor;
    }

    private IndexQuery[] exactQuery() {
        int[] propertyIds = this.index.schema().getPropertyIds();
        IndexQuery[] query = new IndexQuery[propertyIds.length];
        for (int i = 0; i < query.length; ++i) {
            int propID = propertyIds[i];
            query[i] = IndexQuery.exact((int)propID, (Object)Values.of((Object)propID));
        }
        return query;
    }
}

