/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.RawIterator;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;

class BuiltInDbmsProceduresIT
extends KernelIntegrationTest {
    BuiltInDbmsProceduresIT() {
    }

    @Test
    void listConfig() throws Exception {
        List<AnyValue[]> config = this.callListConfig("");
        List names = config.stream().map(o -> ((TextValue)o[0]).stringValue()).collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertTrue((names.size() > 10 ? 1 : 0) != 0);
        Assertions.assertThat(names).contains((Object[])new String[]{GraphDatabaseSettings.record_format.name()});
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)names.stream().filter(n -> n.startsWith("unsupported")).count());
    }

    @Test
    void listConfigWithASpecificConfigName() throws Exception {
        List<AnyValue[]> config = this.callListConfig(GraphDatabaseSettings.strict_config_validation.name());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)config.size());
        org.junit.jupiter.api.Assertions.assertArrayEquals((Object[])new AnyValue[]{Values.stringValue((String)"dbms.config.strict_validation"), Values.stringValue((String)"A strict configuration validation will prevent the database from starting up if unknown configuration options are specified in the neo4j settings namespace (such as dbms., cypher., etc)."), Values.stringValue((String)"false"), Values.FALSE}, (Object[])config.get(0));
    }

    @Test
    void listClientConfig() throws Exception {
        QualifiedName procedureName = ProcedureSignature.procedureName((String[])new String[]{"dbms", "clientConfig"});
        int procedureId = this.procs().procedureGet(procedureName).id();
        RawIterator callResult = this.procs().procedureCallDbms(procedureId, new AnyValue[0], ProcedureCallContext.EMPTY);
        List config = Iterators.asList((RawIterator)callResult);
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)config.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)((AnyValue[])config.get(0))[0], (Object)Values.stringValue((String)"browser.post_connect_cmd"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)((AnyValue[])config.get(1))[0], (Object)Values.stringValue((String)"browser.remote_content_hostname_whitelist"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)((AnyValue[])config.get(2))[0], (Object)Values.stringValue((String)"dbms.default_database"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)((AnyValue[])config.get(3))[0], (Object)Values.stringValue((String)"dbms.security.auth_enabled"));
    }

    @Test
    void durationAlwaysListedWithUnit() throws Exception {
        List<AnyValue[]> config = this.callListConfig(GraphDatabaseSettings.transaction_timeout.name());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)config.size());
        org.junit.jupiter.api.Assertions.assertArrayEquals((Object[])new AnyValue[]{Values.stringValue((String)"dbms.transaction.timeout"), Values.stringValue((String)"The maximum time interval of a transaction within which it should be completed."), Values.stringValue((String)"0s"), Values.TRUE}, (Object[])config.get(0));
    }

    @Test
    void listDynamicSetting() throws KernelException {
        List<AnyValue[]> config = this.callListConfig(GraphDatabaseSettings.check_point_iops_limit.name());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)config.size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((BooleanValue)config.get(0)[3]).booleanValue());
    }

    @Test
    void listNotDynamicSetting() throws KernelException {
        List<AnyValue[]> config = this.callListConfig(GraphDatabaseSettings.data_directory.name());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)config.size());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((BooleanValue)config.get(0)[3]).booleanValue());
    }

    private List<AnyValue[]> callListConfig(String searchString) throws KernelException {
        QualifiedName procedureName = ProcedureSignature.procedureName((String[])new String[]{"dbms", "listConfig"});
        int procedureId = this.procs().procedureGet(procedureName).id();
        RawIterator callResult = this.procs().procedureCallDbms(procedureId, (AnyValue[])ArrayUtils.toArray((Object[])new TextValue[]{Values.stringValue((String)searchString)}), ProcedureCallContext.EMPTY);
        return Iterators.asList((RawIterator)callResult);
    }
}

