/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.counts;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.NamedThreadFactory;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.Barrier;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
class NodeCountsTest {
    @Inject
    private GraphDatabaseAPI db;

    NodeCountsTest() {
    }

    @Test
    void shouldReportNumberOfNodesInAnEmptyGraph() {
        long nodeCount = this.numberOfNodes();
        Assertions.assertEquals((long)0L, (long)nodeCount);
    }

    @Test
    void shouldReportNumberOfNodes() {
        try (Transaction tx = this.db.beginTx();){
            tx.createNode();
            tx.createNode();
            tx.commit();
        }
        long nodeCount = this.numberOfNodes();
        Assertions.assertEquals((long)2L, (long)nodeCount);
    }

    @Test
    void shouldReportAccurateNumberOfNodesAfterDeletion() {
        Node one;
        try (Transaction tx = this.db.beginTx();){
            one = tx.createNode();
            tx.createNode();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.getNodeById(one.getId()).delete();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        long nodeCount = this.numberOfNodes();
        Assertions.assertEquals((long)1L, (long)nodeCount);
    }

    @Test
    void shouldIncludeNumberOfNodesAddedInTransaction() {
        try (Transaction tx = this.db.beginTx();){
            tx.createNode();
            tx.createNode();
            tx.commit();
        }
        long before = this.numberOfNodes();
        try (Transaction tx = this.db.beginTx();){
            tx.createNode();
            long nodeCount = this.countsForNode(tx);
            Assertions.assertEquals((long)(before + 1L), (long)nodeCount);
            tx.commit();
        }
    }

    @Test
    void shouldIncludeNumberOfNodesDeletedInTransaction() {
        Node one;
        try (Transaction tx = this.db.beginTx();){
            one = tx.createNode();
            tx.createNode();
            tx.commit();
        }
        long before = this.numberOfNodes();
        try (Transaction tx = this.db.beginTx();){
            tx.getNodeById(one.getId()).delete();
            long nodeCount = this.countsForNode(tx);
            Assertions.assertEquals((long)(before - 1L), (long)nodeCount);
            tx.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldNotSeeNodeCountsOfOtherTransaction() throws Exception {
        Barrier.Control barrier = new Barrier.Control();
        long before = this.numberOfNodes();
        ExecutorService executor = Executors.newSingleThreadExecutor((ThreadFactory)NamedThreadFactory.named((String)"create-nodes"));
        GraphDatabaseAPI graphDb = this.db;
        try {
            Future<Long> done = executor.submit(() -> {
                try (Transaction tx = graphDb.beginTx();){
                    tx.createNode();
                    tx.createNode();
                    barrier.reached();
                    long whatThisThreadSees = this.countsForNode(tx);
                    tx.commit();
                    Long l = whatThisThreadSees;
                    return l;
                }
            });
            barrier.await();
            long during = this.numberOfNodes();
            barrier.release();
            long whatOtherThreadSees = done.get();
            long after = this.numberOfNodes();
            Assertions.assertEquals((long)0L, (long)before);
            Assertions.assertEquals((long)0L, (long)during);
            Assertions.assertEquals((long)after, (long)whatOtherThreadSees);
            Assertions.assertEquals((long)2L, (long)after);
        }
        finally {
            executor.shutdown();
        }
    }

    private long numberOfNodes() {
        try (Transaction tx = this.db.beginTx();){
            long nodeCount = this.countsForNode(tx);
            tx.commit();
            long l = nodeCount;
            return l;
        }
    }

    private long countsForNode(Transaction tx) {
        return ((InternalTransaction)tx).kernelTransaction().dataRead().countsForNode(-1);
    }
}

