/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.time.Duration;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;
import org.neo4j.util.concurrent.BinaryLatch;

@DbmsExtension(configurationCallback="configure")
public class KernelTransactionTimeoutMonitorIT {
    @Inject
    private GraphDatabaseAPI database;
    @Inject
    private KernelTransactions kernelTransactions;
    private static final int NODE_ID = 0;
    private ExecutorService executor;

    @ExtensionCallback
    protected void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseInternalSettings.lock_manager, (Object)"community");
        builder.setConfig(GraphDatabaseSettings.transaction_monitor_check_interval, (Object)Duration.ofMillis(100L));
    }

    @BeforeEach
    void setUp() {
        this.executor = Executors.newSingleThreadExecutor();
    }

    @AfterEach
    void tearDown() {
        this.executor.shutdown();
    }

    @Test
    @Timeout(value=30L)
    void terminatingTransactionMustEagerlyReleaseTheirLocks() throws Exception {
        boolean proceed;
        long nodeId;
        AtomicBoolean nodeLockAcquired = new AtomicBoolean();
        AtomicBoolean lockerDone = new AtomicBoolean();
        BinaryLatch lockerPause = new BinaryLatch();
        try (Transaction tx = this.database.beginTx();){
            nodeId = tx.createNode().getId();
            tx.commit();
        }
        Future<?> locker = this.executor.submit(() -> {
            try (Transaction tx = this.database.beginTx();){
                Node node = tx.getNodeById(nodeId);
                tx.acquireReadLock((Entity)node);
                nodeLockAcquired.set(true);
                lockerPause.await();
            }
            lockerDone.set(true);
        });
        while (!(proceed = nodeLockAcquired.get())) {
        }
        this.terminateOngoingTransaction();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)lockerDone.get());
        try (Transaction tx = this.database.beginTx();){
            tx.acquireWriteLock((Entity)tx.getNodeById(nodeId));
            tx.commit();
        }
        lockerPause.release();
        locker.get();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)lockerDone.get());
    }

    @Timeout(value=30L)
    @Test
    void terminateExpiredTransaction() {
        try (Transaction transaction = this.database.beginTx();){
            transaction.createNode();
            transaction.commit();
        }
        Exception exception = (Exception)org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> {
            try (Transaction transaction = this.database.beginTx();){
                Node nodeById = transaction.getNodeById(0L);
                nodeById.setProperty("a", (Object)"b");
                this.executor.submit(this.startAnotherTransaction()).get();
            }
        });
        Assertions.assertThat((String)exception.getMessage()).contains(new CharSequence[]{"The transaction has been terminated."});
    }

    private void terminateOngoingTransaction() {
        Set kernelTransactionHandles = this.kernelTransactions.activeTransactions();
        Assertions.assertThat((Iterable)kernelTransactionHandles).hasSize(1);
        for (KernelTransactionHandle kernelTransactionHandle : kernelTransactionHandles) {
            kernelTransactionHandle.markForTermination((Status)Status.Transaction.Terminated);
        }
    }

    private Runnable startAnotherTransaction() {
        return () -> {
            try (InternalTransaction tx = this.database.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED, ClientConnectionInfo.EMBEDDED_CONNECTION, 1L, TimeUnit.SECONDS);){
                Node node = tx.getNodeById(0L);
                node.setProperty("c", (Object)"d");
            }
        };
    }
}

