/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.Kernel;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.schema.UniquePropertyValueValidationException;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.values.storable.Values;

@ImpermanentDbmsExtension
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class CompositeUniquenessConstraintValidationIT {
    @Inject
    private GraphDatabaseAPI db;
    private ConstraintDescriptor constraintDescriptor;
    private int label;
    private KernelTransaction transaction;
    protected Kernel kernel;

    public static Stream<Arguments> parameterValues() {
        return Stream.of(Arguments.of((Object[])new Object[]{CompositeUniquenessConstraintValidationIT.values(10), CompositeUniquenessConstraintValidationIT.values(10.0)}), Arguments.of((Object[])new Object[]{CompositeUniquenessConstraintValidationIT.values(10, 20), CompositeUniquenessConstraintValidationIT.values(10, 20)}), Arguments.of((Object[])new Object[]{CompositeUniquenessConstraintValidationIT.values(10L, 20L), CompositeUniquenessConstraintValidationIT.values(10, 20)}), Arguments.of((Object[])new Object[]{CompositeUniquenessConstraintValidationIT.values(10, 20), CompositeUniquenessConstraintValidationIT.values(10L, 20L)}), Arguments.of((Object[])new Object[]{CompositeUniquenessConstraintValidationIT.values(10, 20), CompositeUniquenessConstraintValidationIT.values(10.0, 20.0)}), Arguments.of((Object[])new Object[]{CompositeUniquenessConstraintValidationIT.values(10, 20), CompositeUniquenessConstraintValidationIT.values(10.0, 20.0)}), Arguments.of((Object[])new Object[]{CompositeUniquenessConstraintValidationIT.values(new int[]{1, 2}, "v2"), CompositeUniquenessConstraintValidationIT.values(new int[]{1, 2}, "v2")}), Arguments.of((Object[])new Object[]{CompositeUniquenessConstraintValidationIT.values("a", "b", "c"), CompositeUniquenessConstraintValidationIT.values("a", "b", "c")}), Arguments.of((Object[])new Object[]{CompositeUniquenessConstraintValidationIT.values(285414114323346805L), CompositeUniquenessConstraintValidationIT.values(285414114323346805L)}), Arguments.of((Object[])new Object[]{CompositeUniquenessConstraintValidationIT.values(1, 2, 3, 4, 5, 6, 7, 8, 9, 10), CompositeUniquenessConstraintValidationIT.values(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0)}));
    }

    private static Object[] values(Object ... values) {
        return values;
    }

    @BeforeEach
    public void setup() throws Exception {
        this.kernel = (Kernel)this.db.getDependencyResolver().resolveDependency(Kernel.class);
        this.newTransaction();
        TokenWrite tokenWrite = this.transaction.tokenWrite();
        tokenWrite.labelGetOrCreateForName("Label0");
        this.label = tokenWrite.labelGetOrCreateForName("Label1");
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.label);
        for (int i = 0; i < 10; ++i) {
            int prop = tokenWrite.propertyKeyGetOrCreateForName("prop" + i);
            org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)prop);
        }
        this.commit();
    }

    private void setupConstraintDescriptor(int nbrOfProperties) throws KernelException {
        this.newTransaction();
        this.constraintDescriptor = this.transaction.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])this.propertyIds(nbrOfProperties))));
        this.commit();
    }

    @AfterEach
    public void clean() throws Exception {
        if (this.transaction != null) {
            this.transaction.close();
            this.transaction = null;
        }
        this.newTransaction();
        this.transaction.schemaWrite().constraintDrop(this.constraintDescriptor);
        this.commit();
        try (KernelTransaction tx = this.kernel.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);){
            try (NodeCursor node = tx.cursors().allocateNodeCursor(tx.pageCursorTracer());){
                tx.dataRead().allNodesScan(node);
                while (node.next()) {
                    tx.dataWrite().nodeDelete(node.nodeReference());
                }
            }
            tx.commit();
        }
    }

    @ParameterizedTest(name="{index}: lhs={0}, rhs={1}")
    @MethodSource(value={"parameterValues"})
    public void shouldAllowRemoveAndAddConflictingDataInOneTransaction_DeleteNode(Object[] lhs, Object[] rhs) throws Exception {
        this.setupConstraintDescriptor(lhs.length);
        long node = this.createNodeWithLabelAndProps(this.label, lhs);
        this.newTransaction();
        this.transaction.dataWrite().nodeDelete(node);
        long newNode = this.createLabeledNode(this.label);
        this.setProperties(newNode, lhs);
        this.commit();
    }

    @ParameterizedTest(name="{index}: lhs={0}, rhs={1}")
    @MethodSource(value={"parameterValues"})
    public void shouldAllowRemoveAndAddConflictingDataInOneTransaction_RemoveLabel(Object[] lhs, Object[] rhs) throws Exception {
        this.setupConstraintDescriptor(lhs.length);
        long node = this.createNodeWithLabelAndProps(this.label, lhs);
        this.newTransaction();
        this.transaction.dataWrite().nodeRemoveLabel(node, this.label);
        long newNode = this.createLabeledNode(this.label);
        this.setProperties(newNode, lhs);
        this.commit();
    }

    @ParameterizedTest(name="{index}: lhs={0}, rhs={1}")
    @MethodSource(value={"parameterValues"})
    public void shouldAllowRemoveAndAddConflictingDataInOneTransaction_RemoveProperty(Object[] lhs, Object[] rhs) throws Exception {
        this.setupConstraintDescriptor(lhs.length);
        long node = this.createNodeWithLabelAndProps(this.label, lhs);
        this.newTransaction();
        this.transaction.dataWrite().nodeRemoveProperty(node, 0);
        long newNode = this.createLabeledNode(this.label);
        this.setProperties(newNode, lhs);
        this.commit();
    }

    @ParameterizedTest(name="{index}: lhs={0}, rhs={1}")
    @MethodSource(value={"parameterValues"})
    public void shouldAllowRemoveAndAddConflictingDataInOneTransaction_ChangeProperty(Object[] lhs, Object[] rhs) throws Exception {
        this.setupConstraintDescriptor(lhs.length);
        long node = this.createNodeWithLabelAndProps(this.label, lhs);
        this.newTransaction();
        this.transaction.dataWrite().nodeSetProperty(node, 0, Values.of((Object)"Alive!"));
        long newNode = this.createLabeledNode(this.label);
        this.setProperties(newNode, lhs);
        this.commit();
    }

    @ParameterizedTest(name="{index}: lhs={0}, rhs={1}")
    @MethodSource(value={"parameterValues"})
    public void shouldPreventConflictingDataInTx(Object[] lhs, Object[] rhs) throws Throwable {
        this.setupConstraintDescriptor(lhs.length);
        this.newTransaction();
        long n1 = this.createLabeledNode(this.label);
        long n2 = this.createLabeledNode(this.label);
        this.setProperties(n1, lhs);
        int lastPropertyOffset = lhs.length - 1;
        for (int prop = 0; prop < lastPropertyOffset; ++prop) {
            this.setProperty(n2, prop, lhs[prop]);
        }
        Assertions.assertThatThrownBy(() -> this.setProperty(n2, lastPropertyOffset, lhs[lastPropertyOffset])).isInstanceOf(UniquePropertyValueValidationException.class);
        this.commit();
    }

    @ParameterizedTest(name="{index}: lhs={0}, rhs={1}")
    @MethodSource(value={"parameterValues"})
    public void shouldEnforceOnSetProperty(Object[] lhs, Object[] rhs) throws Exception {
        this.setupConstraintDescriptor(lhs.length);
        this.createNodeWithLabelAndProps(this.label, lhs);
        this.newTransaction();
        long node = this.createLabeledNode(this.label);
        int lastPropertyOffset = lhs.length - 1;
        for (int prop = 0; prop < lastPropertyOffset; ++prop) {
            this.setProperty(node, prop, lhs[prop]);
        }
        Assertions.assertThatThrownBy(() -> this.setProperty(node, lastPropertyOffset, lhs[lastPropertyOffset])).isInstanceOf(UniquePropertyValueValidationException.class);
        this.commit();
    }

    @ParameterizedTest(name="{index}: lhs={0}, rhs={1}")
    @MethodSource(value={"parameterValues"})
    public void shouldEnforceOnSetLabel(Object[] lhs, Object[] rhs) throws Exception {
        this.setupConstraintDescriptor(lhs.length);
        this.createNodeWithLabelAndProps(this.label, lhs);
        this.newTransaction();
        long node = this.createNode();
        this.setProperties(node, rhs);
        Assertions.assertThatThrownBy(() -> this.addLabel(node, this.label)).isInstanceOf(UniquePropertyValueValidationException.class);
        this.commit();
    }

    @ParameterizedTest(name="{index}: lhs={0}, rhs={1}")
    @MethodSource(value={"parameterValues"})
    public void shouldEnforceOnSetPropertyInTx(Object[] lhs, Object[] rhs) throws Exception {
        this.setupConstraintDescriptor(lhs.length);
        this.newTransaction();
        long aNode = this.createLabeledNode(this.label);
        this.setProperties(aNode, lhs);
        long nodeB = this.createLabeledNode(this.label);
        int lastPropertyOffset = lhs.length - 1;
        for (int prop = 0; prop < lastPropertyOffset; ++prop) {
            this.setProperty(nodeB, prop, rhs[prop]);
        }
        Assertions.assertThatThrownBy(() -> this.setProperty(nodeB, lastPropertyOffset, rhs[lastPropertyOffset])).isInstanceOf(UniquePropertyValueValidationException.class);
        this.commit();
    }

    @ParameterizedTest(name="{index}: lhs={0}, rhs={1}")
    @MethodSource(value={"parameterValues"})
    public void shouldEnforceOnSetLabelInTx(Object[] lhs, Object[] rhs) throws Exception {
        this.setupConstraintDescriptor(lhs.length);
        this.createNodeWithLabelAndProps(this.label, lhs);
        this.newTransaction();
        long nodeB = this.createNode();
        this.setProperties(nodeB, rhs);
        Assertions.assertThatThrownBy(() -> this.addLabel(nodeB, this.label)).isInstanceOf(UniquePropertyValueValidationException.class);
        this.commit();
    }

    private void newTransaction() throws KernelException {
        ((ObjectAssert)Assertions.assertThat((Object)this.transaction).as("tx already opened", new Object[0])).isNull();
        this.transaction = this.kernel.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
    }

    protected void commit() throws TransactionFailureException {
        this.transaction.commit();
        this.transaction = null;
    }

    private long createLabeledNode(int labelId) throws KernelException {
        long node = this.transaction.dataWrite().nodeCreate();
        this.transaction.dataWrite().nodeAddLabel(node, labelId);
        return node;
    }

    private void addLabel(long nodeId, int labelId) throws KernelException {
        this.transaction.dataWrite().nodeAddLabel(nodeId, labelId);
    }

    private void setProperty(long nodeId, int propertyId, Object value) throws KernelException {
        this.transaction.dataWrite().nodeSetProperty(nodeId, propertyId, Values.of((Object)value));
    }

    private long createNode() throws KernelException {
        return this.transaction.dataWrite().nodeCreate();
    }

    private long createNodeWithLabelAndProps(int labelId, Object[] propertyValues) throws KernelException {
        this.newTransaction();
        long nodeId = this.createNode();
        this.addLabel(nodeId, labelId);
        for (int prop = 0; prop < propertyValues.length; ++prop) {
            this.setProperty(nodeId, prop, propertyValues[prop]);
        }
        this.commit();
        return nodeId;
    }

    private void setProperties(long nodeId, Object[] propertyValues) throws KernelException {
        for (int prop = 0; prop < propertyValues.length; ++prop) {
            this.setProperty(nodeId, prop, propertyValues[prop]);
        }
    }

    private int[] propertyIds(int numberOfProps) {
        int[] props = new int[numberOfProps];
        for (int i = 0; i < numberOfProps; ++i) {
            props[i] = i;
        }
        return props;
    }
}

