/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.ArrayUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.test.rule.OtherThreadRule;

class RelationshipIT
extends KernelIntegrationTest {
    private final OtherThreadRule otherThread = new OtherThreadRule();

    RelationshipIT() {
    }

    @BeforeEach
    void setUp() {
        this.otherThread.init("t2");
    }

    @AfterEach
    void tearDown() {
        this.otherThread.close();
    }

    @Test
    void shouldListRelationshipsInCurrentAndSubsequentTx() throws Exception {
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        int relType1 = transaction.tokenWrite().relationshipTypeGetOrCreateForName("Type1");
        int relType2 = transaction.tokenWrite().relationshipTypeGetOrCreateForName("Type2");
        long refNode = transaction.dataWrite().nodeCreate();
        long otherNode = transaction.dataWrite().nodeCreate();
        long fromRefToOther1 = transaction.dataWrite().relationshipCreate(refNode, relType1, otherNode);
        long fromRefToOther2 = transaction.dataWrite().relationshipCreate(refNode, relType2, otherNode);
        long fromOtherToRef = transaction.dataWrite().relationshipCreate(otherNode, relType1, refNode);
        long fromRefToRef = transaction.dataWrite().relationshipCreate(refNode, relType2, refNode);
        long endNode = transaction.dataWrite().nodeCreate();
        long fromRefToThird = transaction.dataWrite().relationshipCreate(refNode, relType2, endNode);
        RelationshipIT.assertRels(RelationshipIT.nodeGetRelationships(transaction, refNode, Direction.BOTH), fromRefToOther1, fromRefToOther2, fromRefToRef, fromRefToThird, fromOtherToRef);
        RelationshipIT.assertRels(RelationshipIT.nodeGetRelationships(transaction, refNode, Direction.BOTH, new int[]{relType1}), fromRefToOther1, fromOtherToRef);
        RelationshipIT.assertRels(RelationshipIT.nodeGetRelationships(transaction, refNode, Direction.BOTH, new int[]{relType1, relType2}), fromRefToOther1, fromRefToOther2, fromRefToRef, fromRefToThird, fromOtherToRef);
        RelationshipIT.assertRels(RelationshipIT.nodeGetRelationships(transaction, refNode, Direction.INCOMING), fromOtherToRef);
        RelationshipIT.assertRels(RelationshipIT.nodeGetRelationships(transaction, refNode, Direction.INCOMING, new int[]{relType1}), fromOtherToRef);
        RelationshipIT.assertRels(RelationshipIT.nodeGetRelationships(transaction, refNode, Direction.OUTGOING, new int[]{relType1, relType2}), fromRefToOther1, fromRefToOther2, fromRefToThird, fromRefToRef);
        this.commit();
        transaction = this.newTransaction();
        RelationshipIT.assertRels(RelationshipIT.nodeGetRelationships(transaction, refNode, Direction.BOTH), fromRefToOther1, fromRefToOther2, fromRefToRef, fromRefToThird, fromOtherToRef);
        RelationshipIT.assertRels(RelationshipIT.nodeGetRelationships(transaction, refNode, Direction.BOTH, new int[]{relType1}), fromRefToOther1, fromOtherToRef);
        RelationshipIT.assertRels(RelationshipIT.nodeGetRelationships(transaction, refNode, Direction.BOTH, new int[]{relType1, relType2}), fromRefToOther1, fromRefToOther2, fromRefToRef, fromRefToThird, fromOtherToRef);
        RelationshipIT.assertRels(RelationshipIT.nodeGetRelationships(transaction, refNode, Direction.INCOMING), fromOtherToRef);
        RelationshipIT.assertRels(RelationshipIT.nodeGetRelationships(transaction, refNode, Direction.INCOMING, new int[]{relType1}), fromOtherToRef);
        RelationshipIT.assertRels(RelationshipIT.nodeGetRelationships(transaction, refNode, Direction.OUTGOING, new int[]{relType1, relType2}), fromRefToOther1, fromRefToOther2, fromRefToThird, fromRefToRef);
        this.commit();
    }

    @Test
    void shouldInterleaveModifiedRelationshipsWithExistingOnes() throws Exception {
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        int relType1 = transaction.tokenWrite().relationshipTypeGetOrCreateForName("Type1");
        int relType2 = transaction.tokenWrite().relationshipTypeGetOrCreateForName("Type2");
        long refNode = transaction.dataWrite().nodeCreate();
        long otherNode = transaction.dataWrite().nodeCreate();
        long fromRefToOther1 = transaction.dataWrite().relationshipCreate(refNode, relType1, otherNode);
        long fromRefToOther2 = transaction.dataWrite().relationshipCreate(refNode, relType2, otherNode);
        this.commit();
        transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        transaction.dataWrite().relationshipDelete(fromRefToOther1);
        long endNode = transaction.dataWrite().nodeCreate();
        long localTxRel = transaction.dataWrite().relationshipCreate(refNode, relType1, endNode);
        RelationshipIT.assertRels(RelationshipIT.nodeGetRelationships(transaction, refNode, Direction.BOTH), fromRefToOther2, localTxRel);
        this.assertRelsInSeparateTx(refNode, Direction.BOTH, fromRefToOther1, fromRefToOther2);
        this.commit();
    }

    @Test
    void shouldReturnRelsWhenAskingForRelsWhereOnlySomeTypesExistInCurrentRel() throws Exception {
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        int relType1 = transaction.tokenWrite().relationshipTypeGetOrCreateForName("Type1");
        int relType2 = transaction.tokenWrite().relationshipTypeGetOrCreateForName("Type2");
        long refNode = transaction.dataWrite().nodeCreate();
        long otherNode = transaction.dataWrite().nodeCreate();
        long theRel = transaction.dataWrite().relationshipCreate(refNode, relType1, otherNode);
        RelationshipIT.assertRels(RelationshipIT.nodeGetRelationships(transaction, refNode, Direction.OUTGOING, new int[]{relType2, relType1}), theRel);
        this.commit();
    }

    @Test
    void askingForNonExistantReltypeOnDenseNodeShouldNotCorruptState() throws Exception {
        long[] rels = new long[200];
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        int relTypeTheNodeDoesUse = transaction.tokenWrite().relationshipTypeGetOrCreateForName("Type1");
        int relTypeTheNodeDoesNotUse = transaction.tokenWrite().relationshipTypeGetOrCreateForName("Type2");
        long refNode = transaction.dataWrite().nodeCreate();
        long otherNode = transaction.dataWrite().nodeCreate();
        for (int i = 0; i < rels.length; ++i) {
            rels[i] = transaction.dataWrite().relationshipCreate(refNode, relTypeTheNodeDoesUse, otherNode);
        }
        this.commit();
        transaction = this.newTransaction();
        RelationshipIT.assertRels(RelationshipIT.nodeGetRelationships(transaction, refNode, Direction.INCOMING, new int[]{relTypeTheNodeDoesNotUse}), new long[0]);
        RelationshipIT.assertRels(RelationshipIT.nodeGetRelationships(transaction, refNode, Direction.BOTH, new int[]{relTypeTheNodeDoesUse}), rels);
        this.commit();
    }

    private void assertRelsInSeparateTx(long refNode, Direction both, long ... longs) throws InterruptedException, ExecutionException, TimeoutException {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)this.otherThread.execute(() -> {
            try (KernelTransaction ktx = this.kernel.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);){
                RelationshipIT.assertRels(RelationshipIT.nodeGetRelationships(ktx, refNode, both), longs);
            }
            return true;
        }).get(10L, TimeUnit.SECONDS)));
    }

    private static void assertRels(Iterator<Long> it, long ... rels) {
        List list = Iterators.asList(it);
        Assertions.assertThat((List)list).contains((Object[])ArrayUtils.toObject((long[])rels));
    }
}

