/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
class ConcurrentCreateAndGetRelationshipsIT {
    @Inject
    private GraphDatabaseService db;
    private static final RelationshipType RELTYPE = MyRelTypes.TEST;

    ConcurrentCreateAndGetRelationshipsIT() {
    }

    @Test
    void tryToReproduceTheIssue() throws Exception {
        CountDownLatch startSignal = new CountDownLatch(1);
        AtomicBoolean stopSignal = new AtomicBoolean();
        AtomicReference<Exception> failure = new AtomicReference<Exception>();
        Node parentNode = this.createNode(this.db);
        Collection<Worker> workers = this.createWorkers(this.db, startSignal, stopSignal, failure, parentNode);
        startSignal.countDown();
        Thread.sleep(500L);
        stopSignal.set(true);
        this.awaitWorkersToEnd(workers);
        if (failure.get() != null) {
            throw new Exception("A worker failed", failure.get());
        }
    }

    private void awaitWorkersToEnd(Collection<Worker> workers) throws InterruptedException {
        for (Worker worker : workers) {
            worker.join();
        }
    }

    private Collection<Worker> createWorkers(GraphDatabaseService db, CountDownLatch startSignal, AtomicBoolean stopSignal, AtomicReference<Exception> failure, Node parentNode) {
        ArrayList<Worker> workers = new ArrayList<Worker>();
        for (int i = 0; i < 2; ++i) {
            workers.add(this.newWorker(db, startSignal, stopSignal, failure, parentNode));
        }
        return workers;
    }

    private Worker newWorker(GraphDatabaseService db, CountDownLatch startSignal, AtomicBoolean stopSignal, AtomicReference<Exception> failure, Node parentNode) {
        Worker worker = new Worker(db, startSignal, stopSignal, failure, parentNode);
        worker.start();
        return worker;
    }

    private Node createNode(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode();
            tx.commit();
            Node node2 = node;
            return node2;
        }
    }

    private static class Worker
    extends Thread {
        private final GraphDatabaseService db;
        private final CountDownLatch startSignal;
        private final AtomicReference<Exception> failure;
        private final Node parentNode;
        private final AtomicBoolean stopSignal;

        Worker(GraphDatabaseService db, CountDownLatch startSignal, AtomicBoolean stopSignal, AtomicReference<Exception> failure, Node parentNode) {
            this.db = db;
            this.startSignal = startSignal;
            this.stopSignal = stopSignal;
            this.failure = failure;
            this.parentNode = parentNode;
        }

        @Override
        public void run() {
            this.awaitStartSignal();
            while (this.failure.get() == null && !this.stopSignal.get()) {
                try {
                    Transaction tx = this.db.beginTx();
                    try {
                        Node node = tx.getNodeById(this.parentNode.getId());
                        Iterables.count((Iterable)node.getRelationships(Direction.OUTGOING, new RelationshipType[]{RELTYPE}));
                        node.createRelationshipTo(tx.createNode(), RELTYPE);
                        tx.commit();
                    }
                    finally {
                        if (tx == null) continue;
                        tx.close();
                    }
                }
                catch (Exception e) {
                    this.failure.compareAndSet(null, e);
                }
            }
        }

        private void awaitStartSignal() {
            try {
                this.startSignal.await(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

