/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.exceptions.schema.TokenCapacityExceededKernelException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.test.assertion.Assert;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
public abstract class EntityTest {
    @Inject
    GraphDatabaseService db;

    protected abstract long createEntity(Transaction var1);

    protected abstract Entity lookupEntity(Transaction var1, long var2);

    @Test
    void shouldListAllProperties() {
        Map listedProperties;
        long containerId;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("boolean", true);
        properties.put("short_string", "abc");
        properties.put("string", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz");
        properties.put("long", Long.MAX_VALUE);
        properties.put("short_array", new long[]{1L, 2L, 3L, 4L});
        properties.put("array", new long[]{0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFDL, 0x7FFFFFFFFFFFFFFCL, 0x7FFFFFFFFFFFFFFBL, 0x7FFFFFFFFFFFFFFAL, 0x7FFFFFFFFFFFFFF9L, 0x7FFFFFFFFFFFFFF8L, 0x7FFFFFFFFFFFFFF7L, 0x7FFFFFFFFFFFFFF6L, 0x7FFFFFFFFFFFFFF5L, 0x7FFFFFFFFFFFFFF4L});
        try (Transaction tx = this.db.beginTx();){
            containerId = this.createEntity(tx);
            Entity container = this.lookupEntity(tx, containerId);
            for (Map.Entry entry : properties.entrySet()) {
                container.setProperty((String)entry.getKey(), entry.getValue());
            }
            tx.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            listedProperties = this.lookupEntity(tx, containerId).getAllProperties();
            tx.commit();
        }
        Assertions.assertEquals((int)properties.size(), (int)listedProperties.size());
        for (String key : properties.keySet()) {
            Assert.assertObjectOrArrayEquals(properties.get(key), listedProperties.get(key));
        }
    }

    InternalTransaction mockedTransactionWithDepletedTokens() throws KernelException {
        InternalTransaction internalTransaction = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        KernelTransaction ktx = (KernelTransaction)Mockito.mock(KernelTransaction.class);
        TokenWrite tokenWrite = (TokenWrite)Mockito.mock(TokenWrite.class);
        Mockito.when((Object)ktx.tokenWrite()).thenReturn((Object)tokenWrite);
        Mockito.when((Object)tokenWrite.labelGetOrCreateForName((String)ArgumentMatchers.any())).thenThrow(new Throwable[]{new TokenCapacityExceededKernelException((Throwable)new Exception("Just some cause"), "Label")});
        Mockito.when((Object)tokenWrite.propertyKeyGetOrCreateForName((String)ArgumentMatchers.any())).thenThrow(new Throwable[]{new TokenCapacityExceededKernelException((Throwable)new Exception("Just some cause"), "PropertyKey")});
        Mockito.when((Object)tokenWrite.relationshipTypeGetOrCreateForName((String)ArgumentMatchers.any())).thenThrow(new Throwable[]{new TokenCapacityExceededKernelException((Throwable)new Exception("Just some cause"), "RelationshipType")});
        Mockito.when((Object)internalTransaction.kernelTransaction()).thenReturn((Object)ktx);
        return internalTransaction;
    }
}

