/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.impl.core.NodeEntity;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
public class RelationshipAccessRequireTransactionIT {
    @Inject
    private GraphDatabaseAPI databaseAPI;
    private InternalTransaction transaction;

    @BeforeEach
    void setUp() {
        this.transaction = (InternalTransaction)this.databaseAPI.beginTx();
    }

    @AfterEach
    void tearDown() {
        if (this.transaction != null) {
            this.transaction.close();
        }
    }

    @Test
    void deleteRelationshipRequireTransaction() {
        Relationship relationship = this.detachedRelationship();
        Assertions.assertThrows(NotInTransactionException.class, () -> ((Relationship)relationship).delete());
    }

    @Test
    void startNodeAccessRequireTransaction() {
        Relationship relationship = this.detachedRelationship();
        Assertions.assertThrows(NotInTransactionException.class, () -> ((Relationship)relationship).getStartNode());
    }

    @Test
    void endNodeAccessRequireTransaction() {
        Relationship relationship = this.detachedRelationship();
        Assertions.assertThrows(NotInTransactionException.class, () -> ((Relationship)relationship).getEndNode());
    }

    @Test
    void otherNodeAccessRequireTransaction() {
        Relationship relationship = this.detachedRelationship();
        Assertions.assertThrows(NotInTransactionException.class, () -> relationship.getOtherNode((Node)new NodeEntity(null, 7L)));
    }

    @Test
    void nodesAccessRequireTransaction() {
        Relationship relationship = this.detachedRelationship();
        Assertions.assertThrows(NotInTransactionException.class, () -> ((Relationship)relationship).getNodes());
    }

    @Test
    void relationshipTypeAccessRequireTransaction() {
        Relationship relationship = this.detachedRelationship();
        Assertions.assertThrows(NotInTransactionException.class, () -> ((Relationship)relationship).getType());
    }

    @Test
    void relationshipTypeCheckAccessRequireTransaction() {
        Relationship relationship = this.detachedRelationship();
        Assertions.assertThrows(NotInTransactionException.class, () -> relationship.isType(RelationshipType.withName((String)"any")));
    }

    @Test
    void startNodeIdAccessRequireTransaction() {
        Relationship relationship = this.detachedRelationship();
        Assertions.assertThrows(NotInTransactionException.class, () -> ((Relationship)relationship).getStartNodeId());
    }

    @Test
    void endNodeIdAccessRequireTransaction() {
        Relationship relationship = this.detachedRelationship();
        Assertions.assertThrows(NotInTransactionException.class, () -> ((Relationship)relationship).getEndNodeId());
    }

    private Relationship detachedRelationship() {
        Node startNode = this.transaction.createNode();
        Node endNode = this.transaction.createNode();
        Relationship relationship = this.transaction.getRelationshipById(startNode.createRelationshipTo(endNode, RelationshipType.withName((String)"type")).getId());
        this.transaction.close();
        return relationship;
    }
}

