/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.Extensions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.neo4j.configuration.Config;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurve;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.OtherThreadExtension;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.OtherThreadRule;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@Extensions(value={@ExtendWith(value={OtherThreadExtension.class}), @ExtendWith(value={RandomExtension.class})})
public abstract class NodeIndexOrderTestBase<G extends KernelAPIWriteTestSupport>
extends KernelAPIWriteTestBase<G> {
    private final String indexName = "myIndex";
    @Inject
    private OtherThreadRule otherThreadRule;
    @Inject
    private RandomRule random;

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldRangeScanInOrder(IndexOrder indexOrder) throws Exception {
        ArrayList<Pair<Long, Value>> expected = new ArrayList<Pair<Long, Value>>();
        try (KernelTransaction tx = this.beginTransaction();){
            expected.add(this.nodeWithProp(tx, "hello"));
            this.nodeWithProp(tx, "bellow");
            expected.add(this.nodeWithProp(tx, "schmello"));
            expected.add(this.nodeWithProp(tx, "low"));
            expected.add(this.nodeWithProp(tx, "trello"));
            this.nodeWithProp(tx, "yellow");
            expected.add(this.nodeWithProp(tx, "loww"));
            this.nodeWithProp(tx, "below");
            tx.commit();
        }
        this.createIndex();
        tx = this.beginTransaction();
        try {
            int prop = tx.tokenRead().propertyKey("prop");
            IndexReadSession index = tx.dataRead().indexReadSession(tx.schemaRead().indexGetForName("myIndex"));
            try (NodeValueIndexCursor cursor = tx.cursors().allocateNodeValueIndexCursor(tx.pageCursorTracer(), tx.memoryTracker());){
                this.nodeWithProp(tx, "allow");
                expected.add(this.nodeWithProp(tx, "now"));
                expected.add(this.nodeWithProp(tx, "jello"));
                this.nodeWithProp(tx, "willow");
                IndexQuery.RangePredicate query = IndexQuery.range((int)prop, (String)"hello", (boolean)true, (String)"trello", (boolean)true);
                tx.dataRead().nodeIndexSeek(index, cursor, IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)true), new IndexQuery[]{query});
                this.assertResultsInOrder(expected, cursor, indexOrder);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldLabelScanInOrder(IndexOrder indexOrder) throws Exception {
        ArrayList<Long> expected = new ArrayList<Long>();
        try (KernelTransaction tx = this.beginTransaction();){
            expected.add(this.nodeWithLabel(tx, "INSIDE"));
            this.nodeWithLabel(tx, "OUTSIDE1");
            expected.add(this.nodeWithLabel(tx, "INSIDE"));
            expected.add(this.nodeWithLabel(tx, "INSIDE"));
            expected.add(this.nodeWithLabel(tx, "INSIDE"));
            this.nodeWithLabel(tx, "OUTSIDE2");
            expected.add(this.nodeWithLabel(tx, "INSIDE"));
            expected.add(this.nodeWithLabel(tx, "INSIDE"));
            expected.add(this.nodeWithLabel(tx, "INSIDE"));
            expected.add(this.nodeWithLabel(tx, "INSIDE"));
            this.nodeWithLabel(tx, "OUTSIDE1");
            expected.add(this.nodeWithLabel(tx, "INSIDE"));
            this.nodeWithLabel(tx, "OUTSIDE1");
            this.nodeWithLabel(tx, "OUTSIDE1");
            this.nodeWithLabel(tx, "OUTSIDE2");
            expected.add(this.nodeWithLabel(tx, "INSIDE"));
            this.nodeWithLabel(tx, "OUTSIDE2");
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            int label = tx.tokenRead().nodeLabel("INSIDE");
            tx.dataRead().prepareForLabelScans();
            try (NodeLabelIndexCursor cursor = tx.cursors().allocateNodeLabelIndexCursor(tx.pageCursorTracer());){
                this.nodeWithLabel(tx, "OUTSIDE1");
                this.nodeWithLabel(tx, "OUTSIDE1");
                expected.add(this.nodeWithLabel(tx, "INSIDE"));
                this.nodeWithLabel(tx, "OUTSIDE1");
                this.nodeWithLabel(tx, "OUTSIDE2");
                expected.add(this.nodeWithLabel(tx, "INSIDE"));
                expected.add(this.nodeWithLabel(tx, "INSIDE"));
                expected.add(this.nodeWithLabel(tx, "INSIDE"));
                this.nodeWithLabel(tx, "OUTSIDE2");
                expected.add(this.nodeWithLabel(tx, "INSIDE"));
                tx.dataRead().nodeLabelScan(label, cursor, indexOrder);
                this.assertResultsInOrder(expected, cursor, indexOrder);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldPrefixScanInOrder(IndexOrder indexOrder) throws Exception {
        ArrayList<Pair<Long, Value>> expected = new ArrayList<Pair<Long, Value>>();
        try (KernelTransaction tx = this.beginTransaction();){
            expected.add(this.nodeWithProp(tx, "bee hive"));
            this.nodeWithProp(tx, "a");
            expected.add(this.nodeWithProp(tx, "become"));
            expected.add(this.nodeWithProp(tx, "be"));
            expected.add(this.nodeWithProp(tx, "bachelor"));
            this.nodeWithProp(tx, "street smart");
            expected.add(this.nodeWithProp(tx, "builder"));
            this.nodeWithProp(tx, "ceasar");
            tx.commit();
        }
        this.createIndex();
        tx = this.beginTransaction();
        try {
            int prop = tx.tokenRead().propertyKey("prop");
            IndexReadSession index = tx.dataRead().indexReadSession(tx.schemaRead().indexGetForName("myIndex"));
            try (NodeValueIndexCursor cursor = tx.cursors().allocateNodeValueIndexCursor(tx.pageCursorTracer(), tx.memoryTracker());){
                this.nodeWithProp(tx, "allow");
                expected.add(this.nodeWithProp(tx, "bastard"));
                expected.add(this.nodeWithProp(tx, "bully"));
                this.nodeWithProp(tx, "willow");
                IndexQuery.StringPrefixPredicate query = IndexQuery.stringPrefix((int)prop, (TextValue)Values.stringValue((String)"b"));
                tx.dataRead().nodeIndexSeek(index, cursor, IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)true), new IndexQuery[]{query});
                this.assertResultsInOrder(expected, cursor, indexOrder);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldNodeIndexScanInOrderWithPointsAndSingleNodeAfterwards(IndexOrder indexOrder) throws Exception {
        ArrayList<Pair<Long, Value>> expected = new ArrayList<Pair<Long, Value>>();
        try (KernelTransaction tx = this.beginTransaction();){
            expected.add(this.nodeWithProp(tx, "a"));
            expected.add(this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{-500000.0, -500000.0})));
            expected.add(this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{500000.0, -500000.0})));
            expected.add(this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{-500000.0, 500000.0})));
            expected.add(this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{500000.0, 500000.0})));
            tx.commit();
        }
        this.createIndex();
        tx = this.beginTransaction();
        try {
            IndexReadSession index = tx.dataRead().indexReadSession(tx.schemaRead().indexGetForName("myIndex"));
            try (NodeValueIndexCursor cursor = tx.cursors().allocateNodeValueIndexCursor(tx.pageCursorTracer(), tx.memoryTracker());){
                expected.add(this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{-400000.0, -400000.0})));
                expected.add(this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{400000.0, -400000.0})));
                expected.add(this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{-400000.0, 400000.0})));
                expected.add(this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{400000.0, 400000.0})));
                expected.add(this.nodeWithProp(tx, "b"));
                tx.dataRead().nodeIndexScan(index, cursor, IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)true));
                this.assertResultsInOrder(expected, cursor, indexOrder);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldNodeIndexScanInOrderWithPointsWithinSameTile(IndexOrder indexOrder) throws Exception {
        Config config = Config.defaults();
        IndexSpecificSpaceFillingCurveSettings indexSettings = IndexSpecificSpaceFillingCurveSettings.fromConfig((Config)config);
        SpaceFillingCurve curve = indexSettings.forCrs(CoordinateReferenceSystem.WGS84);
        int nbrOfValues = 10000;
        PointValue origin = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{0.0, 0.0});
        Long derivedValueForCenterPoint = curve.derivedValueFor(origin.coordinate());
        double[] centerPoint = curve.centerPointFor(derivedValueForCenterPoint.longValue());
        double xWidthMultiplier = curve.getTileWidth(0, curve.getMaxLevel()) / 2.0;
        double yWidthMultiplier = curve.getTileWidth(1, curve.getMaxLevel()) / 2.0;
        ArrayList<Pair<Long, Value>> expected = new ArrayList<Pair<Long, Value>>();
        try (KernelTransaction tx = this.beginTransaction();){
            expected.add(this.nodeWithProp(tx, "a"));
            expected.add(this.nodeWithProp(tx, "b"));
            for (int i = 0; i < nbrOfValues / 8; ++i) {
                double x1 = (this.random.nextDouble() * 2.0 - 1.0) * xWidthMultiplier;
                double x2 = (this.random.nextDouble() * 2.0 - 1.0) * xWidthMultiplier;
                double y1 = (this.random.nextDouble() * 2.0 - 1.0) * yWidthMultiplier;
                double y2 = (this.random.nextDouble() * 2.0 - 1.0) * yWidthMultiplier;
                expected.add(this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{centerPoint[0] + x1, centerPoint[1] + y1})));
                expected.add(this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{centerPoint[0] + x1, centerPoint[1] + y2})));
                expected.add(this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{centerPoint[0] + x2, centerPoint[1] + y1})));
                expected.add(this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{centerPoint[0] + x2, centerPoint[1] + y2})));
            }
            tx.commit();
        }
        this.createIndex();
        tx = this.beginTransaction();
        try {
            IndexReadSession index = tx.dataRead().indexReadSession(tx.schemaRead().indexGetForName("myIndex"));
            try (NodeValueIndexCursor cursor = tx.cursors().allocateNodeValueIndexCursor(tx.pageCursorTracer(), tx.memoryTracker());){
                for (int i = 0; i < nbrOfValues / 8; ++i) {
                    double x1 = (this.random.nextDouble() * 2.0 - 1.0) * xWidthMultiplier;
                    double x2 = (this.random.nextDouble() * 2.0 - 1.0) * xWidthMultiplier;
                    double y1 = (this.random.nextDouble() * 2.0 - 1.0) * yWidthMultiplier;
                    double y2 = (this.random.nextDouble() * 2.0 - 1.0) * yWidthMultiplier;
                    expected.add(this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{centerPoint[0] + x1, centerPoint[1] + y1})));
                    expected.add(this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{centerPoint[0] + x1, centerPoint[1] + y2})));
                    expected.add(this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{centerPoint[0] + x2, centerPoint[1] + y1})));
                    expected.add(this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{centerPoint[0] + x2, centerPoint[1] + y2})));
                }
                expected.add(this.nodeWithProp(tx, "c"));
                expected.add(this.nodeWithProp(tx, "d"));
                tx.dataRead().nodeIndexScan(index, cursor, IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)true));
                this.assertResultsInOrder(expected, cursor, indexOrder);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldNodeIndexScanInOrderPointsOnly(IndexOrder indexOrder) throws Exception {
        ArrayList<Pair<Long, Value>> expected = new ArrayList<Pair<Long, Value>>();
        try (KernelTransaction tx = this.beginTransaction();){
            expected.add(this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{-500000.0, -500000.0})));
            expected.add(this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{500000.0, -500000.0})));
            expected.add(this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{-500000.0, 500000.0})));
            expected.add(this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{500000.0, 500000.0})));
            tx.commit();
        }
        this.createIndex();
        tx = this.beginTransaction();
        try {
            IndexReadSession index = tx.dataRead().indexReadSession(tx.schemaRead().indexGetForName("myIndex"));
            try (NodeValueIndexCursor cursor = tx.cursors().allocateNodeValueIndexCursor(tx.pageCursorTracer(), tx.memoryTracker());){
                expected.add(this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{-400000.0, -400000.0})));
                expected.add(this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{400000.0, -400000.0})));
                expected.add(this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{-400000.0, 400000.0})));
                expected.add(this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{400000.0, 400000.0})));
                tx.dataRead().nodeIndexScan(index, cursor, IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)true));
                this.assertResultsInOrder(expected, cursor, indexOrder);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldNodeIndexScanInOrderWithPointsAndNodesOnBothSides(IndexOrder indexOrder) throws Exception {
        ArrayList<Pair<Long, Value>> expected = new ArrayList<Pair<Long, Value>>();
        try (KernelTransaction tx = this.beginTransaction();){
            expected.add(this.nodeWithProp(tx, new String[]{"a"}));
            expected.add(this.nodeWithProp(tx, new String[]{"b"}));
            expected.add(this.nodeWithProp(tx, new String[]{"c"}));
            expected.add(this.nodeWithProp(tx, "a"));
            expected.add(this.nodeWithProp(tx, "b"));
            expected.add(this.nodeWithProp(tx, "c"));
            expected.add(this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{-500000.0, -500000.0})));
            expected.add(this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{500000.0, -500000.0})));
            expected.add(this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{-500000.0, 500000.0})));
            expected.add(this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{500000.0, 500000.0})));
            tx.commit();
        }
        this.createIndex();
        tx = this.beginTransaction();
        try {
            IndexReadSession index = tx.dataRead().indexReadSession(tx.schemaRead().indexGetForName("myIndex"));
            try (NodeValueIndexCursor cursor = tx.cursors().allocateNodeValueIndexCursor(tx.pageCursorTracer(), tx.memoryTracker());){
                expected.add(this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{-400000.0, -400000.0})));
                expected.add(this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{400000.0, -400000.0})));
                expected.add(this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{-400000.0, 400000.0})));
                expected.add(this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{400000.0, 400000.0})));
                expected.add(this.nodeWithProp(tx, new String[]{"d"}));
                expected.add(this.nodeWithProp(tx, "d"));
                tx.dataRead().nodeIndexScan(index, cursor, IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)true));
                this.assertResultsInOrder(expected, cursor, indexOrder);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldNodeIndexScanInOrderWithPointsAndNodesBefore(IndexOrder indexOrder) throws Exception {
        ArrayList<Pair<Long, Value>> expected = new ArrayList<Pair<Long, Value>>();
        try (KernelTransaction tx = this.beginTransaction();){
            expected.add(this.nodeWithProp(tx, new String[]{"a"}));
            expected.add(this.nodeWithProp(tx, new String[]{"b"}));
            expected.add(this.nodeWithProp(tx, new String[]{"c"}));
            expected.add(this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{-500000.0, -500000.0})));
            expected.add(this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{500000.0, -500000.0})));
            expected.add(this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{-500000.0, 500000.0})));
            expected.add(this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{500000.0, 500000.0})));
            tx.commit();
        }
        this.createIndex();
        tx = this.beginTransaction();
        try {
            IndexReadSession index = tx.dataRead().indexReadSession(tx.schemaRead().indexGetForName("myIndex"));
            try (NodeValueIndexCursor cursor = tx.cursors().allocateNodeValueIndexCursor(tx.pageCursorTracer(), tx.memoryTracker());){
                expected.add(this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{-400000.0, -400000.0})));
                expected.add(this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{400000.0, -400000.0})));
                expected.add(this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{-400000.0, 400000.0})));
                expected.add(this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{400000.0, 400000.0})));
                expected.add(this.nodeWithProp(tx, new String[]{"d"}));
                tx.dataRead().nodeIndexScan(index, cursor, IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)true));
                this.assertResultsInOrder(expected, cursor, indexOrder);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldDoOrderedCompositeIndexScanWithPointsInBothValues(IndexOrder indexOrder) throws Exception {
        ArrayList<Pair<Long, Value[]>> expected = new ArrayList<Pair<Long, Value[]>>();
        try (KernelTransaction tx = this.beginTransaction();){
            expected.add(this.nodeWithTwoProps(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{-500000.0, -500000.0}), "a"));
            expected.add(this.nodeWithTwoProps(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{500000.0, -500000.0}), "a"));
            expected.add(this.nodeWithTwoProps(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{-500000.0, 500000.0}), "a"));
            expected.add(this.nodeWithTwoProps(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{500000.0, 500000.0}), "a"));
            expected.add(this.nodeWithTwoProps(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{-500000.0, -500000.0}), "b"));
            expected.add(this.nodeWithTwoProps(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{500000.0, -500000.0}), "b"));
            expected.add(this.nodeWithTwoProps(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{-500000.0, 500000.0}), "b"));
            expected.add(this.nodeWithTwoProps(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{500000.0, 500000.0}), "b"));
            expected.add(this.nodeWithTwoProps(tx, "a", Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{-500000.0, -500000.0})));
            expected.add(this.nodeWithTwoProps(tx, "a", Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{500000.0, -500000.0})));
            expected.add(this.nodeWithTwoProps(tx, "a", Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{-500000.0, 500000.0})));
            expected.add(this.nodeWithTwoProps(tx, "a", Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{500000.0, 500000.0})));
            tx.commit();
        }
        this.createCompositeIndex();
        tx = this.beginTransaction();
        try {
            IndexReadSession index = tx.dataRead().indexReadSession(tx.schemaRead().indexGetForName("myIndex"));
            try (NodeValueIndexCursor cursor = tx.cursors().allocateNodeValueIndexCursor(tx.pageCursorTracer(), tx.memoryTracker());){
                tx.dataRead().nodeIndexScan(index, cursor, IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)true));
                this.assertCompositeResultsInOrder(expected, cursor, indexOrder);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldDoOrderedCompositeIndexScanWithPointsInBothValuesWithOneGapBetween(IndexOrder indexOrder) throws Exception {
        ArrayList<Pair<Long, Value[]>> expected = new ArrayList<Pair<Long, Value[]>>();
        try (KernelTransaction tx = this.beginTransaction();){
            expected.add(this.nodeWithTwoProps(tx, new String[]{"a"}, new String[]{"b"}));
            expected.add(this.nodeWithTwoProps(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{-500000.0, -500000.0}), "a"));
            expected.add(this.nodeWithTwoProps(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{500000.0, -500000.0}), "a"));
            expected.add(this.nodeWithTwoProps(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{-500000.0, 500000.0}), "a"));
            expected.add(this.nodeWithTwoProps(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{500000.0, 500000.0}), "a"));
            expected.add(this.nodeWithTwoProps(tx, "b", new String[]{"b"}));
            expected.add(this.nodeWithTwoProps(tx, "b", Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{-500000.0, -500000.0})));
            expected.add(this.nodeWithTwoProps(tx, "b", Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{500000.0, -500000.0})));
            expected.add(this.nodeWithTwoProps(tx, "b", Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{-500000.0, 500000.0})));
            expected.add(this.nodeWithTwoProps(tx, "b", Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{500000.0, 500000.0})));
            expected.add(this.nodeWithTwoProps(tx, "c", new String[]{"b"}));
            tx.commit();
        }
        this.createCompositeIndex();
        tx = this.beginTransaction();
        try {
            IndexReadSession index = tx.dataRead().indexReadSession(tx.schemaRead().indexGetForName("myIndex"));
            try (NodeValueIndexCursor cursor = tx.cursors().allocateNodeValueIndexCursor(tx.pageCursorTracer(), tx.memoryTracker());){
                tx.dataRead().nodeIndexScan(index, cursor, IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)true));
                this.assertCompositeResultsInOrder(expected, cursor, indexOrder);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldDoOrderedCompositeIndexScanWithPointsInBothValuesWithTwoGapsBetween(IndexOrder indexOrder) throws Exception {
        ArrayList<Pair<Long, Value[]>> expected = new ArrayList<Pair<Long, Value[]>>();
        try (KernelTransaction tx = this.beginTransaction();){
            expected.add(this.nodeWithTwoProps(tx, new String[]{"a"}, new String[]{"b"}));
            expected.add(this.nodeWithTwoProps(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{-500000.0, -500000.0}), "a"));
            expected.add(this.nodeWithTwoProps(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{500000.0, -500000.0}), "a"));
            expected.add(this.nodeWithTwoProps(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{-500000.0, 500000.0}), "a"));
            expected.add(this.nodeWithTwoProps(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{500000.0, 500000.0}), "a"));
            expected.add(this.nodeWithTwoProps(tx, "b", new String[]{"b"}));
            expected.add(this.nodeWithTwoProps(tx, "b", new String[]{"c"}));
            expected.add(this.nodeWithTwoProps(tx, "b", Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{-500000.0, -500000.0})));
            expected.add(this.nodeWithTwoProps(tx, "b", Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{500000.0, -500000.0})));
            expected.add(this.nodeWithTwoProps(tx, "b", Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{-500000.0, 500000.0})));
            expected.add(this.nodeWithTwoProps(tx, "b", Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{500000.0, 500000.0})));
            expected.add(this.nodeWithTwoProps(tx, "c", new String[]{"b"}));
            tx.commit();
        }
        this.createCompositeIndex();
        tx = this.beginTransaction();
        try {
            IndexReadSession index = tx.dataRead().indexReadSession(tx.schemaRead().indexGetForName("myIndex"));
            try (NodeValueIndexCursor cursor = tx.cursors().allocateNodeValueIndexCursor(tx.pageCursorTracer(), tx.memoryTracker());){
                tx.dataRead().nodeIndexScan(index, cursor, IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)true));
                this.assertCompositeResultsInOrder(expected, cursor, indexOrder);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldNodeCompositeIndexScanInOrderWithPointsAndSingleNodeAfterwards(IndexOrder indexOrder) throws Exception {
        ArrayList<Pair<Long, Value[]>> expected = new ArrayList<Pair<Long, Value[]>>();
        try (KernelTransaction tx = this.beginTransaction();){
            expected.add(this.nodeWithTwoProps(tx, new String[]{"a"}, new String[]{"b"}));
            expected.add(this.nodeWithTwoProps(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{-500000.0, -500000.0}), "a"));
            expected.add(this.nodeWithTwoProps(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{500000.0, -500000.0}), "a"));
            expected.add(this.nodeWithTwoProps(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{-500000.0, 500000.0}), "a"));
            expected.add(this.nodeWithTwoProps(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{500000.0, 500000.0}), "a"));
            expected.add(this.nodeWithTwoProps(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{-500000.0, -500000.0}), "b"));
            expected.add(this.nodeWithTwoProps(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{500000.0, -500000.0}), "b"));
            expected.add(this.nodeWithTwoProps(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{-500000.0, 500000.0}), "b"));
            expected.add(this.nodeWithTwoProps(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{500000.0, 500000.0}), "b"));
            expected.add(this.nodeWithTwoProps(tx, "a", Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{500000.0, 500000.0})));
            expected.add(this.nodeWithTwoProps(tx, "b", new String[]{"b"}));
            expected.add(this.nodeWithTwoProps(tx, "b", Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{-500000.0, -500000.0})));
            expected.add(this.nodeWithTwoProps(tx, "b", Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{500000.0, -500000.0})));
            expected.add(this.nodeWithTwoProps(tx, "b", Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{-500000.0, 500000.0})));
            expected.add(this.nodeWithTwoProps(tx, "b", Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{500000.0, 500000.0})));
            expected.add(this.nodeWithTwoProps(tx, "c", new String[]{"b"}));
            tx.commit();
        }
        this.createCompositeIndex();
        tx = this.beginTransaction();
        try {
            IndexReadSession index = tx.dataRead().indexReadSession(tx.schemaRead().indexGetForName("myIndex"));
            try (NodeValueIndexCursor cursor = tx.cursors().allocateNodeValueIndexCursor(tx.pageCursorTracer(), tx.memoryTracker());){
                tx.dataRead().nodeIndexScan(index, cursor, IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)true));
                this.assertCompositeResultsInOrder(expected, cursor, indexOrder);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldNodeIndexScanInOrderWithStringInMemoryAndConcurrentUpdate(IndexOrder indexOrder) throws Exception {
        IndexQuery.StringPrefixPredicate query;
        NodeValueIndexCursor cursor;
        IndexReadSession index;
        int prop;
        String a = "a";
        String b = "b";
        String c = "c";
        this.createIndex();
        TextValue expectedFirst = indexOrder == IndexOrder.ASCENDING ? Values.stringValue((String)a) : Values.stringValue((String)c);
        TextValue expectedLast = indexOrder == IndexOrder.ASCENDING ? Values.stringValue((String)c) : Values.stringValue((String)a);
        try (KernelTransaction tx = this.beginTransaction();){
            prop = tx.tokenRead().propertyKey("prop");
            this.nodeWithProp(tx, a);
            this.nodeWithProp(tx, c);
            index = tx.dataRead().indexReadSession(tx.schemaRead().indexGetForName("myIndex"));
            cursor = tx.cursors().allocateNodeValueIndexCursor(tx.pageCursorTracer(), tx.memoryTracker());
            try {
                query = IndexQuery.stringPrefix((int)prop, (TextValue)Values.stringValue((String)""));
                tx.dataRead().nodeIndexSeek(index, cursor, IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)true), new IndexQuery[]{query});
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                Assertions.assertThat((Object)cursor.propertyValue(0)).isEqualTo((Object)expectedFirst);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                Assertions.assertThat((Object)cursor.propertyValue(0)).isEqualTo((Object)expectedLast);
                this.concurrentInsert(b);
                org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next(), () -> "Did not expect to find anything more but found " + cursor.propertyValue(0));
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            prop = tx.tokenRead().propertyKey("prop");
            index = tx.dataRead().indexReadSession(tx.schemaRead().indexGetForName("myIndex"));
            cursor = tx.cursors().allocateNodeValueIndexCursor(tx.pageCursorTracer(), tx.memoryTracker());
            try {
                query = IndexQuery.stringPrefix((int)prop, (TextValue)Values.stringValue((String)""));
                tx.dataRead().nodeIndexSeek(index, cursor, IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)true), new IndexQuery[]{query});
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                Assertions.assertThat((Object)cursor.propertyValue(0)).isEqualTo((Object)expectedFirst);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                Assertions.assertThat((Object)cursor.propertyValue(0)).isEqualTo((Object)Values.stringValue((String)b));
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                Assertions.assertThat((Object)cursor.propertyValue(0)).isEqualTo((Object)expectedLast);
                org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private void concurrentInsert(Object value) throws InterruptedException, ExecutionException {
        this.otherThreadRule.execute(() -> {
            try (KernelTransaction otherTx = this.beginTransaction();){
                this.nodeWithProp(otherTx, value);
                otherTx.commit();
            }
            return null;
        }).get();
    }

    private void assertResultsInOrder(List<Pair<Long, Value>> expected, NodeValueIndexCursor cursor, IndexOrder indexOrder) {
        Comparator comparator = indexOrder == IndexOrder.ASCENDING ? (a, b) -> Values.COMPARATOR.compare((Value)a.other(), (Value)b.other()) : (a, b) -> Values.COMPARATOR.compare((Value)b.other(), (Value)a.other());
        expected.sort(comparator);
        Iterator<Pair<Long, Value>> expectedRows = expected.iterator();
        while (cursor.next() && expectedRows.hasNext()) {
            Pair<Long, Value> expectedRow = expectedRows.next();
            ((AbstractLongAssert)Assertions.assertThat((long)cursor.nodeReference()).as(expectedRow.other() + " == " + cursor.propertyValue(0), new Object[0])).isEqualTo(expectedRow.first());
            for (int i = 0; i < cursor.numberOfProperties(); ++i) {
                Value value = cursor.propertyValue(i);
                Assertions.assertThat((Object)value).isEqualTo(expectedRow.other());
            }
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)expectedRows.hasNext());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
    }

    private void assertCompositeResultsInOrder(List<Pair<Long, Value[]>> expected, NodeValueIndexCursor cursor, IndexOrder indexOrder) {
        Comparator comparator = indexOrder == IndexOrder.ASCENDING ? (a, b) -> {
            int compare = Values.COMPARATOR.compare(((Value[])a.other())[0], ((Value[])b.other())[0]);
            if (compare == 0) {
                return Values.COMPARATOR.compare(((Value[])a.other())[1], ((Value[])b.other())[1]);
            }
            return compare;
        } : (a, b) -> {
            int compare = -Values.COMPARATOR.compare(((Value[])a.other())[0], ((Value[])b.other())[0]);
            if (compare == 0) {
                return -Values.COMPARATOR.compare(((Value[])a.other())[1], ((Value[])b.other())[1]);
            }
            return compare;
        };
        expected.sort(comparator);
        Iterator<Pair<Long, Value[]>> expectedRows = expected.iterator();
        while (cursor.next() && expectedRows.hasNext()) {
            Pair<Long, Value[]> expectedRow = expectedRows.next();
            ((AbstractLongAssert)Assertions.assertThat((long)cursor.nodeReference()).as(((Value[])expectedRow.other())[0] + " == " + cursor.propertyValue(0) + " && " + ((Value[])expectedRow.other())[1] + " == " + cursor.propertyValue(1), new Object[0])).isEqualTo(expectedRow.first());
            for (int i = 0; i < cursor.numberOfProperties(); ++i) {
                Value value = cursor.propertyValue(i);
                Assertions.assertThat((Object)value).isEqualTo((Object)((Value[])expectedRow.other())[i]);
            }
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)expectedRows.hasNext());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
    }

    private void assertResultsInOrder(List<Long> expected, NodeLabelIndexCursor cursor, IndexOrder indexOrder) {
        Comparator c = indexOrder == IndexOrder.ASCENDING ? Comparator.naturalOrder() : Comparator.reverseOrder();
        expected.sort(c);
        Iterator<Long> expectedRows = expected.iterator();
        while (cursor.next() && expectedRows.hasNext()) {
            long expectedRow = expectedRows.next();
            Assertions.assertThat((long)cursor.nodeReference()).isEqualTo(expectedRow);
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)expectedRows.hasNext());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
    }

    private void createIndex() {
        try (Transaction tx = graphDb.beginTx();){
            tx.schema().indexFor(Label.label((String)"Node")).on("prop").withName("myIndex").create();
            tx.commit();
        }
        tx = graphDb.beginTx();
        try {
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private void createCompositeIndex() {
        try (Transaction tx = graphDb.beginTx();){
            tx.schema().indexFor(Label.label((String)"Node")).on("prop1").on("prop2").withName("myIndex").create();
            tx.commit();
        }
        tx = graphDb.beginTx();
        try {
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private long nodeWithLabel(KernelTransaction tx, String label) throws Exception {
        Write write = tx.dataWrite();
        long node = write.nodeCreate();
        write.nodeAddLabel(node, tx.tokenWrite().labelGetOrCreateForName(label));
        return node;
    }

    private Pair<Long, Value> nodeWithProp(KernelTransaction tx, Object value) throws Exception {
        Write write = tx.dataWrite();
        long node = write.nodeCreate();
        write.nodeAddLabel(node, tx.tokenWrite().labelGetOrCreateForName("Node"));
        Value val = Values.of((Object)value);
        write.nodeSetProperty(node, tx.tokenWrite().propertyKeyGetOrCreateForName("prop"), val);
        return Pair.of((Object)node, (Object)val);
    }

    private Pair<Long, Value[]> nodeWithTwoProps(KernelTransaction tx, Object value1, Object value2) throws Exception {
        Write write = tx.dataWrite();
        long node = write.nodeCreate();
        TokenWrite tokenWrite = tx.tokenWrite();
        write.nodeAddLabel(node, tokenWrite.labelGetOrCreateForName("Node"));
        Value val1 = Values.of((Object)value1);
        Value val2 = Values.of((Object)value2);
        write.nodeSetProperty(node, tokenWrite.propertyKeyGetOrCreateForName("prop1"), val1);
        write.nodeSetProperty(node, tokenWrite.propertyKeyGetOrCreateForName("prop2"), val2);
        return Pair.of((Object)node, (Object)new Value[]{val1, val2});
    }
}

